/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInDialog;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Window;
import java.io.File;

public class Commands
implements PlugIn {
    public void run(String cmd) {
        if (cmd.equals("new")) {
            if (IJ.altKeyDown()) {
                IJ.runPlugIn("ij.plugin.HyperStackConverter", "new");
            } else {
                new NewImage();
            }
        } else if (cmd.equals("open")) {
            if (Prefs.useJFileChooser && !IJ.macroRunning()) {
                new Opener().openMultiple();
            } else {
                new Opener().open();
            }
        } else if (cmd.equals("close")) {
            this.close();
        } else if (cmd.equals("close-all")) {
            this.closeAll();
        } else if (cmd.equals("save")) {
            this.save();
        } else if (cmd.equals("revert")) {
            this.revert();
        } else if (cmd.equals("undo")) {
            this.undo();
        } else if (cmd.equals("ij")) {
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                ij.toFront();
            }
        } else if (cmd.equals("tab")) {
            WindowManager.putBehind();
        } else if (cmd.equals("quit")) {
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                ij.quit();
            }
        } else if (cmd.equals("startup")) {
            this.openStartupMacros();
        }
    }

    void revert() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.revert();
        } else {
            IJ.noImage();
        }
    }

    void save() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (imp.getStackSize() > 1) {
                imp.setIgnoreFlush(true);
                new FileSaver(imp).save();
                imp.setIgnoreFlush(false);
            } else {
                new FileSaver(imp).save();
            }
        } else {
            IJ.noImage();
        }
    }

    void undo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            Undo.undo();
        } else {
            IJ.noImage();
        }
    }

    void close() {
        ImagePlus imp = WindowManager.getCurrentImage();
        Window win = WindowManager.getActiveWindow();
        if (win == null || Interpreter.isBatchMode() && win instanceof ImageWindow) {
            this.closeImage(imp);
        } else if (win instanceof PlugInFrame) {
            ((PlugInFrame)win).close();
        } else if (win instanceof PlugInDialog) {
            ((PlugInDialog)win).close();
        } else if (win instanceof TextWindow) {
            ((TextWindow)win).close();
        } else {
            this.closeImage(imp);
        }
    }

    void closeAll() {
        int[] list = WindowManager.getIDList();
        if (list != null) {
            ImagePlus imp;
            int imagesWithChanges = 0;
            int i = 0;
            while (i < list.length) {
                imp = WindowManager.getImage(list[i]);
                if (imp != null && imp.changes) {
                    ++imagesWithChanges;
                }
                ++i;
            }
            if (imagesWithChanges > 0 && !IJ.macroRunning()) {
                GenericDialog gd = new GenericDialog("Close All");
                String msg = null;
                String pronoun = null;
                if (imagesWithChanges == 1) {
                    msg = "There is one image";
                    pronoun = "it";
                } else {
                    msg = "There are " + imagesWithChanges + " images";
                    pronoun = "they";
                }
                gd.addMessage(String.valueOf(msg) + " with unsaved changes. If you\nclick \"OK\" " + pronoun + " will be closed without being saved.");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
            }
            i = 0;
            while (i < list.length) {
                imp = WindowManager.getImage(list[i]);
                if (imp != null) {
                    imp.changes = false;
                    imp.close();
                }
                ++i;
            }
        }
    }

    void closeImage(ImagePlus imp) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.close();
        if (Recorder.record && !IJ.isMacro()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp.close();");
            } else {
                Recorder.record("close");
            }
            Recorder.setCommand(null);
        }
    }

    void openStartupMacros() {
        Applet applet = IJ.getApplet();
        if (applet != null) {
            IJ.run("URL...", "url=http://imagej.nih.gov/ij/applet/StartupMacros.txt");
        } else {
            String path = String.valueOf(IJ.getDirectory("macros")) + "/StartupMacros.txt";
            File f = new File(path);
            if (!f.exists()) {
                IJ.error("\"StartupMacros.txt\" not found in ImageJ/macros/");
            } else {
                IJ.open(path);
            }
        }
    }
}

