/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    public static final int TRANSFORM = 6;
    public static final int OVERLAY_ADDITION = 7;
    public static final int ROI = 8;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;
    private static ImagePlus impCopy;
    private static Calibration calCopy;
    private static Roi roiCopy;
    private static double displayRangeMin;
    private static double displayRangeMax;

    static {
        ipCopy = null;
    }

    public static void setup(int what, ImagePlus imp) {
        if (imp == null) {
            whatToUndo = 0;
            Undo.reset();
            return;
        }
        if (what == 1 && whatToUndo == 4) {
            return;
        }
        if (what == 5) {
            if (whatToUndo == 4) {
                whatToUndo = what;
            }
            return;
        }
        whatToUndo = what;
        imageID = imp.getID();
        if (what == 2) {
            ipCopy = imp.getProcessor();
            calCopy = (Calibration)imp.getCalibration().clone();
        } else if (what == 6) {
            impCopy = new ImagePlus(imp.getTitle(), imp.getProcessor().duplicate());
        } else if (what == 4) {
            ImageProcessor ip = imp.getProcessor();
            ipCopy = ip != null ? ip.duplicate() : null;
        } else if (what == 7) {
            impCopy = null;
            ipCopy = null;
        } else if (what == 8) {
            impCopy = null;
            ipCopy = null;
            Roi roi = imp.getRoi();
            if (roi != null) {
                roiCopy = (Roi)roi.clone();
                roiCopy.setImage(null);
            } else {
                whatToUndo = 0;
            }
        } else {
            ipCopy = null;
            ImageProcessor imageProcessor = imp.getProcessor();
        }
    }

    public static void reset() {
        if (whatToUndo == 4 || whatToUndo == 7) {
            return;
        }
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
        impCopy = null;
        calCopy = null;
        roiCopy = null;
    }

    public static void undo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imageID != imp.getID()) {
            if (imp != null && !IJ.macroRunning()) {
                ImageProcessor ip2 = imp.getProcessor();
                ip2.swapPixelArrays();
                imp.updateAndDraw();
            } else {
                Undo.reset();
            }
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor ip = imp.getProcessor();
                if (ip == null) break;
                if (!IJ.macroRunning()) {
                    ip.swapPixelArrays();
                    imp.updateAndDraw();
                    return;
                }
                ip.reset();
                imp.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                if (whatToUndo == 2 && calCopy != null) {
                    imp.setCalibration(calCopy);
                }
                if (Undo.swapImages(new ImagePlus("", ipCopy), imp)) {
                    imp.updateAndDraw();
                    return;
                }
                imp.setProcessor(null, ipCopy);
                break;
            }
            case 6: {
                if (impCopy == null) break;
                if (Undo.swapImages(impCopy, imp)) {
                    imp.updateAndDraw();
                    return;
                }
                imp.setProcessor(impCopy.getTitle(), impCopy.getProcessor());
                break;
            }
            case 3: {
                Roi roi = imp.getRoi();
                if (roi == null) break;
                roi.abortPaste();
                break;
            }
            case 8: {
                Roi roiCopy2 = roiCopy;
                Undo.setup(8, imp);
                imp.setRoi(roiCopy2);
                return;
            }
            case 7: {
                Overlay overlay = imp.getOverlay();
                if (overlay == null) {
                    IJ.beep();
                    return;
                }
                int size = overlay.size();
                if (size <= 0) {
                    IJ.beep();
                    return;
                }
                overlay.remove(size - 1);
                imp.draw();
                return;
            }
        }
        Undo.reset();
    }

    static boolean swapImages(ImagePlus imp1, ImagePlus imp2) {
        if (imp1.getWidth() != imp2.getWidth() || imp1.getHeight() != imp2.getHeight() || imp1.getBitDepth() != imp2.getBitDepth() || IJ.macroRunning()) {
            return false;
        }
        ImageProcessor ip1 = imp1.getProcessor();
        ImageProcessor ip2 = imp2.getProcessor();
        double min1 = ip1.getMin();
        double max1 = ip1.getMax();
        double min2 = ip2.getMin();
        double max2 = ip2.getMax();
        ip2.setSnapshotPixels(ip1.getPixels());
        ip2.swapPixelArrays();
        ip1.setPixels(ip2.getSnapshotPixels());
        ip2.setSnapshotPixels(null);
        ip1.setMinAndMax(min2, max2);
        ip2.setMinAndMax(min1, max1);
        return true;
    }
}

