/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.org.apache.poi.ss.usermodel.BorderFormatting;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Color;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFColor;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class XSSFBorderFormatting
implements BorderFormatting {
    CTBorder _border;

    XSSFBorderFormatting(CTBorder border) {
        this._border = border;
    }

    public short getBorderBottom() {
        STBorderStyle.Enum ptrn = this._border.isSetBottom() ? this._border.getBottom().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public short getBorderDiagonal() {
        STBorderStyle.Enum ptrn = this._border.isSetDiagonal() ? this._border.getDiagonal().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public short getBorderLeft() {
        STBorderStyle.Enum ptrn = this._border.isSetLeft() ? this._border.getLeft().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public short getBorderRight() {
        STBorderStyle.Enum ptrn = this._border.isSetRight() ? this._border.getRight().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public short getBorderTop() {
        STBorderStyle.Enum ptrn = this._border.isSetTop() ? this._border.getTop().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    public XSSFColor getBottomBorderColorColor() {
        if (!this._border.isSetBottom()) {
            return null;
        }
        CTBorderPr pr = this._border.getBottom();
        return new XSSFColor(pr.getColor());
    }

    public short getBottomBorderColor() {
        XSSFColor color = this.getBottomBorderColorColor();
        if (color == null) {
            return 0;
        }
        return color.getIndexed();
    }

    public XSSFColor getDiagonalBorderColorColor() {
        if (!this._border.isSetDiagonal()) {
            return null;
        }
        CTBorderPr pr = this._border.getDiagonal();
        return new XSSFColor(pr.getColor());
    }

    public short getDiagonalBorderColor() {
        XSSFColor color = this.getDiagonalBorderColorColor();
        if (color == null) {
            return 0;
        }
        return color.getIndexed();
    }

    public XSSFColor getLeftBorderColorColor() {
        if (!this._border.isSetLeft()) {
            return null;
        }
        CTBorderPr pr = this._border.getLeft();
        return new XSSFColor(pr.getColor());
    }

    public short getLeftBorderColor() {
        XSSFColor color = this.getLeftBorderColorColor();
        if (color == null) {
            return 0;
        }
        return color.getIndexed();
    }

    public XSSFColor getRightBorderColorColor() {
        if (!this._border.isSetRight()) {
            return null;
        }
        CTBorderPr pr = this._border.getRight();
        return new XSSFColor(pr.getColor());
    }

    public short getRightBorderColor() {
        XSSFColor color = this.getRightBorderColorColor();
        if (color == null) {
            return 0;
        }
        return color.getIndexed();
    }

    public XSSFColor getTopBorderColorColor() {
        if (!this._border.isSetTop()) {
            return null;
        }
        CTBorderPr pr = this._border.getTop();
        return new XSSFColor(pr.getColor());
    }

    public short getTopBorderColor() {
        XSSFColor color = this.getRightBorderColorColor();
        if (color == null) {
            return 0;
        }
        return color.getIndexed();
    }

    public void setBorderBottom(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetBottom() ? this._border.getBottom() : this._border.addNewBottom();
        if (border == 0) {
            this._border.unsetBottom();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
    }

    public void setBorderDiagonal(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetDiagonal() ? this._border.getDiagonal() : this._border.addNewDiagonal();
        if (border == 0) {
            this._border.unsetDiagonal();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
    }

    public void setBorderLeft(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetLeft() ? this._border.getLeft() : this._border.addNewLeft();
        if (border == 0) {
            this._border.unsetLeft();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
    }

    public void setBorderRight(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetRight() ? this._border.getRight() : this._border.addNewRight();
        if (border == 0) {
            this._border.unsetRight();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
    }

    public void setBorderTop(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetTop() ? this._border.getTop() : this._border.addNewTop();
        if (border == 0) {
            this._border.unsetTop();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt(border + 1));
        }
    }

    public void setBottomBorderColor(Color color) {
        XSSFColor xcolor = XSSFColor.toXSSFColor(color);
        if (xcolor == null) {
            this.setBottomBorderColor((CTColor)null);
        } else {
            this.setBottomBorderColor(xcolor.getCTColor());
        }
    }

    public void setBottomBorderColor(short color) {
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed(color);
        this.setBottomBorderColor(ctColor);
    }

    public void setBottomBorderColor(CTColor color) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetBottom() ? this._border.getBottom() : this._border.addNewBottom();
        if (color == null) {
            pr.unsetColor();
        } else {
            pr.setColor(color);
        }
    }

    public void setDiagonalBorderColor(Color color) {
        XSSFColor xcolor = XSSFColor.toXSSFColor(color);
        if (xcolor == null) {
            this.setDiagonalBorderColor((CTColor)null);
        } else {
            this.setDiagonalBorderColor(xcolor.getCTColor());
        }
    }

    public void setDiagonalBorderColor(short color) {
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed(color);
        this.setDiagonalBorderColor(ctColor);
    }

    public void setDiagonalBorderColor(CTColor color) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetDiagonal() ? this._border.getDiagonal() : this._border.addNewDiagonal();
        if (color == null) {
            pr.unsetColor();
        } else {
            pr.setColor(color);
        }
    }

    public void setLeftBorderColor(Color color) {
        XSSFColor xcolor = XSSFColor.toXSSFColor(color);
        if (xcolor == null) {
            this.setLeftBorderColor((CTColor)null);
        } else {
            this.setLeftBorderColor(xcolor.getCTColor());
        }
    }

    public void setLeftBorderColor(short color) {
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed(color);
        this.setLeftBorderColor(ctColor);
    }

    public void setLeftBorderColor(CTColor color) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetLeft() ? this._border.getLeft() : this._border.addNewLeft();
        if (color == null) {
            pr.unsetColor();
        } else {
            pr.setColor(color);
        }
    }

    public void setRightBorderColor(Color color) {
        XSSFColor xcolor = XSSFColor.toXSSFColor(color);
        if (xcolor == null) {
            this.setRightBorderColor((CTColor)null);
        } else {
            this.setRightBorderColor(xcolor.getCTColor());
        }
    }

    public void setRightBorderColor(short color) {
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed(color);
        this.setRightBorderColor(ctColor);
    }

    public void setRightBorderColor(CTColor color) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetRight() ? this._border.getRight() : this._border.addNewRight();
        if (color == null) {
            pr.unsetColor();
        } else {
            pr.setColor(color);
        }
    }

    public void setTopBorderColor(Color color) {
        XSSFColor xcolor = XSSFColor.toXSSFColor(color);
        if (xcolor == null) {
            this.setTopBorderColor((CTColor)null);
        } else {
            this.setTopBorderColor(xcolor.getCTColor());
        }
    }

    public void setTopBorderColor(short color) {
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed(color);
        this.setTopBorderColor(ctColor);
    }

    public void setTopBorderColor(CTColor color) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetTop() ? this._border.getTop() : this._border.addNewTop();
        if (color == null) {
            pr.unsetColor();
        } else {
            pr.setColor(color);
        }
    }
}

