/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.model;

import com.fr.third.v2.org.apache.poi.POIXMLDocumentPart;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.poi.ss.SpreadsheetVersion;
import com.fr.third.v2.org.apache.poi.ss.usermodel.FontFamily;
import com.fr.third.v2.org.apache.poi.ss.usermodel.FontScheme;
import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.poi.xssf.model.ThemesTable;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFFactory;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFFont;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRelation;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorders;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyleXfs;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellXfs;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxfs;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFills;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFonts;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmts;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.StyleSheetDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesTable
extends POIXMLDocumentPart {
    private final SortedMap<Short, String> numberFormats = new TreeMap<Short, String>();
    private final List<XSSFFont> fonts = new ArrayList<XSSFFont>();
    private final List<XSSFCellFill> fills = new ArrayList<XSSFCellFill>();
    private final List<XSSFCellBorder> borders = new ArrayList<XSSFCellBorder>();
    private final List<CTXf> styleXfs = new ArrayList<CTXf>();
    private final List<CTXf> xfs = new ArrayList<CTXf>();
    private final List<CTDxf> dxfs = new ArrayList<CTDxf>();
    public static final int FIRST_CUSTOM_STYLE_ID = 165;
    private static final int MAXIMUM_STYLE_ID = SpreadsheetVersion.EXCEL2007.getMaxCellStyles();
    private static final short FIRST_USER_DEFINED_NUMBER_FORMAT_ID = 164;
    private int MAXIMUM_NUMBER_OF_DATA_FORMATS = 250;
    private StyleSheetDocument doc;
    private XSSFWorkbook workbook;
    private ThemesTable theme;

    public void setMaxNumberOfDataFormats(int num) {
        if (num < this.getNumDataFormats()) {
            if (num < 0) {
                throw new IllegalArgumentException("Maximum Number of Data Formats must be greater than or equal to 0");
            }
            throw new IllegalStateException("Cannot set the maximum number of data formats less than the current quantity.Data formats must be explicitly removed (via StylesTable.removeNumberFormat) before the limit can be decreased.");
        }
        this.MAXIMUM_NUMBER_OF_DATA_FORMATS = num;
    }

    public int getMaxNumberOfDataFormats() {
        return this.MAXIMUM_NUMBER_OF_DATA_FORMATS;
    }

    public StylesTable() {
        this.doc = StyleSheetDocument.Factory.newInstance();
        this.doc.addNewStyleSheet();
        this.initialize();
    }

    public StylesTable(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    public StylesTable(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void setWorkbook(XSSFWorkbook wb) {
        this.workbook = wb;
    }

    public ThemesTable getTheme() {
        return this.theme;
    }

    public void setTheme(ThemesTable theme) {
        this.theme = theme;
        for (XSSFFont font : this.fonts) {
            font.setThemesTable(theme);
        }
        for (XSSFCellBorder border : this.borders) {
            border.setThemesTable(theme);
        }
    }

    public void ensureThemesTable() {
        if (this.theme != null) {
            return;
        }
        this.theme = (ThemesTable)this.workbook.createRelationship(XSSFRelation.THEME, XSSFFactory.getInstance());
    }

    protected void readFrom(InputStream is) throws IOException {
        try {
            CTDxfs styleDxfs;
            CTCellStyleXfs cellStyleXfs;
            CTCellXfs cellXfs;
            CTBorders ctborders;
            CTFills ctfills;
            CTFonts ctfonts;
            int formatId;
            this.doc = StyleSheetDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            CTStylesheet styleSheet = this.doc.getStyleSheet();
            CTNumFmts ctfmts = styleSheet.getNumFmts();
            if (ctfmts != null) {
                for (CTNumFmt nfmt : ctfmts.getNumFmtArray()) {
                    formatId = (short)nfmt.getNumFmtId();
                    this.numberFormats.put((short)formatId, nfmt.getFormatCode());
                }
            }
            if ((ctfonts = styleSheet.getFonts()) != null) {
                int idx = 0;
                CTFont[] cTFontArray = ctfonts.getFontArray();
                int nfmt = cTFontArray.length;
                for (formatId = 0; formatId < nfmt; ++formatId) {
                    CTFont font = cTFontArray[formatId];
                    XSSFFont f = new XSSFFont(font, idx);
                    this.fonts.add(f);
                    ++idx;
                }
            }
            if ((ctfills = styleSheet.getFills()) != null) {
                for (CTFill fill : ctfills.getFillArray()) {
                    this.fills.add(new XSSFCellFill(fill));
                }
            }
            if ((ctborders = styleSheet.getBorders()) != null) {
                for (CTBorder border : ctborders.getBorderArray()) {
                    this.borders.add(new XSSFCellBorder(border));
                }
            }
            if ((cellXfs = styleSheet.getCellXfs()) != null) {
                this.xfs.addAll(Arrays.asList(cellXfs.getXfArray()));
            }
            if ((cellStyleXfs = styleSheet.getCellStyleXfs()) != null) {
                this.styleXfs.addAll(Arrays.asList(cellStyleXfs.getXfArray()));
            }
            if ((styleDxfs = styleSheet.getDxfs()) != null) {
                this.dxfs.addAll(Arrays.asList(styleDxfs.getDxfArray()));
            }
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public String getNumberFormatAt(int idx) {
        return this.getNumberFormatAt((short)idx);
    }

    public String getNumberFormatAt(short fmtId) {
        return (String)this.numberFormats.get(fmtId);
    }

    private short getNumberFormatId(String fmt) {
        for (Map.Entry<Short, String> numFmt : this.numberFormats.entrySet()) {
            if (!numFmt.getValue().equals(fmt)) continue;
            return numFmt.getKey();
        }
        throw new IllegalStateException("Number format not in style table: " + fmt);
    }

    public int putNumberFormat(String fmt) {
        short formatIndex;
        if (this.numberFormats.containsValue(fmt)) {
            try {
                return this.getNumberFormatId(fmt);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Found the format, but couldn't figure out where - should never happen!");
            }
        }
        if (this.numberFormats.size() >= this.MAXIMUM_NUMBER_OF_DATA_FORMATS) {
            throw new IllegalStateException("The maximum number of Data Formats was exceeded. You can define up to " + this.MAXIMUM_NUMBER_OF_DATA_FORMATS + " formats in a .xlsx Workbook.");
        }
        if (this.numberFormats.isEmpty()) {
            formatIndex = 164;
        } else {
            short nextKey = (short)(this.numberFormats.lastKey() + 1);
            if (nextKey < 0) {
                throw new IllegalStateException("Cowardly avoiding creating a number format with a negative id.This is probably due to arithmetic overflow.");
            }
            formatIndex = (short)Math.max(nextKey, 164);
        }
        this.numberFormats.put(formatIndex, fmt);
        return formatIndex;
    }

    public void putNumberFormat(short index, String fmt) {
        this.numberFormats.put(index, fmt);
    }

    public boolean removeNumberFormat(short index) {
        boolean removed;
        String fmt = (String)this.numberFormats.remove(index);
        boolean bl = removed = fmt != null;
        if (removed) {
            for (CTXf style : this.xfs) {
                if (!style.isSetNumFmtId() || style.getNumFmtId() != (long)index) continue;
                style.unsetApplyNumberFormat();
                style.unsetNumFmtId();
            }
        }
        return removed;
    }

    public boolean removeNumberFormat(String fmt) {
        short id = this.getNumberFormatId(fmt);
        return this.removeNumberFormat(id);
    }

    public XSSFFont getFontAt(int idx) {
        return this.fonts.get(idx);
    }

    public int putFont(XSSFFont font, boolean forceRegistration) {
        int idx = -1;
        if (!forceRegistration) {
            idx = this.fonts.indexOf(font);
        }
        if (idx != -1) {
            return idx;
        }
        idx = this.fonts.size();
        this.fonts.add(font);
        return idx;
    }

    public int putFont(XSSFFont font) {
        return this.putFont(font, false);
    }

    public XSSFCellStyle getStyleAt(int idx) {
        int styleXfId = 0;
        if (this.xfs.get(idx).getXfId() > 0L) {
            styleXfId = (int)this.xfs.get(idx).getXfId();
        }
        return new XSSFCellStyle(idx, styleXfId, this, this.theme);
    }

    public int putStyle(XSSFCellStyle style) {
        CTXf mainXF = style.getCoreXf();
        if (!this.xfs.contains(mainXF)) {
            this.xfs.add(mainXF);
        }
        return this.xfs.indexOf(mainXF);
    }

    public XSSFCellBorder getBorderAt(int idx) {
        return this.borders.get(idx);
    }

    public int putBorder(XSSFCellBorder border) {
        int idx = this.borders.indexOf(border);
        if (idx != -1) {
            return idx;
        }
        this.borders.add(border);
        border.setThemesTable(this.theme);
        return this.borders.size() - 1;
    }

    public XSSFCellFill getFillAt(int idx) {
        return this.fills.get(idx);
    }

    public List<XSSFCellBorder> getBorders() {
        return Collections.unmodifiableList(this.borders);
    }

    public List<XSSFCellFill> getFills() {
        return Collections.unmodifiableList(this.fills);
    }

    public List<XSSFFont> getFonts() {
        return Collections.unmodifiableList(this.fonts);
    }

    public Map<Short, String> getNumberFormats() {
        return Collections.unmodifiableMap(this.numberFormats);
    }

    public int putFill(XSSFCellFill fill) {
        int idx = this.fills.indexOf(fill);
        if (idx != -1) {
            return idx;
        }
        this.fills.add(fill);
        return this.fills.size() - 1;
    }

    @Internal
    public CTXf getCellXfAt(int idx) {
        return this.xfs.get(idx);
    }

    @Internal
    public int putCellXf(CTXf cellXf) {
        this.xfs.add(cellXf);
        return this.xfs.size();
    }

    @Internal
    public void replaceCellXfAt(int idx, CTXf cellXf) {
        this.xfs.set(idx, cellXf);
    }

    @Internal
    public CTXf getCellStyleXfAt(int idx) {
        try {
            return this.styleXfs.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Internal
    public int putCellStyleXf(CTXf cellStyleXf) {
        this.styleXfs.add(cellStyleXf);
        return this.styleXfs.size();
    }

    @Internal
    protected void replaceCellStyleXfAt(int idx, CTXf cellStyleXf) {
        this.styleXfs.set(idx, cellStyleXf);
    }

    public int getNumCellStyles() {
        return this.xfs.size();
    }

    public int getNumDataFormats() {
        return this.numberFormats.size();
    }

    @Internal
    public int _getNumberFormatSize() {
        return this.getNumDataFormats();
    }

    @Internal
    int _getXfsSize() {
        return this.xfs.size();
    }

    @Internal
    public int _getStyleXfsSize() {
        return this.styleXfs.size();
    }

    @Internal
    public CTStylesheet getCTStylesheet() {
        return this.doc.getStyleSheet();
    }

    @Internal
    public int _getDXfsSize() {
        return this.dxfs.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        CTStylesheet styleSheet = this.doc.getStyleSheet();
        CTNumFmts formats = CTNumFmts.Factory.newInstance();
        formats.setCount(this.numberFormats.size());
        for (Map.Entry<Short, String> entry : this.numberFormats.entrySet()) {
            CTNumFmt ctFmt = formats.addNewNumFmt();
            ctFmt.setNumFmtId(entry.getKey().shortValue());
            ctFmt.setFormatCode(entry.getValue());
        }
        styleSheet.setNumFmts(formats);
        CTFonts ctFonts = styleSheet.getFonts();
        if (ctFonts == null) {
            ctFonts = CTFonts.Factory.newInstance();
        }
        ctFonts.setCount(this.fonts.size());
        CTFont[] ctfnt = new CTFont[this.fonts.size()];
        int idx = 0;
        for (XSSFFont f : this.fonts) {
            ctfnt[idx++] = f.getCTFont();
        }
        ctFonts.setFontArray(ctfnt);
        styleSheet.setFonts(ctFonts);
        CTFills ctFills = styleSheet.getFills();
        if (ctFills == null) {
            ctFills = CTFills.Factory.newInstance();
        }
        ctFills.setCount(this.fills.size());
        CTFill[] ctf = new CTFill[this.fills.size()];
        idx = 0;
        for (XSSFCellFill f : this.fills) {
            ctf[idx++] = f.getCTFill();
        }
        ctFills.setFillArray(ctf);
        styleSheet.setFills(ctFills);
        CTBorders ctBorders = styleSheet.getBorders();
        if (ctBorders == null) {
            ctBorders = CTBorders.Factory.newInstance();
        }
        ctBorders.setCount(this.borders.size());
        CTBorder[] ctb = new CTBorder[this.borders.size()];
        idx = 0;
        for (XSSFCellBorder b : this.borders) {
            ctb[idx++] = b.getCTBorder();
        }
        ctBorders.setBorderArray(ctb);
        styleSheet.setBorders(ctBorders);
        if (this.xfs.size() > 0) {
            CTCellXfs ctXfs = styleSheet.getCellXfs();
            if (ctXfs == null) {
                ctXfs = CTCellXfs.Factory.newInstance();
            }
            ctXfs.setCount(this.xfs.size());
            ctXfs.setXfArray(this.xfs.toArray(new CTXf[this.xfs.size()]));
            styleSheet.setCellXfs(ctXfs);
        }
        if (this.styleXfs.size() > 0) {
            CTCellStyleXfs ctSXfs = styleSheet.getCellStyleXfs();
            if (ctSXfs == null) {
                ctSXfs = CTCellStyleXfs.Factory.newInstance();
            }
            ctSXfs.setCount(this.styleXfs.size());
            ctSXfs.setXfArray(this.styleXfs.toArray(new CTXf[this.styleXfs.size()]));
            styleSheet.setCellStyleXfs(ctSXfs);
        }
        if (this.dxfs.size() > 0) {
            CTDxfs ctDxfs = styleSheet.getDxfs();
            if (ctDxfs == null) {
                ctDxfs = CTDxfs.Factory.newInstance();
            }
            ctDxfs.setCount(this.dxfs.size());
            ctDxfs.setDxfArray(this.dxfs.toArray(new CTDxf[this.dxfs.size()]));
            styleSheet.setDxfs(ctDxfs);
        }
        this.doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    private void initialize() {
        XSSFFont xssfFont = StylesTable.createDefaultFont();
        this.fonts.add(xssfFont);
        CTFill[] ctFill = StylesTable.createDefaultFills();
        this.fills.add(new XSSFCellFill(ctFill[0]));
        this.fills.add(new XSSFCellFill(ctFill[1]));
        CTBorder ctBorder = StylesTable.createDefaultBorder();
        this.borders.add(new XSSFCellBorder(ctBorder));
        CTXf styleXf = StylesTable.createDefaultXf();
        this.styleXfs.add(styleXf);
        CTXf xf = StylesTable.createDefaultXf();
        xf.setXfId(0L);
        this.xfs.add(xf);
    }

    private static CTXf createDefaultXf() {
        CTXf ctXf = CTXf.Factory.newInstance();
        ctXf.setNumFmtId(0L);
        ctXf.setFontId(0L);
        ctXf.setFillId(0L);
        ctXf.setBorderId(0L);
        return ctXf;
    }

    private static CTBorder createDefaultBorder() {
        CTBorder ctBorder = CTBorder.Factory.newInstance();
        ctBorder.addNewBottom();
        ctBorder.addNewTop();
        ctBorder.addNewLeft();
        ctBorder.addNewRight();
        ctBorder.addNewDiagonal();
        return ctBorder;
    }

    private static CTFill[] createDefaultFills() {
        CTFill[] ctFill = new CTFill[]{CTFill.Factory.newInstance(), CTFill.Factory.newInstance()};
        ctFill[0].addNewPatternFill().setPatternType(STPatternType.NONE);
        ctFill[1].addNewPatternFill().setPatternType(STPatternType.DARK_GRAY);
        return ctFill;
    }

    private static XSSFFont createDefaultFont() {
        CTFont ctFont = CTFont.Factory.newInstance();
        XSSFFont xssfFont = new XSSFFont(ctFont, 0);
        xssfFont.setFontHeightInPoints((short)11);
        xssfFont.setColor(XSSFFont.DEFAULT_FONT_COLOR);
        xssfFont.setFontName("Calibri");
        xssfFont.setFamily(FontFamily.SWISS);
        xssfFont.setScheme(FontScheme.MINOR);
        return xssfFont;
    }

    @Internal
    public CTDxf getDxfAt(int idx) {
        return this.dxfs.get(idx);
    }

    @Internal
    public int putDxf(CTDxf dxf) {
        this.dxfs.add(dxf);
        return this.dxfs.size();
    }

    public XSSFCellStyle createCellStyle() {
        if (this.getNumCellStyles() > MAXIMUM_STYLE_ID) {
            throw new IllegalStateException("The maximum number of Cell Styles was exceeded. You can define up to " + MAXIMUM_STYLE_ID + " style in a .xlsx Workbook");
        }
        int xfSize = this.styleXfs.size();
        CTXf xf = CTXf.Factory.newInstance();
        xf.setNumFmtId(0L);
        xf.setFontId(0L);
        xf.setFillId(0L);
        xf.setBorderId(0L);
        xf.setXfId(0L);
        int indexXf = this.putCellXf(xf);
        return new XSSFCellStyle(indexXf - 1, xfSize - 1, this, this.theme);
    }

    public XSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (XSSFFont font : this.fonts) {
            if (font.getBoldweight() != boldWeight || font.getColor() != color || font.getFontHeight() != fontHeight || !font.getFontName().equals(name) || font.getItalic() != italic || font.getStrikeout() != strikeout || font.getTypeOffset() != typeOffset || font.getUnderline() != underline) continue;
            return font;
        }
        return null;
    }
}

