/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefCapablePropertyResourceBundle {
    private PropertyResourceBundle wrappedBundle;
    private String baseName;
    private String language;
    private String country;
    private String variant;
    private static Map allBundles = new HashMap();
    public static String LS = System.getProperty("line.separator");
    private Pattern sysPropVarPattern = Pattern.compile("(?s)\\Q${\\E([^}]+?)(?:\\Q:+\\E([^}]+))?\\Q}");
    private Pattern posPattern = Pattern.compile("(?s)\\Q%{\\E(\\d)(?:\\Q:+\\E([^}]+))?\\Q}");
    private ClassLoader loader;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;

    public Enumeration getKeys() {
        return this.wrappedBundle.getKeys();
    }

    private RefCapablePropertyResourceBundle(String baseName, PropertyResourceBundle wrappedBundle, ClassLoader loader) {
        this.baseName = baseName;
        this.wrappedBundle = wrappedBundle;
        Locale locale = wrappedBundle.getLocale();
        this.loader = loader;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
        if (this.language.length() < 1) {
            this.language = null;
        }
        if (this.country.length() < 1) {
            this.country = null;
        }
        if (this.variant.length() < 1) {
            this.variant = null;
        }
    }

    public String getExpandedString(String key, int behavior) {
        String s = this.getString(key);
        Matcher matcher = this.sysPropVarPattern.matcher(s);
        int previousEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String varName = matcher.group(1);
            String condlVal = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String varValue = System.getProperty(varName);
            if (condlVal != null) {
                String string = varValue = varValue == null ? "" : condlVal.replaceAll("\\Q$" + varName + "\\E\\b", RefCapablePropertyResourceBundle.literalize(varValue));
            }
            if (varValue == null) {
                switch (behavior) {
                    case 0: {
                        throw new RuntimeException("No Sys Property set for variable '" + varName + "' in property value (" + s + ").");
                    }
                    case 1: {
                        varValue = "";
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + behavior);
                    }
                }
            }
            sb.append(s.substring(previousEnd, matcher.start()) + (varValue == null ? matcher.group() : varValue));
            previousEnd = matcher.end();
        }
        return previousEnd < 1 ? s : sb.toString() + s.substring(previousEnd);
    }

    public String posSubst(String s, String[] subs, int behavior) {
        Matcher matcher = this.posPattern.matcher(s);
        int previousEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String varValue;
            int varIndex = Integer.parseInt(matcher.group(1)) - 1;
            String condlVal = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string = varValue = varIndex < subs.length ? subs[varIndex] : null;
            if (condlVal != null) {
                String string2 = varValue = varValue == null ? "" : condlVal.replaceAll("\\Q%" + (varIndex + 1) + "\\E\\b", RefCapablePropertyResourceBundle.literalize(varValue));
            }
            if (varValue == null) {
                switch (behavior) {
                    case 0: {
                        throw new RuntimeException(Integer.toString(subs.length) + " positional values given, but property string " + "contains (" + matcher.group() + ").");
                    }
                    case 1: {
                        varValue = "";
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + behavior);
                    }
                }
            }
            sb.append(s.substring(previousEnd, matcher.start()) + (varValue == null ? matcher.group() : varValue));
            previousEnd = matcher.end();
        }
        return previousEnd < 1 ? s : sb.toString() + s.substring(previousEnd);
    }

    public String getExpandedString(String key, String[] subs, int missingPropertyBehavior, int missingPosValueBehavior) {
        return this.posSubst(this.getExpandedString(key, missingPropertyBehavior), subs, missingPosValueBehavior);
    }

    public String getString(String key, String[] subs, int behavior) {
        return this.posSubst(this.getString(key), subs, behavior);
    }

    public String toString() {
        return this.baseName + " for " + this.language + " / " + this.country + " / " + this.variant;
    }

    public String getString(String key) {
        String value = this.wrappedBundle.getString(key);
        if (value.length() > 0) {
            return value;
        }
        value = this.getStringFromFile(key);
        if (value.indexOf(13) > -1) {
            value = value.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
        }
        if (value.length() > 0 && value.charAt(value.length() - 1) == '\n') {
            value = value.substring(0, value.length() - 1);
        }
        if (!LS.equals("\n")) {
            value = value.replaceAll("\\n", LS);
        }
        return value;
    }

    public static RefCapablePropertyResourceBundle getBundle(String baseName, ClassLoader loader) {
        return RefCapablePropertyResourceBundle.getRef(baseName, ResourceBundle.getBundle(baseName, Locale.getDefault(), loader), loader);
    }

    public static RefCapablePropertyResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return RefCapablePropertyResourceBundle.getRef(baseName, ResourceBundle.getBundle(baseName, locale, loader), loader);
    }

    private static RefCapablePropertyResourceBundle getRef(String baseName, ResourceBundle rb, ClassLoader loader) {
        if (!(rb instanceof PropertyResourceBundle)) {
            throw new MissingResourceException("Found a Resource Bundle, but it is a " + rb.getClass().getName(), PropertyResourceBundle.class.getName(), null);
        }
        if (allBundles.containsKey(rb)) {
            return (RefCapablePropertyResourceBundle)allBundles.get(rb);
        }
        RefCapablePropertyResourceBundle newPRAFP = new RefCapablePropertyResourceBundle(baseName, (PropertyResourceBundle)rb, loader);
        allBundles.put(rb, newPRAFP);
        return newPRAFP;
    }

    private InputStream getMostSpecificStream(String key, String l, String c, String v) {
        String filePath = this.baseName.replace('.', '/') + '/' + key + (l == null ? "" : "_" + l) + (c == null ? "" : "_" + c) + (v == null ? "" : "_" + v) + ".text";
        InputStream is = this.loader.getResourceAsStream(filePath);
        return is == null && l != null ? this.getMostSpecificStream(key, c == null ? null : l, v == null ? null : c, null) : is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromFile(String key) {
        int bytesread;
        byte[] ba = null;
        InputStream inputStream = this.getMostSpecificStream(key, this.language, this.country, this.variant);
        if (inputStream == null) {
            throw new MissingResourceException("Key '" + key + "' is present in .properties file with no value, yet " + "text file resource is missing", RefCapablePropertyResourceBundle.class.getName(), key);
        }
        try {
            try {
                ba = new byte[inputStream.available()];
            }
            catch (RuntimeException re) {
                throw new MissingResourceException("Resource is too big to read in '" + key + "' value in one " + "gulp.\nPlease run the program with more RAM " + "(try Java -Xm* switches).: " + re, RefCapablePropertyResourceBundle.class.getName(), key);
            }
            catch (IOException ioe) {
                throw new MissingResourceException("Failed to read in value for key '" + key + "': " + ioe, RefCapablePropertyResourceBundle.class.getName(), key);
            }
            try {
                int retval;
                for (bytesread = 0; bytesread < ba.length && (retval = inputStream.read(ba, bytesread, ba.length - bytesread)) > 0; bytesread += retval) {
                }
            }
            catch (IOException ioe) {
                throw new MissingResourceException("Failed to read in value for '" + key + "': " + ioe, RefCapablePropertyResourceBundle.class.getName(), key);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Failed to close input stream: " + ioe);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException ioe) {
            System.err.println("Failed to close input stream: " + ioe);
        }
        if (bytesread != ba.length) {
            throw new MissingResourceException("Didn't read all bytes.  Read in " + bytesread + " bytes out of " + ba.length + " bytes for key '" + key + "'", RefCapablePropertyResourceBundle.class.getName(), key);
        }
        try {
            return new String(ba, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (RuntimeException re) {
            throw new MissingResourceException("Value for key '" + key + "' too big to convert to String.  " + "Please run the program with more RAM " + "(try Java -Xm* switches).: " + re, RefCapablePropertyResourceBundle.class.getName(), key);
        }
    }

    public static String literalize(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block4;
                }
                case '$': {
                    sb.append('\\');
                    sb.append('$');
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

