/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.Set;
import com.fr.third.org.hsqldb.persist.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ResourceStreamProvider {
    private static ClassLoader loader;
    private static HashSet forbiddenProtocols;

    private ResourceStreamProvider() {
    }

    public static synchronized void setLoader(ClassLoader loader) {
        ResourceStreamProvider.loader = loader;
    }

    public static synchronized ClassLoader getLoader() {
        return loader;
    }

    public static Set forbiddenProtocols() {
        return forbiddenProtocols;
    }

    public static boolean exists(String resource) {
        ClassLoader loader = ResourceStreamProvider.getLoader();
        URL url = null;
        if (loader == null) {
            url = Logger.class.getResource(resource);
        } else {
            url = loader.getResource(resource);
            if (url == null) {
                url = Logger.class.getResource(resource);
            }
        }
        return url != null && !ResourceStreamProvider.forbiddenProtocols().contains(url.getProtocol());
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        ClassLoader loader = ResourceStreamProvider.getLoader();
        URL url = null;
        if (loader == null) {
            url = Logger.class.getResource(resource);
        } else {
            url = loader.getResource(resource);
            if (url == null) {
                url = Logger.class.getResource(resource);
            }
        }
        if (url == null) {
            throw new IOException("Missing resource: " + resource);
        }
        String protocol = url.getProtocol();
        if (forbiddenProtocols.contains(protocol)) {
            throw new IOException("Wrong protocol [" + protocol + "] for resource : " + resource);
        }
        return url.openStream();
    }

    static {
        forbiddenProtocols = new HashSet();
        forbiddenProtocols.add("file");
    }
}

