/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.commons.dbcp.managed;

import com.fr.third.org.apache.commons.dbcp.ConnectionFactory;
import com.fr.third.org.apache.commons.dbcp.managed.TransactionRegistry;
import com.fr.third.org.apache.commons.dbcp.managed.XAConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LocalXAConnectionFactory
implements XAConnectionFactory {
    protected TransactionRegistry transactionRegistry;
    protected ConnectionFactory connectionFactory;

    public LocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.connectionFactory = connectionFactory;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this.connectionFactory.createConnection();
        LocalXAResource xaResource = new LocalXAResource(connection);
        this.transactionRegistry.registerConnection(connection, xaResource);
        return connection;
    }

    protected static class LocalXAResource
    implements XAResource {
        private final Connection connection;
        private Xid currentXid;
        private boolean originalAutoCommit;

        public LocalXAResource(Connection localTransaction) {
            this.connection = localTransaction;
        }

        public synchronized Xid getXid() {
            return this.currentXid;
        }

        public synchronized void start(Xid xid, int flag) throws XAException {
            if (flag == 0) {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + xid);
                }
                try {
                    this.originalAutoCommit = this.connection.getAutoCommit();
                }
                catch (SQLException ignored) {
                    this.originalAutoCommit = true;
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw (XAException)new XAException("Count not turn off auto commit for a XA transaction").initCause(e);
                }
                this.currentXid = xid;
            } else if (flag == 0x8000000) {
                if (xid != this.currentXid) {
                    throw new XAException("Attempting to resume in different transaction: expected " + this.currentXid + ", but was " + xid);
                }
            } else {
                throw new XAException("Unknown start flag " + flag);
            }
        }

        public synchronized void end(Xid xid, int flag) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
        }

        public synchronized int prepare(Xid xid) {
            try {
                if (this.connection.isReadOnly()) {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0;
        }

        /*
         * Loose catch block
         */
        public synchronized void commit(Xid xid, boolean flag) throws XAException {
            block11: {
                block10: {
                    if (xid == null) {
                        throw new NullPointerException("xid is null");
                    }
                    if (!this.currentXid.equals(xid)) {
                        throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
                    }
                    if (this.connection.isClosed()) {
                        throw new XAException("Conection is closed");
                    }
                    if (this.connection.isReadOnly()) break block10;
                    this.connection.commit();
                }
                Object var5_3 = null;
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    break block11;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                {
                    break block11;
                    catch (SQLException e) {
                        throw (XAException)new XAException().initCause(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    try {
                        this.connection.setAutoCommit(this.originalAutoCommit);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.currentXid = null;
                    throw throwable;
                }
            }
            this.currentXid = null;
        }

        /*
         * Loose catch block
         */
        public synchronized void rollback(Xid xid) throws XAException {
            block9: {
                if (xid == null) {
                    throw new NullPointerException("xid is null");
                }
                if (!this.currentXid.equals(xid)) {
                    throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
                }
                this.connection.rollback();
                Object var4_2 = null;
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    break block9;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                {
                    break block9;
                    catch (SQLException e) {
                        throw (XAException)new XAException().initCause(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    try {
                        this.connection.setAutoCommit(this.originalAutoCommit);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.currentXid = null;
                    throw throwable;
                }
            }
            this.currentXid = null;
        }

        public boolean isSameRM(XAResource xaResource) {
            return this == xaResource;
        }

        public synchronized void forget(Xid xid) {
            if (xid != null && this.currentXid.equals(xid)) {
                this.currentXid = null;
            }
        }

        public Xid[] recover(int flag) {
            return new Xid[0];
        }

        public int getTransactionTimeout() {
            return 0;
        }

        public boolean setTransactionTimeout(int transactionTimeout) {
            return false;
        }
    }
}

