/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.xerces.util;

import com.fr.third.javax.xml.stream.xerces.util.SecuritySupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$0;

    public static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    public static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        ObjectFactory.debugPrintln("debug is on");
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = ObjectFactory.findClassLoader();
        try {
            String systemProp = ss.getSystemProperty(factoryId);
            if (systemProp != null) {
                ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                return ObjectFactory.newInstance(systemProp, cl, true);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        try {
            if (propertiesFilename == null) {
                String javah = ss.getSystemProperty("java.home");
                propertiesFilename = String.valueOf(javah) + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
            }
            FileInputStream fis = ss.getFileInputStream(new File(propertiesFilename));
            Properties props = new Properties();
            props.load(fis);
            String factoryClassName = props.getProperty(factoryId);
            if (factoryClassName != null) {
                ObjectFactory.debugPrintln("found in " + propertiesFilename + ", value=" + factoryClassName);
                return ObjectFactory.newInstance(factoryClassName, cl, true);
            }
        }
        catch (Exception fis) {
            // empty catch block
        }
        Object provider = ObjectFactory.findJarServiceProvider(factoryId);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("using fallback, value=" + fallbackClassName);
        return ObjectFactory.newInstance(fallbackClassName, cl, true);
    }

    private static void debugPrintln(String msg) {
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = ss.getContextClassLoader();
        if (cl == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.xerces.util.ObjectFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cl = clazz.getClassLoader();
        }
        return cl;
    }

    public static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: ", x);
        }
    }

    public static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.xerces.util.ObjectFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    cl = clazz.getClassLoader();
                    providerClass = cl.loadClass(className);
                }
                throw x;
            }
        }
        return providerClass;
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        SecuritySupport ss = SecuritySupport.getInstance();
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl != null) {
            is = ss.getResourceAsStream(cl, serviceId);
            if (is == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.xerces.util.ObjectFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cl = clazz.getClassLoader();
                is = ss.getResourceAsStream(cl, serviceId);
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.xerces.util.ObjectFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cl = clazz.getClassLoader();
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String msg, Exception x) {
            this.exception = x;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

