/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.utils;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.EventType;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.IEventData;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.ITextExtractionStrategy;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.LocationTextExtractionStrategy;
import com.fr.third.fr.pdf.kernel.pdf.tagging.IPdfStructElem;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfMcr;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfObjRef;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructElem;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedPdfReaderTool {
    protected PdfDocument document;
    protected PrintWriter out;
    protected String rootTag;
    protected Map<PdfDictionary, Map<Integer, String>> parsedTags = new HashMap<PdfDictionary, Map<Integer, String>>();

    public TaggedPdfReaderTool(PdfDocument document) {
        this.document = document;
    }

    public void convertToXml(OutputStream os) throws IOException {
        this.convertToXml(os, "UTF-8");
    }

    public void convertToXml(OutputStream os, String charset) throws IOException {
        PdfStructTreeRoot structTreeRoot;
        OutputStreamWriter outs = new OutputStreamWriter(os, charset);
        this.out = new PrintWriter(outs);
        if (this.rootTag != null) {
            this.out.println("<" + this.rootTag + ">");
        }
        if ((structTreeRoot = this.document.getStructTreeRoot()) == null) {
            throw new PdfException("document.doesn't.contain.structtreeroot");
        }
        this.inspectKids(structTreeRoot.getKids());
        if (this.rootTag != null) {
            this.out.print("</" + this.rootTag + ">");
        }
        this.out.flush();
        this.out.close();
    }

    public TaggedPdfReaderTool setRootTag(String rootTagName) {
        this.rootTag = rootTagName;
        return this;
    }

    protected void inspectKids(List<IPdfStructElem> kids) {
        if (kids == null) {
            return;
        }
        for (IPdfStructElem kid : kids) {
            this.inspectKid(kid);
        }
    }

    protected void inspectKid(IPdfStructElem kid) {
        if (kid instanceof PdfStructElem) {
            PdfStructElem structElemKid = (PdfStructElem)kid;
            PdfName s = structElemKid.getRole();
            String tagN = s.getValue();
            String tag = TaggedPdfReaderTool.fixTagName(tagN);
            this.out.print("<");
            this.out.print(tag);
            this.inspectAttributes(structElemKid);
            this.out.println(">");
            PdfString alt = structElemKid.getAlt();
            if (alt != null) {
                this.out.print("<alt><![CDATA[");
                this.out.print(alt.getValue().replaceAll("[\\000]*", ""));
                this.out.println("]]></alt>");
            }
            this.inspectKids(structElemKid.getKids());
            this.out.print("</");
            this.out.print(tag);
            this.out.println(">");
        } else if (kid instanceof PdfMcr) {
            this.parseTag((PdfMcr)kid);
        } else {
            this.out.print(" <flushedKid/> ");
        }
    }

    protected void inspectAttributes(PdfStructElem kid) {
        PdfObject attrObj = kid.getAttributes(false);
        if (attrObj != null) {
            PdfDictionary attrDict = attrObj instanceof PdfArray ? ((PdfArray)attrObj).getAsDictionary(0) : (PdfDictionary)attrObj;
            for (Map.Entry<PdfName, PdfObject> entry : attrDict.entrySet()) {
                this.out.print(' ');
                String attrName = entry.getKey().getValue();
                this.out.print(Character.toLowerCase(attrName.charAt(0)) + attrName.substring(1));
                this.out.print("=\"");
                this.out.print(entry.getValue().toString());
                this.out.print("\"");
            }
        }
    }

    protected void parseTag(PdfMcr kid) {
        int mcid = kid.getMcid();
        PdfDictionary pageDic = kid.getPageObject();
        String tagContent = "";
        if (mcid != -1) {
            if (!this.parsedTags.containsKey(pageDic)) {
                MarkedContentEventListener listener = new MarkedContentEventListener();
                PdfCanvasProcessor processor = new PdfCanvasProcessor(listener);
                PdfPage page = this.document.getPage(pageDic);
                processor.processContent(page.getContentBytes(), page.getResources());
                this.parsedTags.put(pageDic, listener.getMcidContent());
            }
            if (this.parsedTags.get(pageDic).containsKey(mcid)) {
                tagContent = this.parsedTags.get(pageDic).get(mcid);
            }
        } else {
            PdfObjRef objRef = (PdfObjRef)kid;
            PdfDictionary object = objRef.getReferencedObject();
            if (object.isDictionary()) {
                PdfName subtype = object.getAsName(PdfName.Subtype);
                tagContent = subtype.toString();
            }
        }
        this.out.print(TaggedPdfReaderTool.escapeXML(tagContent, true));
    }

    protected static String fixTagName(String tag) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < tag.length(); ++k) {
            boolean nameMiddle;
            char c = tag.charAt(k);
            boolean nameStart = c == ':' || c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd';
            boolean bl = nameMiddle = c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040' || nameStart;
            if (k == 0) {
                if (!nameStart) {
                    c = '_';
                }
            } else if (!nameMiddle) {
                c = '-';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String escapeXML(String s, boolean onlyASCII) {
        char[] cc = s.toCharArray();
        int len = cc.length;
        StringBuilder sb = new StringBuilder();
        block7: for (int k = 0; k < len; ++k) {
            char c = cc[k];
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (!TaggedPdfReaderTool.isValidCharacterValue(c)) continue block7;
                    if (onlyASCII && c > '\u007f') {
                        sb.append("&#").append((int)c).append(';');
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isValidCharacterValue(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkedContentEventListener
    implements IEventListener {
        private Map<Integer, ITextExtractionStrategy> contentByMcid = new HashMap<Integer, ITextExtractionStrategy>();

        private MarkedContentEventListener() {
        }

        public Map<Integer, String> getMcidContent() {
            HashMap<Integer, String> content = new HashMap<Integer, String>();
            for (int id : this.contentByMcid.keySet()) {
                content.put(id, this.contentByMcid.get(id).getResultantText());
            }
            return content;
        }

        @Override
        public void eventOccurred(IEventData data, EventType type) {
            switch (type) {
                case RENDER_TEXT: {
                    TextRenderInfo textInfo = (TextRenderInfo)data;
                    int mcid = textInfo.getMcid();
                    if (mcid == -1) break;
                    ITextExtractionStrategy textExtractionStrategy = this.contentByMcid.get(mcid);
                    if (textExtractionStrategy == null) {
                        textExtractionStrategy = new LocationTextExtractionStrategy();
                        this.contentByMcid.put(mcid, textExtractionStrategy);
                    }
                    textExtractionStrategy.eventOccurred(data, type);
                    break;
                }
            }
        }

        @Override
        public Set<EventType> getSupportedEvents() {
            return null;
        }
    }
}

