/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.xobject;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.PdfResources;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.fr.third.fr.pdf.kernel.pdf.canvas.wmf.WmfImageHelper;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfTransparencyGroup;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfXObject;

public class PdfFormXObject
extends PdfXObject {
    private static final long serialVersionUID = 467500482711722178L;
    private PdfResources resources = null;

    public PdfFormXObject(Rectangle bBox) {
        super(new PdfStream());
        ((PdfStream)this.getPdfObject()).put(PdfName.Type, PdfName.XObject);
        ((PdfStream)this.getPdfObject()).put(PdfName.Subtype, PdfName.Form);
        if (bBox != null) {
            ((PdfStream)this.getPdfObject()).put(PdfName.BBox, new PdfArray(bBox));
        }
    }

    public PdfFormXObject(PdfStream pdfObject) {
        super(pdfObject);
    }

    public PdfFormXObject(PdfPage page) {
        this(page.getCropBox());
        ((PdfStream)this.getPdfObject()).getOutputStream().writeBytes(page.getContentBytes());
        this.resources = new PdfResources((PdfDictionary)((PdfDictionary)page.getResources().getPdfObject()).clone());
        ((PdfStream)this.getPdfObject()).put(PdfName.Resources, (PdfObject)this.resources.getPdfObject());
    }

    public PdfFormXObject(WmfImageData image, PdfDocument pdfDocument) {
        this((PdfStream)new WmfImageHelper(image).createPdfForm(pdfDocument).getPdfObject());
    }

    public PdfResources getResources() {
        if (this.resources == null) {
            PdfDictionary resources = ((PdfStream)this.getPdfObject()).getAsDictionary(PdfName.Resources);
            if (resources == null) {
                resources = new PdfDictionary();
                ((PdfStream)this.getPdfObject()).put(PdfName.Resources, resources);
            }
            this.resources = new PdfResources(resources);
        }
        return this.resources;
    }

    public void flush() {
        this.resources = null;
        if (((PdfStream)this.getPdfObject()).get(PdfName.BBox) == null) {
            throw new PdfException("form.xobject.must.have.bbox");
        }
        super.flush();
    }

    public PdfFormXObject setProcessColorModel(PdfName model) {
        return this.put(PdfName.PCM, model);
    }

    public PdfName getProcessColorModel() {
        return ((PdfStream)this.getPdfObject()).getAsName(PdfName.PCM);
    }

    public PdfFormXObject setSeparationColorNames(PdfArray colorNames) {
        return this.put(PdfName.SeparationColorNames, colorNames);
    }

    public PdfArray getSeparationColorNames() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.SeparationColorNames);
    }

    public PdfFormXObject setTrapRegions(PdfArray regions) {
        return this.put(PdfName.TrapRegions, regions);
    }

    public PdfArray getTrapRegions() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.TrapRegions);
    }

    public PdfFormXObject setTrapStyles(PdfString trapStyles) {
        return this.put(PdfName.TrapStyles, trapStyles);
    }

    public PdfString getTrapStyles() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.TrapStyles);
    }

    public PdfFormXObject setMarkStyle(PdfString markStyle) {
        return this.put(PdfName.MarkStyle, markStyle);
    }

    public PdfString getMarkStyle() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.MarkStyle);
    }

    public PdfArray getBBox() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.BBox);
    }

    public PdfFormXObject setBBox(PdfArray bBox) {
        return this.put(PdfName.BBox, bBox);
    }

    public PdfFormXObject setGroup(PdfTransparencyGroup transparency) {
        return this.put(PdfName.Group, (PdfObject)transparency.getPdfObject());
    }

    public float getWidth() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(2).floatValue();
    }

    public float getHeight() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(3).floatValue();
    }

    public PdfFormXObject put(PdfName key, PdfObject value) {
        ((PdfStream)this.getPdfObject()).put(key, value);
        return this;
    }
}

