/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.numbering;

public class AlphabetNumbering {
    public static String toAlphabetNumber(int number, char[] alphabet) {
        if (number < 1) {
            throw new IllegalArgumentException("The parameter must be a positive integer");
        }
        int cardinality = alphabet.length;
        --number;
        int bytes = 1;
        int start = 0;
        int symbols = cardinality;
        while (number >= symbols + start) {
            ++bytes;
            start += symbols;
            symbols *= cardinality;
        }
        int c = number - start;
        char[] value = new char[bytes];
        while (bytes > 0) {
            value[--bytes] = alphabet[c % cardinality];
            c /= cardinality;
        }
        return new String(value);
    }
}

