/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.crypto.securityhandler;

import com.fr.third.fr.pdf.kernel.crypto.securityhandler.PubSecHandlerUsingStandard40;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.security.IExternalDecryptionProcess;
import java.security.Key;
import java.security.cert.Certificate;

public class PubSecHandlerUsingStandard128
extends PubSecHandlerUsingStandard40 {
    public PubSecHandlerUsingStandard128(PdfDictionary encryptionDictionary, Certificate[] certs, int[] permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        super(encryptionDictionary, certs, permissions, encryptMetadata, embeddedFilesOnly);
    }

    public PubSecHandlerUsingStandard128(PdfDictionary encryptionDictionary, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata) {
        super(encryptionDictionary, certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, encryptMetadata);
    }

    protected void setPubSecSpecificHandlerDicEntries(PdfDictionary encryptionDictionary, boolean encryptMetadata, boolean embeddedFilesOnly) {
        encryptionDictionary.put(PdfName.Filter, PdfName.Adobe_PubSec);
        PdfArray recipients = this.createRecipientsArray();
        if (encryptMetadata) {
            encryptionDictionary.put(PdfName.R, new PdfNumber(3));
            encryptionDictionary.put(PdfName.V, new PdfNumber(2));
            encryptionDictionary.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_s4);
            encryptionDictionary.put(PdfName.Recipients, recipients);
        } else {
            encryptionDictionary.put(PdfName.R, new PdfNumber(4));
            encryptionDictionary.put(PdfName.V, new PdfNumber(4));
            encryptionDictionary.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_s5);
            PdfDictionary stdcf = new PdfDictionary();
            stdcf.put(PdfName.Recipients, recipients);
            stdcf.put(PdfName.EncryptMetadata, PdfBoolean.FALSE);
            stdcf.put(PdfName.CFM, PdfName.V2);
            PdfDictionary cf = new PdfDictionary();
            cf.put(PdfName.DefaultCryptFilter, stdcf);
            encryptionDictionary.put(PdfName.CF, cf);
            if (embeddedFilesOnly) {
                encryptionDictionary.put(PdfName.EFF, PdfName.DefaultCryptFilter);
                encryptionDictionary.put(PdfName.StrF, PdfName.Identity);
                encryptionDictionary.put(PdfName.StmF, PdfName.Identity);
            } else {
                encryptionDictionary.put(PdfName.StrF, PdfName.DefaultCryptFilter);
                encryptionDictionary.put(PdfName.StmF, PdfName.DefaultCryptFilter);
            }
        }
    }
}

