/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.source;

import com.fr.third.fr.pdf.io.source.IRandomAccessSource;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ByteBufferRandomAccessSource
implements IRandomAccessSource {
    private final ByteBuffer byteBuffer;

    public ByteBufferRandomAccessSource(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public int get(long position) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        try {
            if (position >= (long)this.byteBuffer.limit()) {
                return -1;
            }
            byte b = this.byteBuffer.get((int)position);
            return b & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        if (position >= (long)this.byteBuffer.limit()) {
            return -1;
        }
        this.byteBuffer.position((int)position);
        int bytesFromThisBuffer = Math.min(len, this.byteBuffer.remaining());
        this.byteBuffer.get(bytes, off, bytesFromThisBuffer);
        return bytesFromThisBuffer;
    }

    public long length() {
        return this.byteBuffer.limit();
    }

    public void close() throws IOException {
        ByteBufferRandomAccessSource.clean(this.byteBuffer);
    }

    private static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean success = Boolean.FALSE;
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, (Object[])null);
                    Method clean = cleaner.getClass().getMethod("clean", null);
                    clean.invoke(cleaner, (Object[])null);
                    success = Boolean.TRUE;
                }
                catch (Exception e) {
                    Logger logger = LoggerFactory.getLogger(ByteBufferRandomAccessSource.class);
                    logger.debug(e.getMessage());
                }
                return success;
            }
        });
        return b;
    }
}

