/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf.lookuptype6;

import com.fr.third.fr.pdf.io.font.otf.ContextualSubstRule;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFontTableReader;
import com.fr.third.fr.pdf.io.font.otf.SubstLookupRecord;
import com.fr.third.fr.pdf.io.font.otf.lookuptype6.SubTableLookup6;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTableLookup6Format1
extends SubTableLookup6 {
    private Map<Integer, List<ContextualSubstRule>> substMap;

    public SubTableLookup6Format1(OpenTypeFontTableReader openReader, int lookupFlag, Map<Integer, List<ContextualSubstRule>> substMap) {
        super(openReader, lookupFlag);
        this.substMap = substMap;
    }

    @Override
    protected List<ContextualSubstRule> getSetOfRulesForStartGlyph(int startGlyphId) {
        if (this.substMap.containsKey(startGlyphId) && !this.openReader.isSkip(startGlyphId, this.lookupFlag)) {
            return this.substMap.get(startGlyphId);
        }
        return new ArrayList<ContextualSubstRule>(0);
    }

    public static class SubstRuleFormat1
    extends ContextualSubstRule {
        private int[] inputGlyphIds;
        private int[] backtrackGlyphIds;
        private int[] lookAheadGlyphIds;
        private SubstLookupRecord[] substLookupRecords;

        public SubstRuleFormat1(int[] backtrackGlyphIds, int[] inputGlyphIds, int[] lookAheadGlyphIds, SubstLookupRecord[] substLookupRecords) {
            this.backtrackGlyphIds = backtrackGlyphIds;
            this.inputGlyphIds = inputGlyphIds;
            this.lookAheadGlyphIds = lookAheadGlyphIds;
            this.substLookupRecords = substLookupRecords;
        }

        public int getContextLength() {
            return this.inputGlyphIds.length + 1;
        }

        public int getLookaheadContextLength() {
            return this.lookAheadGlyphIds.length;
        }

        public int getBacktrackContextLength() {
            return this.backtrackGlyphIds.length;
        }

        public SubstLookupRecord[] getSubstLookupRecords() {
            return this.substLookupRecords;
        }

        public boolean isGlyphMatchesInput(int glyphId, int atIdx) {
            return glyphId == this.inputGlyphIds[atIdx - 1];
        }

        public boolean isGlyphMatchesLookahead(int glyphId, int atIdx) {
            return glyphId == this.lookAheadGlyphIds[atIdx];
        }

        public boolean isGlyphMatchesBacktrack(int glyphId, int atIdx) {
            return glyphId == this.backtrackGlyphIds[atIdx];
        }
    }
}

