/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf;

import com.fr.third.com.lowagie.text.pdf.BaseFont;
import com.fr.third.com.lowagie.text.pdf.PdfEncodings;
import com.fr.third.com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GlyphList {
    private static HashMap unicode2names;
    private static HashMap names2unicode;

    static {
        block15: {
            unicode2names = new HashMap();
            names2unicode = new HashMap();
            InputStream is = null;
            try {
                try {
                    int size;
                    is = BaseFont.getResourceStream("com/fr/third/com/lowagie/text/pdf/fonts/glyphlist.txt", new FontsResourceAnchor().getClass().getClassLoader());
                    if (is == null) {
                        String msg = "glyphlist.txt not found as resource. (It must exist as resource in the package com.fr.third.com.lowagie.text.pdf.fonts)";
                        throw new Exception(msg);
                    }
                    byte[] buf = new byte[1024];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((size = is.read(buf)) >= 0) {
                        out.write(buf, 0, size);
                    }
                    is.close();
                    is = null;
                    String s = PdfEncodings.convertToString(out.toByteArray(), null);
                    StringTokenizer tk = new StringTokenizer(s, "\r\n");
                    while (tk.hasMoreTokens()) {
                        String line = tk.nextToken();
                        if (line.startsWith("#")) continue;
                        StringTokenizer t2 = new StringTokenizer(line, " ;\r\n\t\f");
                        String name = null;
                        String hex = null;
                        if (!t2.hasMoreTokens()) continue;
                        name = t2.nextToken();
                        if (!t2.hasMoreTokens()) continue;
                        hex = t2.nextToken();
                        Integer num = Integer.valueOf(hex, 16);
                        unicode2names.put(num, name);
                        names2unicode.put(name, new int[]{num});
                    }
                }
                catch (Exception e) {
                    System.err.println("glyphlist.txt loading error: " + e.getMessage());
                    if (is == null) break block15;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static int[] nameToUnicode(String name) {
        return (int[])names2unicode.get(name);
    }

    public static String unicodeToName(int num) {
        return (String)unicode2names.get(new Integer(num));
    }
}

