/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.output.html.chwriter;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.cache.Attachment;
import com.fr.data.DataUtils;
import com.fr.file.WebImage;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetDependProvider;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.FRFont;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.PaintUtils;
import com.fr.report.fun.CellTagTransformer;
import com.fr.report.fun.CellValueProvider;
import com.fr.report.fun.ReportHeavyTDProcessor;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import com.fr.web.core.utils.StyleWithSize;
import com.fr.web.output.common.CellUtils;
import com.fr.web.output.html.chwriter.DefaultCellTooltipProcessor;
import com.fr.web.output.html.chwriter.HtmlWriteCellBox;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Timestamp;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CellHtmlWriter {
    protected Repository repo;
    protected Tag resTag;
    protected int cellWidth;
    protected int cellHeight;
    protected CellGUIAttr cellGUIAttr;
    protected boolean heavy = false;
    private boolean isQuickModel = false;
    protected int reportIndex;
    protected int tableID = 0;
    protected ReportSettingsProvider reportSettings;
    protected boolean isUseLightHeavyTD = true;

    public CellHtmlWriter(Repository repository, int n2, ReportSettingsProvider reportSettingsProvider) {
        this.repo = repository;
        this.reportIndex = n2;
        this.reportSettings = reportSettingsProvider;
    }

    public static ColumnRow[] retriveCellElementPositions(CellElement cellElement) {
        if (cellElement.getColumnSpan() <= 1 && cellElement.getRowSpan() <= 1) {
            return new ColumnRow[]{ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow())};
        }
        int n2 = cellElement.getRow();
        int n3 = cellElement.getColumn();
        int n4 = cellElement.getRowSpan();
        int n5 = cellElement.getColumnSpan();
        ArrayList<ColumnRow> arrayList = new ArrayList<ColumnRow>();
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n3; i3 < n3 + n5; ++i3) {
                arrayList.add(ColumnRow.valueOf((int)i3, (int)i2));
            }
        }
        return arrayList.toArray(new ColumnRow[arrayList.size()]);
    }

    public Tag cell2Tag(HtmlWriteCellBox htmlWriteCellBox, WebReportCase webReportCase, Rectangle rectangle, Rectangle rectangle2, Calculator calculator) throws JSONException {
        ResultCellElement resultCellElement = htmlWriteCellBox.getCell();
        this.setShowWidgetAttr(webReportCase);
        this.initCellTagAndFillColumnRowSpan(rectangle);
        this.hideCellWhenNeed(webReportCase.getColumnPixWidth(resultCellElement.getColumn()));
        this.calculateCellWidthAndHeight(webReportCase, rectangle2);
        this.makeSureCellGUIAttrNotEmpty(resultCellElement);
        Tag tag = this.dealWithHyperlinkGroup(resultCellElement, this.resTag);
        ColumnRow columnRow = this.createAndMarkColumnRow(htmlWriteCellBox);
        Object object = this.calculateRawValue(resultCellElement, calculator);
        this.calculateTooltip(calculator, object);
        if (this.shouldDrawBackground(htmlWriteCellBox)) {
            ArrayList arrayList = new ArrayList();
            ReportHTMLWriterUtils.style2Css4Background(new StyleWithSize(resultCellElement.getStyle(), this.cellWidth, this.cellHeight), this.resTag, this.cellGUIAttr, this.repo, object, arrayList);
        }
        this.dealWidgetWhenNotEmpty(webReportCase, resultCellElement, columnRow, object, calculator);
        this.dealContent(resultCellElement, tag, object);
        this.processOtherAttributes(htmlWriteCellBox, calculator);
        this.anyElse(htmlWriteCellBox);
        calculator.remove("$$$");
        return this.resTag;
    }

    public void setShowWidgetAttr(WebReportCase webReportCase) {
    }

    public void dealContent(CellElement cellElement, Tag tag, Object object) {
        if (this.shouldDrawContent(object, cellElement, tag)) {
            this.dealBeforeDrawContent(cellElement);
            this.drawContent(cellElement, object, tag);
        }
    }

    public int getReportIndex() {
        return this.reportIndex;
    }

    private void initCellTagAndFillColumnRowSpan(Rectangle rectangle) {
        this.resTag = new Tag("td");
        if (rectangle.width > 1) {
            this.resTag.attr("colSpan", rectangle.width + "");
        }
        if (rectangle.height > 1) {
            this.resTag.attr("rowSpan", rectangle.height + "");
        }
    }

    private void hideCellWhenNeed(int n2) {
        if (n2 == 0) {
            this.resTag.css("display", "none");
        }
    }

    private void calculateCellWidthAndHeight(WebReportCase webReportCase, Rectangle rectangle) {
        Dimension dimension = CellUtils.calculateCellDimension(webReportCase, rectangle);
        this.cellWidth = dimension.width;
        this.cellHeight = dimension.height;
        if (this.repo.getBrowser().isUseTDWidthInTable()) {
            this.resTag.attr("width", this.cellWidth + "");
        }
    }

    public void makeSureCellGUIAttrNotEmpty(CellElement cellElement) {
        this.cellGUIAttr = cellElement.getCellGUIAttr();
        if (this.cellGUIAttr == null) {
            this.cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
    }

    private ColumnRow createAndMarkColumnRow(HtmlWriteCellBox htmlWriteCellBox) {
        ColumnRow columnRow = this.getColumnRowOfBox(htmlWriteCellBox);
        if (columnRow != null) {
            this.writeLocationID(columnRow);
            this.columnRowPosition(columnRow);
        }
        return columnRow;
    }

    public Object calculateRawValue(CellElement cellElement, Calculator calculator) {
        Object object = this.calculateRawValue(cellElement);
        this.processUnwrappedRawValue(cellElement, object);
        calculator.set("$$$", object);
        return object;
    }

    public Object calculateRawValue(CellElement cellElement) {
        Object object = this.getRawValue(cellElement);
        if (object instanceof Formula) {
            this.processFormula(cellElement, (Formula)object);
            object = this.dealWithValue4Formula((Formula)object);
        }
        object = this.unwrapLobs(cellElement, object);
        return object;
    }

    private void calculateTooltip(Calculator calculator, Object object) {
        String string = this.cellGUIAttr.getTooltipText();
        if (string != null) {
            this.resTag = DefaultCellTooltipProcessor.getInstance().process(calculator, this.resTag, string, object);
        }
        Set set = ExtraReportClassManager.getInstance().getArray("CellTagTransformer");
        for (CellTagTransformer cellTagTransformer : set) {
            this.resTag = cellTagTransformer.process(calculator, this.resTag, string, object);
        }
    }

    public boolean showUseHeavy(CellElement cellElement) {
        int n2 = cellElement.getCellGUIAttr() == null || cellElement.getCellGUIAttr().getAdjustMode() == 3 ? this.reportSettings.getShrinkToFitMode() : cellElement.getCellGUIAttr().getAdjustMode();
        return n2 != 1 && n2 != 2 || this.isHeavy();
    }

    protected void drawContent(CellElement cellElement, Object object, Tag tag) {
        Style style = cellElement.getStyle();
        Object object2 = this.unwrapLobs(cellElement, this.getDisplayValue(cellElement, object));
        if ((object2 = this.processDisplayValue(cellElement, style, object2)) == null) {
            return;
        }
        int n2 = Math.max(this.getHeightOfValueWrapper(cellElement), 0) - 1;
        Tag tag2 = this.getValueWrapper(tag, style, cellElement, n2);
        if (this.shouldBeDisplayAsVerticalText(style, object2)) {
            this.displayVerticalText(style, object2, tag2, n2);
            return;
        }
        if (style.getRotation() != 0) {
            this.displayVerticalText(style, object2, tag2, n2);
        } else {
            this.displayNormalText(cellElement, object2, tag2, n2);
        }
    }

    private Object processDisplayValue(CellElement cellElement, Style style, Object object) {
        if (object instanceof Formula) {
            this.processFormula(cellElement, (Formula)object);
            object = this.dealWithValue4Formula((Formula)object);
        }
        Set set = ExtraReportClassManager.getInstance().getArray("CellValueProvider");
        for (CellValueProvider cellValueProvider : set) {
            object = cellValueProvider.processBeforeToTag(object, this.cellGUIAttr, style, this.cellWidth, this.cellHeight);
        }
        return object;
    }

    protected boolean shouldBeDisplayAsVerticalText(Style style, Object object) {
        FRFont fRFont = style.getFRFont();
        int n2 = GraphHelper.getLineStyleSize((int)fRFont.getUnderline());
        return style.getVerticalText() == 1 || style.getTextStyle() == 3 || style.getTextStyle() == 2 || BaseUtils.getAlignment4Horizontal((Style)style) == 6 || object instanceof Painter || object instanceof Image || object instanceof Attachment || object instanceof WebImage || this.cellGUIAttr.isShowAsImage() || n2 > 1;
    }

    protected void displayVerticalText(Style style, Object object, Tag tag, int n2) {
        if (object instanceof String && this.cellGUIAttr.isShowAsHTML()) {
            object = PaintUtils.createHTMLContentBufferedImage((String)object, new Rectangle(this.cellWidth, this.cellHeight), 0, 0, style);
        }
        if (this.painterAsImage()) {
            ReportHTMLWriterUtils.value2PaintableTag4Print(object, new StyleWithSize(style, this.cellWidth, n2), tag, this.repo);
        } else {
            ReportHTMLWriterUtils.value2PaintableTag(object, new StyleWithSize(style, this.cellWidth, n2), tag, this.repo);
        }
    }

    protected void displayNormalText(CellElement cellElement, Object object, Tag tag, int n2) {
        Html html = this.getHtmlValue(cellElement, object, tag, n2);
        if (html != null) {
            tag.sub(html);
        }
    }

    protected Html getHtmlValue(CellElement cellElement, Object object, Tag tag, int n2) {
        String string;
        Style style = cellElement.getStyle();
        String string2 = null;
        Widget widget = this.getWidgetOfCell(cellElement);
        if (this.cellGUIAttr.isShowAsHTML()) {
            tag.attr("showAsHtml", "true");
            if (widget == null || widget.isEditor()) {
                string = Utils.objectToString((Object)object);
                Pattern pattern = Pattern.compile("<script[^>]*>[\\d\\D]*?</script>", 2);
                Matcher matcher = pattern.matcher(string);
                string2 = matcher.replaceAll("");
            }
        } else if (widget == null || widget.isEditor()) {
            string = Style.valueToText((Object)object, (Format)cellElement.getStyle().getFormat());
            style = Style.modCellStyleString((int)this.cellWidth, (int)n2, (String)string, (Style)style, (int)this.repo.getResolution());
            string2 = CodeUtils.htmlEncode((CharSequence)string);
        }
        string = null;
        if (StringUtils.isNotBlank(string2)) {
            string = new TextHtml(string2);
            if (style.getFRFont().isSubscript()) {
                string = new Tag("sub").sub((Html)string);
            } else if (style.getFRFont().isSuperscript()) {
                string = new Tag("sup").sub((Html)string);
            }
        }
        return string;
    }

    private void dealWidgetWhenNotEmpty(WebReportCase webReportCase, CellElement cellElement, ColumnRow columnRow, Object object, Calculator calculator) {
        Widget widget = this.getWidgetOfCell(cellElement);
        if (widget != null) {
            this.processWidget(webReportCase, cellElement, widget, object, columnRow, calculator);
        } else {
            this.processNoneWidget(webReportCase, cellElement, object, columnRow, calculator);
        }
    }

    protected boolean painterAsImage() {
        return false;
    }

    protected void columnRowPosition(ColumnRow columnRow) {
        this.resTag.attr("id", columnRow + "-" + this.reportIndex + "-" + this.tableID);
    }

    protected void writeLocationID(ColumnRow columnRow) {
        this.resTag.attr("id", columnRow + "-" + this.reportIndex + "-" + this.tableID);
    }

    protected abstract ColumnRow getColumnRowOfBox(HtmlWriteCellBox var1);

    protected abstract boolean isVisible(HtmlWriteCellBox var1);

    protected boolean shouldDrawBackground(HtmlWriteCellBox htmlWriteCellBox) {
        return this.isVisible(htmlWriteCellBox);
    }

    protected abstract boolean shouldDrawContent(Object var1, CellElement var2, Tag var3);

    public int getHeightOfValueWrapper(CellElement cellElement) {
        return this.cellHeight;
    }

    private Tag getValueWrapper(Tag tag, Style style, CellElement cellElement, int n2) {
        Tag tag2 = tag;
        boolean bl = this.showUseHeavy(cellElement);
        if (bl) {
            ReportHeavyTDProcessor reportHeavyTDProcessor = (ReportHeavyTDProcessor)ExtraReportClassManager.getInstance().getSingle("ReportHeavyTDProcessor");
            if (!this.isUseLightHeavyTD && reportHeavyTDProcessor != null) {
                tag2 = reportHeavyTDProcessor.createTDWrapper(tag, style, cellElement, n2, this.cellWidth, this.repo, this);
            } else {
                Tag tag3 = new Tag("div").css("max-height", n2 + "px").attr("heavytd", "light");
                tag.sub((Html)tag3);
                tag2 = tag3;
            }
        }
        return tag2;
    }

    public boolean skipValueWrapper(CellElement cellElement) {
        return false;
    }

    protected Object getRawValue(CellElement cellElement) {
        return cellElement.getValue();
    }

    protected void processFormula(CellElement cellElement, Formula formula) {
    }

    protected void processUnwrappedRawValue(CellElement cellElement, Object object) {
    }

    protected Object getDisplayValue(CellElement cellElement, Object object) {
        return object;
    }

    protected abstract Widget getWidgetOfCell(CellElement var1);

    protected void processWidget(WebReportCase webReportCase, CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
    }

    protected void processNoneWidget(WebReportCase webReportCase, CellElement cellElement, Object object, ColumnRow columnRow, Calculator calculator) {
    }

    protected void processOtherAttributes(HtmlWriteCellBox htmlWriteCellBox, Calculator calculator) {
    }

    protected void anyElse(HtmlWriteCellBox htmlWriteCellBox) {
    }

    protected void dealBeforeDrawContent(CellElement cellElement) {
    }

    protected Tag dealWithHyperlinkGroup(CellElement cellElement, Tag tag) throws JSONException {
        NameJavaScriptGroup nameJavaScriptGroup = cellElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            Style style = cellElement.getStyle();
            Tag tag2 = tag;
            if (style.getBackground() == null || style.getBackground() instanceof ColorBackground) {
                tag2 = new Tag("span");
                tag.sub((Html)tag2);
            }
            tag2.css("cursor", "pointer");
            tag2.attr("onclick", "FR.doHyperlink(event||window.event, " + BaseUtils.writeJSLinkContent((NameJavaScriptGroup)nameJavaScriptGroup, (Repository)this.repo) + ", true)");
            tag.cls("celink");
            tag2.cls("linkspan");
            return tag2;
        }
        return tag;
    }

    public void dealWithEmptyHeight(Tag tag) {
        tag.css("display", "none");
    }

    protected JSONObject widget2ConfigWithJSONStyle(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        Map map;
        Object object2;
        if (widget instanceof DateEditor && object != null && !(object instanceof Timestamp)) {
            object2 = object.toString();
            if (StringUtils.isNotBlank((String)object2)) {
                try {
                    if (object instanceof Date) {
                        object = DateUtils.DATEFORMAT1.format((Date)object);
                    }
                }
                catch (Throwable throwable) {
                    object = object2;
                    FRContext.getLogger().error(throwable.getMessage());
                }
            } else {
                object = object2;
            }
        }
        object2 = widget.createJSONConfig(this.repo, calculator, null);
        object2.put("value", widget.value2Config(object, this.repo.getCalculator()));
        object2.put("widgetUrl", (Object)this.repo.checkoutObject((Object)new JSONObject().put("reportIndex", n2).put("column", columnRow.getColumn()).put("row", columnRow.getRow()), string));
        object2.put("sessionID", (Object)RepositoryHelper.getSessionIDInfor((Repository)this.repo).getSessionID());
        object2.put("location", (Object)ColumnRow.valueOf((int)columnRow.getColumn(), (int)columnRow.getRow()));
        object2.put("reportIndex", n2);
        Style style = cellElement.getStyle();
        if (style != null) {
            object2.put("border", (Object)style.border2JSONObject());
        }
        if (widget instanceof WidgetDependProvider && (map = ((WidgetDependProvider)widget).getDependenceMap()) != null) {
            object2.put("dependenceMap", map);
        }
        if (widget instanceof MultiFileEditor && (object instanceof FArray || object instanceof Attachment || object instanceof Image)) {
            object2.put("attachment", true);
        }
        object2.put("fontSize", cellElement.getStyle().getFRFont().getSize());
        return object2;
    }

    protected String widget2Config(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        return this.widget2ConfigWithJSONStyle(widget, object, columnRow, cellElement, n2, string, calculator).toString();
    }

    protected Object dealWithValue4Formula(Formula formula) {
        return formula.getResult();
    }

    protected Object unwrapLobs(CellElement cellElement, Object object) {
        Object object2 = DataUtils.resolveOtherValue((Object)object, (boolean)this.cellGUIAttr.isShowAsImage(), (boolean)this.cellGUIAttr.isShowAsDownload(), (Object)this.cellGUIAttr.getFileName(), (boolean)false);
        if (object2 instanceof Attachment) {
            String string = ((Attachment)object2).getID();
            RepositoryHelper.getSessionIDInfor((Repository)this.repo).addImageID(string);
        }
        return object2;
    }

    public void setHeavy(boolean bl) {
        this.heavy = bl;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public boolean isUseLightHeavyTD() {
        return this.isUseLightHeavyTD;
    }

    public void setUseLightHeavyTD(boolean bl) {
        this.isUseLightHeavyTD = bl;
    }

    public void setTableID(int n2) {
        this.tableID = n2;
    }

    public int getTableID() {
        return this.tableID;
    }

    public Tag getTitleTag(PolyBlockAttr polyBlockAttr) {
        return null;
    }

    public void setQuickModel(boolean bl) {
        this.isQuickModel = bl;
    }

    public boolean isQuickModel() {
        return this.isQuickModel;
    }

    public boolean mayHideTailRows() {
        return false;
    }

    public void setTablePosition(Tag tag) {
    }
}

