/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;

public class AlertControl {
    public static final String TIME_NUMBER = "timeNumber";
    public static final String TIME_TYPE = "timeType";
    public static final String ALERT_TYPE = "alertType";
    public static final String MESSAGE = "message";
    private int timeNumber = 0;
    private int timeType = -1;
    private int alertType = -1;
    private String message;

    public AlertControl(String string) {
        if (string == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.timeNumber = jSONObject.optInt(TIME_NUMBER);
            this.timeType = jSONObject.optInt(TIME_TYPE);
            Object object = jSONObject.get(ALERT_TYPE);
            if (object instanceof Integer) {
                this.alertType = (Integer)object;
            } else if (object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                if (jSONArray.length() == 2) {
                    this.alertType = 2;
                } else if (jSONArray.length() == 1) {
                    this.alertType = jSONArray.getInt(0);
                }
            }
            this.message = jSONObject.optString(MESSAGE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AlertControl(int n2, int n3, int n4) {
        this.timeNumber = n2;
        this.timeType = n3;
        this.alertType = n4;
    }

    public int getTimeNumber() {
        return this.timeNumber;
    }

    public void setTimeNumber(int n2) {
        this.timeNumber = n2;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public void setTimeType(int n2) {
        this.timeType = n2;
    }

    public boolean isEmail() {
        return this.alertType == 0;
    }

    public boolean isToast() {
        return this.alertType == 1;
    }

    public boolean isAll() {
        return this.alertType == 2;
    }

    public int getAlertType() {
        return this.alertType;
    }

    public void setAlertType(int n2) {
        this.alertType = n2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public long getTimeMil() {
        switch (this.timeType) {
            case 0: {
                return (long)this.timeNumber * 60000L;
            }
            case 1: {
                return (long)this.timeNumber * 3600000L;
            }
            case 2: {
                return (long)this.timeNumber * 86400000L;
            }
            case 3: {
                return (long)this.timeNumber * 604800000L;
            }
            case 4: {
                return (long)this.timeNumber * 2592000000L;
            }
        }
        return 0L;
    }

    public boolean isValid() {
        return this.timeNumber >= 0;
    }

    public String getTimeString() {
        String string = this.timeNumber + "";
        switch (this.timeType) {
            case 0: {
                string = string + Inter.getLocText((String)"Minute");
                break;
            }
            case 1: {
                string = string + Inter.getLocText((String)"Hour");
                break;
            }
            case 2: {
                string = string + Inter.getLocText((String)"Day");
                break;
            }
            case 3: {
                string = string + Inter.getLocText((String)"Week");
                break;
            }
            case 4: {
                string = string + Inter.getLocText((String)"Month");
            }
        }
        return string;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(TIME_NUMBER, this.timeNumber);
            jSONObject.put(TIME_TYPE, this.timeType);
            jSONObject.put(ALERT_TYPE, this.alertType);
            jSONObject.put(MESSAGE, (Object)this.message);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on alertControl");
        }
        return jSONObject.toString();
    }
}

