/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.base.DynamicUnitList;
import com.fr.base.ResultFormula;
import com.fr.general.ComparatorUtils;
import com.fr.page.ClippedPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.core.block.PolyResultWorkSheet;
import com.fr.report.elementcase.AbstractResultElementCase;
import com.fr.report.poly.ClippedPolyPage;
import com.fr.report.poly.PolyECBlockPageGenerator;
import com.fr.report.report.ResultReport;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.stable.ColumnRow;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitRectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultECBlock
extends AbstractResultElementCase
implements ClippedPolyPage {
    protected UnitRectangle bounds;
    protected String blockName;
    protected PolyBlockAttr blockAttr;

    @Override
    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public void setBlockName(String string) {
        this.blockName = string;
    }

    @Override
    public PolyBlockAttr getBlockAttr() {
        return this.blockAttr;
    }

    public void setBlockAttr(PolyBlockAttr polyBlockAttr) {
        this.blockAttr = polyBlockAttr;
    }

    @Override
    public UnitRectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(UnitRectangle unitRectangle) {
        this.bounds = unitRectangle;
    }

    @Override
    public ClippedPageProvider createInnerClippedPage(ResultReport resultReport, UnitRectangle unitRectangle, ReportSettingsProvider reportSettingsProvider, UNIT uNIT, UNIT uNIT2, int n2, int n3) {
        return new PolyECBlockPageGenerator(resultReport, unitRectangle, reportSettingsProvider.getPaperSetting(), uNIT, uNIT2, n2, n3).generatePage(this);
    }

    @Override
    public boolean isCells() {
        return true;
    }

    @Override
    public UNIT getEffectiveWidth() {
        return ReportHelper.getTotalColumnWidth(this);
    }

    @Override
    public UNIT getEffectiveHeight() {
        return ReportHelper.getTotalRowHeight(this);
    }

    @Override
    public void addElemToSheet(ArrayList<UNIT> arrayList, ArrayList<UNIT> arrayList2, PolyResultWorkSheet polyResultWorkSheet) {
        UnitRectangle unitRectangle = this.getBounds();
        UNIT uNIT = unitRectangle.getX();
        UNIT uNIT2 = unitRectangle.getY();
        DynamicUnitList dynamicUnitList = polyResultWorkSheet.getRowHeightList_DEC();
        DynamicUnitList dynamicUnitList2 = polyResultWorkSheet.getColumnWidthList_DEC();
        int n2 = polyResultWorkSheet.getRowCount();
        int n3 = polyResultWorkSheet.getColumnCount();
        DynamicUnitList dynamicUnitList3 = this.getRowHeightList_DEC();
        DynamicUnitList dynamicUnitList4 = this.getColumnWidthList_DEC();
        Iterator iterator = this.cellIterator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<CellElement, ResultFormula> hashMap2 = new HashMap<CellElement, ResultFormula>();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            FU fU = uNIT.add((UNIT)dynamicUnitList4.getRangeValueFromZero(cellElement.getColumn()));
            FU fU2 = dynamicUnitList4.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
            FU fU3 = uNIT2.add((UNIT)dynamicUnitList3.getRangeValueFromZero(cellElement.getRow()));
            FU fU4 = dynamicUnitList3.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan());
            int n4 = arrayList2.indexOf(fU) + 1;
            int n5 = this.getNewSpan(n4, dynamicUnitList2, (UNIT)fU2, n3);
            int n6 = arrayList.indexOf(fU3) + 1;
            int n7 = this.getNewSpan(n6, dynamicUnitList, (UNIT)fU4, n2);
            ColumnRow columnRow = ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow());
            ColumnRow columnRow2 = ColumnRow.valueOf((int)n4, (int)n6);
            hashMap.put(columnRow.toString(), columnRow2.toString());
            ResultCellElement resultCellElement = (ResultCellElement)cellElement.deriveCellElement(n4, n6, n5, n7);
            polyResultWorkSheet.addCellElement(resultCellElement);
            if (!(cellElement.getValue() instanceof ResultFormula)) continue;
            hashMap2.put(resultCellElement, (ResultFormula)cellElement.getValue());
        }
        this.modifyAllFormula(hashMap2, hashMap);
    }

    private void modifyAllFormula(HashMap<CellElement, ResultFormula> hashMap, HashMap<String, String> hashMap2) {
        for (Map.Entry<CellElement, ResultFormula> entry : hashMap.entrySet()) {
            CellElement cellElement = entry.getKey();
            ResultFormula resultFormula = entry.getValue();
            String string = resultFormula.getTransferContent();
            for (Map.Entry<String, String> entry2 : hashMap2.entrySet()) {
                String string2 = entry2.getKey();
                String string3 = entry2.getValue();
                if (string.indexOf(string2) == -1) continue;
                string = this.getNewFormula(string, string2, string3);
                resultFormula.setTransferContent(string);
                cellElement.setValue(resultFormula);
            }
        }
    }

    private String getNewFormula(String string, String string2, String string3) {
        String[] stringArray = string.toUpperCase().split(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (!string.endsWith(string2) && i2 == n2 - 1) continue;
            String string4 = this.getNewColumnRow(stringArray[i2], i2 + 1, stringArray, string2, string3);
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    private String getNewColumnRow(String string, int n2, String[] stringArray, String string2, String string3) {
        if (string.endsWith("$")) {
            return string2;
        }
        if (n2 < stringArray.length && this.startsWithDigit(stringArray[n2])) {
            return string2;
        }
        return string3;
    }

    private boolean startsWithDigit(String string) {
        return Pattern.compile("^[0-9]").matcher(string.trim()).find();
    }

    private int getNewSpan(int n2, DynamicUnitList dynamicUnitList, UNIT uNIT, int n3) {
        for (int i2 = n2; i2 < n3 + 1; ++i2) {
            if (!ComparatorUtils.equals((Object)uNIT, (Object)dynamicUnitList.getRangeValue(n2, i2))) continue;
            return i2 - n2;
        }
        return 0;
    }
}

