/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core.group;

import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.report.cell.cellattr.core.group.ConditionGroup;
import com.fr.report.cell.cellattr.core.group.FunctionGrouper;
import com.fr.report.cell.cellattr.core.group.Group;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class CustomGrouper
extends RecordGrouper {
    public static final int TOGETHER = 0;
    public static final int DISCARD = 1;
    public static final int LEAVE = 2;
    private boolean force = false;
    private ConditionGroup[] conditionGroups;
    private boolean more = true;
    private int other = 0;
    private String otherDisplay = Inter.getLocText((String)"Other");

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isMore() {
        return this.more;
    }

    public void setMore(boolean bl) {
        this.more = bl;
    }

    public ConditionGroup[] getConditionGroups() {
        return this.conditionGroups;
    }

    public void setConditionGroups(ConditionGroup[] conditionGroupArray) {
        this.conditionGroups = conditionGroupArray;
    }

    public int getOther() {
        return this.other;
    }

    public void setOther(int n2) {
        this.other = n2;
    }

    public String getOtherdisplay() {
        return this.otherDisplay;
    }

    public void setOdisplay(String string) {
        this.otherDisplay = string;
    }

    public Group[] group(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        if (!VT4FR.ADVANCED_FORMULA.support()) {
            throw new RegistEditionException(VT4FR.ADVANCED_FORMULA);
        }
        if (n2 == -1) {
            return super.group(dataModel, n2, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range((int)dataModel.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), (Throwable)tableDataException);
            }
        }
        if (this.conditionGroups == null || n2 < 0 || nArray.length == 0) {
            return new Group[0];
        }
        Object[] objectArray = new Object[this.conditionGroups.length];
        IntList[] intListArray = new IntList[this.conditionGroups.length];
        for (int i2 = 0; i2 < this.conditionGroups.length; ++i2) {
            objectArray[i2] = this.conditionGroups[i2].getDisplay();
            intListArray[i2] = new IntList();
        }
        IntList intList = this.initOtherObjectRowIndex(nArray, dataModel, n2, calculator, intListArray);
        List list = this.calculateResultList(intListArray, objectArray, intList, dataModel, n2, calculator);
        return list.toArray(new Group[list.size()]);
    }

    private IntList initOtherObjectRowIndex(int[] nArray, DataModel dataModel, int n2, Calculator calculator, IntList[] intListArray) {
        IntList intList = new IntList();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            boolean bl = false;
            for (int i3 = 0; i3 < this.conditionGroups.length; ++i3) {
                ConditionGroup conditionGroup = this.conditionGroups[i3];
                if (conditionGroup.getCondition().evalTableData(dataModel, new int[]{n3}, n2, (CalculatorProvider)calculator).length <= 0) continue;
                intListArray[i3].add(n3);
                bl = true;
                if (!this.more) break;
            }
            if (bl) continue;
            intList.add(n3);
        }
        return intList;
    }

    private List calculateResultList(IntList[] intListArray, Object[] objectArray, IntList intList, DataModel dataModel, int n2, Calculator calculator) {
        Group[] groupArray;
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (int i2 = 0; i2 < intListArray.length; ++i2) {
            groupArray = intListArray[i2];
            if (!this.force && groupArray.size() == 0) continue;
            arrayList.add(new Group(objectArray[i2], groupArray.toArray()));
        }
        if (this.other != 1 && intList.size() > 0) {
            switch (this.other) {
                case 0: {
                    arrayList.add(new Group(this.otherDisplay, intList.toArray()));
                    break;
                }
                case 2: {
                    FunctionGrouper functionGrouper = new FunctionGrouper();
                    groupArray = ((RecordGrouper)functionGrouper).group(dataModel, n2, intList.toArray(), calculator);
                    int n3 = groupArray.length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        arrayList.add(groupArray[i3]);
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                this.setOther(xMLableReader.getAttrAsInt("other", 0));
                String string2 = xMLableReader.getAttrAsString("odisplay", null);
                if (string2 != null) {
                    this.setOdisplay(string2);
                }
                this.setForce(xMLableReader.getAttrAsBoolean("force", false));
                this.setMore(xMLableReader.getAttrAsBoolean("more", false));
            } else if ("ConditionListGroup".equals(string)) {
                ConditionGroup conditionGroup = new ConditionGroup();
                xMLableReader.readXMLObject((XMLReadable)conditionGroup);
                if (this.conditionGroups == null) {
                    this.conditionGroups = new ConditionGroup[]{conditionGroup};
                } else {
                    ConditionGroup[] conditionGroupArray = this.conditionGroups;
                    this.conditionGroups = new ConditionGroup[conditionGroupArray.length + 1];
                    System.arraycopy(conditionGroupArray, 0, this.conditionGroups, 0, conditionGroupArray.length);
                    this.conditionGroups[conditionGroupArray.length] = conditionGroup;
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr");
        xMLPrintWriter.attr("other", this.other);
        if (this.other == 0 && !this.otherDisplay.equals("Others")) {
            xMLPrintWriter.attr("odisplay", this.otherDisplay);
        }
        if (this.force) {
            xMLPrintWriter.attr("force", this.force);
        }
        if (this.more) {
            xMLPrintWriter.attr("more", this.more);
        }
        xMLPrintWriter.end();
        if (this.conditionGroups != null) {
            for (int i2 = 0; i2 < this.conditionGroups.length; ++i2) {
                xMLPrintWriter.startTAG("ConditionListGroup");
                this.conditionGroups[i2].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
    }
}

