/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter.excel.stream;

import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.io.attr.ExcelExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExcelExporterReport;
import com.fr.io.exporter.AbstractExcelExporter;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.excel.stream.StreamExcelReportExporter;
import com.fr.io.exporter.poi.wrapper.POICellAction;
import com.fr.io.exporter.poi.wrapper.POIFontAction;
import com.fr.io.exporter.poi.wrapper.POIRichStringAction;
import com.fr.io.exporter.poi.wrapper.POISheetAction;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.io.exporter.poi.wrapper.XssfCellStyleWrapper;
import com.fr.io.exporter.poi.wrapper.XssfFontWrapper;
import com.fr.io.exporter.poi.wrapper.XssfRichStringWrapper;
import com.fr.io.exporter.poi.wrapper.XssfWorkbookWrapper;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.script.Calculator;
import com.fr.stable.ExportConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaParser;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellStyle;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DataFormat;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Font;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Workbook;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFEvaluationWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFColor;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFFont;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import com.fr.web.core.reserve.ExportFactory;
import com.fr.web.core.utils.ExportUtils;
import java.awt.Color;
import java.awt.Point;
import java.io.OutputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamExcel2007Exporter<T>
extends AbstractExcelExporter<T> {
    protected XSSFCellStyle defaultXSSFCellStyle = null;
    protected DataFormat format = null;
    private SXSSFEvaluationWorkbook evaluator;

    public StreamExcel2007Exporter() {
        this(null);
    }

    public StreamExcel2007Exporter(List<PaperSettingProvider> list) {
        this.paperSettingList = list;
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        ArrayList<Report> arrayList = new ArrayList<Report>();
        this.defaultXSSFCellStyle = null;
        this.hssfFontHash.clear();
        this.hssfCellStyleHash.clear();
        this.format = null;
        SXSSFWorkbook sXSSFWorkbook = null;
        try {
            sXSSFWorkbook = new SXSSFWorkbook(null, 100, false, true);
        }
        catch (Throwable throwable) {
            sXSSFWorkbook = new SXSSFWorkbook(100);
        }
        this.evaluator = SXSSFEvaluationWorkbook.create((SXSSFWorkbook)sXSSFWorkbook);
        this.setDefaultFont(new XssfWorkbookWrapper((Workbook)sXSSFWorkbook));
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.exportBook(resultWorkBook, new XssfWorkbookWrapper((Workbook)sXSSFWorkbook), arrayList2, arrayList3, arrayList, bl);
        if (StringUtils.isNotEmpty((String)this.getPassword(resultWorkBook))) {
            FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine_Excel2007-not-support-pwd"));
        }
        try {
            sXSSFWorkbook.write(outputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputStream.flush();
        sXSSFWorkbook.dispose();
    }

    protected void dealWithFormula(Cell cell, String string) {
        try {
            FormulaParser.parse((String)string, (FormulaParsingWorkbook)this.evaluator, (int)0, (int)0);
            cell.setCellType(2);
            cell.setCellFormula(string);
        }
        catch (Exception exception) {
            cell.setCellType(1);
            cell.setCellValue("=" + string);
        }
    }

    @Override
    protected String dealWithSumFormula(String string, Object object, Formula formula, boolean bl) {
        String string2 = ((ResultFormula)object).getTransferContent();
        if (!bl && this.checkSumValid(string, string2)) {
            String[] stringArray = string2.split(",");
            string = stringArray[0] + ":" + stringArray[stringArray.length - 1];
        } else {
            string = string2;
            string = ComparatorUtils.equals((String)string, (String)"=") ? formula.getContent() : string;
        }
        return string;
    }

    private boolean checkSumValid(String string, String string2) {
        try {
            String string3 = StringUtils.perfectStart((String)string, (String)"=").replaceAll(" ", "").toUpperCase();
            return string3.indexOf("=SUM(") != -1 && string.indexOf(":") != -1 && string.split("[(:,)]").length == 3 && string2.indexOf(",") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void innerExportReports(ResultECReport resultECReport, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        int n3 = resultECReport.getColumnCount();
        int n4 = resultECReport.getRowCount();
        Point point = new Point(0, 0);
        int n5 = 1;
        while (point.x < n3) {
            point.y = 0;
            while (point.y < n4) {
                try {
                    this.innerExportReport(new ExcelExporterReport(resultECReport, point.x, point.y, Math.min(n3 - point.x, ExportConstants.MAX_COLS_2007), Math.min(n4 - point.y, ExportConstants.MAX_ROWS_2007)), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n2) + (n5 == 1 ? "" : "_" + n5), (SXSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n2);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
                point.y += ExportConstants.MAX_ROWS_2007;
                ++n5;
            }
            point.x += ExportConstants.MAX_COLS_2007;
        }
    }

    @Override
    protected Object checkNumberFormat(Format format, Object object) {
        return ExportUtils.checkExcel2007NumberFormat(format, object);
    }

    protected void innerExportReport(Report report, ReportExportAttr reportExportAttr, String string, SXSSFWorkbook sXSSFWorkbook, List list, List list2, int n2) throws Exception {
        ExcelExportAttr excelExportAttr = reportExportAttr == null ? new ExcelExportAttr() : reportExportAttr.getExcelExportAttr();
        StreamExcelReportExporter streamExcelReportExporter = new StreamExcelReportExporter((ElementCase)((Object)report), string, sXSSFWorkbook, list, list2, excelExportAttr, n2, this.paperSettingList, this.columnRowPostileMaps, this);
        streamExcelReportExporter.export();
    }

    @Override
    protected int getFloatLeftMax(double d2) {
        return (int)(9525.0 * d2);
    }

    @Override
    protected int getFloatTopMax(double d2) {
        return (int)(9525.0 * d2);
    }

    private Object evalCellFormula(Object object, boolean bl, boolean bl2) {
        Formula formula = (Formula)object;
        if (formula.isReserveInResult() && formula instanceof ResultFormula) {
            String string = formula.getContent();
            boolean bl3 = !bl || !bl2;
            string = this.dealWithSumFormula(string, object, formula, bl3);
            return new Formula(string);
        }
        object = formula.getResult();
        return object;
    }

    @Override
    public Object evalCellValue(CellElement cellElement, boolean bl, boolean bl2, List list, POICellAction pOICellAction, Calculator calculator, Style style, List list2, CellGUIAttr cellGUIAttr, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, POIWorkbookAction pOIWorkbookAction) {
        return super.evalCellValue(cellElement, bl, bl2, list, pOICellAction, calculator, style, list2, cellGUIAttr, dynamicUnitList, dynamicUnitList2, n2, n3, n4, n5, pOIWorkbookAction);
    }

    @Override
    protected Object evalFormulaValue(Object object, boolean bl, boolean bl2, List list, POICellAction pOICellAction, Calculator calculator, List list2) {
        return this.evalCellFormula(object, bl, bl2);
    }

    private Style dealBackgroundStyle(Style style) {
        Background background = style.getBackground();
        if (background != null && (background = background.traverseForExport(new ObjectHolder((Object)ExportFactory.getOperate("excel")))) == null) {
            return style.deriveBackground(null);
        }
        return style;
    }

    public CellStyle createXSSFCellStyle(SXSSFWorkbook sXSSFWorkbook, Style style) {
        if (style == null) {
            if (this.defaultXSSFCellStyle == null) {
                this.defaultXSSFCellStyle = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
                this.executeXSSFCellStyle(sXSSFWorkbook, this.defaultXSSFCellStyle, Style.DEFAULT_STYLE);
            }
            return this.defaultXSSFCellStyle;
        }
        style = this.adjustProperFontSize(style);
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)this.hssfCellStyleHash.get(style = this.dealBackgroundStyle(style));
        if (xSSFCellStyle == null) {
            xSSFCellStyle = (XSSFCellStyle)sXSSFWorkbook.createCellStyle();
            this.executeXSSFCellStyle(sXSSFWorkbook, xSSFCellStyle, style);
            this.hssfCellStyleHash.put(style, xSSFCellStyle);
            if (style.getHorizontalAlignment() == 4) {
                int n2 = style.getPaddingRight() <= 2 ? 0 : style.getPaddingRight() / 27;
                xSSFCellStyle.setIndention((short)n2);
            } else {
                int n3 = style.getPaddingLeft() <= 2 ? 0 : style.getPaddingLeft() / 27;
                xSSFCellStyle.setIndention((short)n3);
            }
        }
        return xSSFCellStyle;
    }

    private void executeXSSFCellStyle(SXSSFWorkbook sXSSFWorkbook, XSSFCellStyle xSSFCellStyle, Style style) {
        this.executeCellStyle(new XssfWorkbookWrapper((Workbook)sXSSFWorkbook), new XssfCellStyleWrapper((CellStyle)xSSFCellStyle), style);
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.TOP, new XSSFColor(style.getBorderTopColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.LEFT, new XSSFColor(style.getBorderLeftColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, new XSSFColor(style.getBorderBottomColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, new XSSFColor(style.getBorderRightColor()));
        Background background = style.getBackground();
        if (background != null) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                if (colorBackground.getColor() == null) {
                    colorBackground = ColorBackground.getInstance((Color)Color.WHITE);
                }
                xSSFCellStyle.setFillPattern((short)1);
                xSSFCellStyle.setFillForegroundColor(new XSSFColor(colorBackground.getColor()));
                xSSFCellStyle.setFillBackgroundColor(new XSSFColor(colorBackground.getColor()));
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                xSSFCellStyle.setFillPattern((short)16);
                xSSFCellStyle.setFillBackgroundColor(new XSSFColor(patternBackground.getBackground()));
                xSSFCellStyle.setFillForegroundColor(new XSSFColor(patternBackground.getForeground()));
            }
        }
    }

    @Override
    protected short getRotation(Style style) {
        int n2 = style.getRotation();
        if (n2 > 90 || n2 < -90) {
            n2 = 0;
        }
        if (n2 < 0) {
            n2 = 90 - n2;
        }
        return (short)n2;
    }

    @Override
    public POIFontAction createFont(POIWorkbookAction pOIWorkbookAction, java.awt.Font font) {
        return new XssfFontWrapper((Font)this.createFont((SXSSFWorkbook)pOIWorkbookAction.getWorkbook(), font));
    }

    @Override
    public void setColumnRowBreak(CellElement cellElement, POISheetAction pOISheetAction, int n2, int n3, int n4, int n5) {
        super.setColumnRowBreak(cellElement, pOISheetAction, n2, n3, n4, n5);
    }

    public XSSFFont createFont(SXSSFWorkbook sXSSFWorkbook, java.awt.Font font) {
        if (font == null) {
            return null;
        }
        XSSFFont xSSFFont = this.createSimpleXSSFFont(sXSSFWorkbook, new AbstractExcelExporter.JavaFontAdapter(font), font.getName());
        if (font instanceof FRFont) {
            FRFont fRFont = (FRFont)font;
            Color color = fRFont.getForeground();
            if (color != Color.BLACK) {
                xSSFFont.setColor(new XSSFColor(color));
            }
            this.createComplexFont4FR(fRFont, new XssfFontWrapper((Font)xSSFFont));
        }
        return xSSFFont;
    }

    private DataFormat getXSSFDataFormat(SXSSFWorkbook sXSSFWorkbook) {
        return this.format == null ? sXSSFWorkbook.createDataFormat() : this.format;
    }

    @Override
    protected short getFormat(POIWorkbookAction pOIWorkbookAction, String string) {
        return this.getXSSFDataFormat((SXSSFWorkbook)pOIWorkbookAction.getWorkbook()).getFormat(string);
    }

    @Override
    protected POIRichStringAction<XSSFRichTextString> initRichString(String string) {
        return new XssfRichStringWrapper(new XSSFRichTextString(string));
    }

    private XSSFFont createSimpleXSSFFont(SXSSFWorkbook sXSSFWorkbook, AbstractExcelExporter.FontAdapter fontAdapter, String string) {
        return (XSSFFont)this.createSimpleFont(new XssfWorkbookWrapper((Workbook)sXSSFWorkbook), fontAdapter, new XssfFontWrapper(), string).getFont();
    }

    public POIPictureLocation getFloatElementLocation(FloatElement floatElement, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, ElementCase elementCase, Object object) {
        return this.locateFloatElementInExcel(floatElement, dynamicUnitList, dynamicUnitList2, elementCase, object);
    }
}

