/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.form.main.Form;
import com.fr.form.ui.ElementCaseEditor;
import com.fr.form.ui.Widget;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharableElementCaseEditor
extends Widget {
    private String id;
    private ElementCaseEditor elementCaseEditor;
    private TableDataSource tableDataSource = new Form();
    private Map<String, Object> paraMap;

    public SharableElementCaseEditor() {
    }

    public SharableElementCaseEditor(String string, ElementCaseEditor elementCaseEditor, TableDataSource tableDataSource) {
        this(string, elementCaseEditor, tableDataSource, Collections.EMPTY_MAP);
    }

    public SharableElementCaseEditor(String string, ElementCaseEditor elementCaseEditor, TableDataSource tableDataSource, Map<String, Object> map) {
        this.id = string;
        this.elementCaseEditor = elementCaseEditor;
        this.tableDataSource = tableDataSource;
        this.paraMap = map;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public ElementCaseEditor getElementCaseEditor() {
        return this.elementCaseEditor;
    }

    public void setElementCaseEditor(ElementCaseEditor elementCaseEditor) {
        this.elementCaseEditor = elementCaseEditor;
    }

    public TableDataSource getTableDataSource() {
        return this.tableDataSource;
    }

    public void setTableDataSource(TableDataSource tableDataSource) {
        this.tableDataSource = tableDataSource;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("FormElementCaseFlag".equals(string)) {
                this.elementCaseEditor = new ElementCaseEditor();
                this.elementCaseEditor.setShared(true);
                xMLableReader.readXMLObject((XMLReadable)this.elementCaseEditor);
            } else if ("UUID".equals(string)) {
                this.id = xMLableReader.getElementValue();
            } else if (string.equals("TableDataMap")) {
                this.tableDataSource.readXML(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Iterator iterator;
        try {
            this.convertTableDataSource();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        if (this.elementCaseEditor != null) {
            xMLPrintWriter.startTAG("FormElementCaseFlag");
            this.elementCaseEditor.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("UUID").textNode(this.id).end();
        if (this.tableDataSource != null && (iterator = this.tableDataSource.getTableDataNameIterator()).hasNext()) {
            xMLPrintWriter.startTAG("TableDataMap");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                TableData tableData = this.tableDataSource.getTableData(string);
                DataCoreXmlUtils.writeXMLTableData((XMLPrintWriter)xMLPrintWriter, (TableData)tableData, (String)string);
            }
            xMLPrintWriter.end();
        }
    }

    private void convertTableDataSource() throws Exception {
        HashMap<Object, TableData> hashMap = new HashMap<Object, TableData>();
        Iterator iterator = this.tableDataSource.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableData object = this.tableDataSource.getTableData(string);
            hashMap.put(string, object);
        }
        this.elementCaseEditor.getElementCase().convertCellElementDictionary(hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            Calculator calculator = null;
            if (this.paraMap != null) {
                calculator = Calculator.createCalculator();
                calculator.pushNameSpace((NameSpace)ParameterMapNameSpace.create(this.paraMap));
            }
            this.tableDataSource.putTableData(entry.getKey().toString(), (TableData)EmbeddedTableData.embedify((TableData)((TableData)entry.getValue()), (Calculator)calculator));
        }
    }

    public String getXType() {
        return "sharableElementCase";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"click"};
    }

    public boolean batchRenameTdName(Map<String, String> map) {
        return this.elementCaseEditor == null ? true : this.elementCaseEditor.batchRenameTdName(map);
    }
}

