/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.io;

import com.fr.zip4j.core.HeaderWriter;
import com.fr.zip4j.crypto.AESEncrpyter;
import com.fr.zip4j.crypto.IEncrypter;
import com.fr.zip4j.crypto.StandardEncrypter;
import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.BaseOutputStream;
import com.fr.zip4j.io.SplitOutputStream;
import com.fr.zip4j.model.AESExtraDataRecord;
import com.fr.zip4j.model.CentralDirectory;
import com.fr.zip4j.model.EndCentralDirRecord;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.LocalFileHeader;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.model.ZipParameters;
import com.fr.zip4j.util.Raw;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class CipherOutputStream
extends BaseOutputStream {
    protected OutputStream outputStream;
    private File sourceFile;
    protected FileHeader fileHeader;
    protected LocalFileHeader localFileHeader;
    private IEncrypter encrypter;
    protected ZipParameters zipParameters;
    protected ZipModel zipModel;
    private long totalBytesWritten;
    protected CRC32 crc;
    private long bytesWrittenForThisFile;
    private byte[] pendingBuffer;
    private int pendingBufferLength;
    private long totalBytesRead;

    public CipherOutputStream(OutputStream outputStream, ZipModel zipModel) {
        this.outputStream = outputStream;
        this.initZipModel(zipModel);
        this.crc = new CRC32();
        this.totalBytesWritten = 0L;
        this.bytesWrittenForThisFile = 0L;
        this.pendingBuffer = new byte[16];
        this.pendingBufferLength = 0;
        this.totalBytesRead = 0L;
    }

    public void putNextEntry(File file, ZipParameters zipParameters) throws ZipException {
        if (!zipParameters.isSourceExternalStream() && file == null) {
            throw new ZipException("input file is null");
        }
        if (!zipParameters.isSourceExternalStream() && !Zip4jUtil.checkFileExists(file)) {
            throw new ZipException("input file does not exist");
        }
        try {
            Object object;
            this.sourceFile = file;
            this.zipParameters = (ZipParameters)zipParameters.clone();
            if (!zipParameters.isSourceExternalStream()) {
                if (this.sourceFile.isDirectory()) {
                    this.zipParameters.setEncryptFiles(false);
                    this.zipParameters.setEncryptionMethod(-1);
                    this.zipParameters.setCompressionMethod(0);
                }
            } else {
                if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.zipParameters.getFileNameInZip())) {
                    throw new ZipException("file name is empty for external stream");
                }
                if (this.zipParameters.getFileNameInZip().endsWith("/") || this.zipParameters.getFileNameInZip().endsWith("\\")) {
                    this.zipParameters.setEncryptFiles(false);
                    this.zipParameters.setEncryptionMethod(-1);
                    this.zipParameters.setCompressionMethod(0);
                }
            }
            this.createFileHeader();
            this.createLocalFileHeader();
            if (this.zipModel.isSplitArchive() && (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() == 0)) {
                object = new byte[4];
                Raw.writeIntLittleEndian((byte[])object, 0, 134695760);
                this.outputStream.write((byte[])object);
                this.totalBytesWritten += 4L;
            }
            if (this.outputStream instanceof SplitOutputStream) {
                if (this.totalBytesWritten == 4L) {
                    this.fileHeader.setOffsetLocalHeader(4L);
                } else {
                    this.fileHeader.setOffsetLocalHeader(((SplitOutputStream)this.outputStream).getFilePointer());
                }
            } else if (this.totalBytesWritten == 4L) {
                this.fileHeader.setOffsetLocalHeader(4L);
            } else {
                this.fileHeader.setOffsetLocalHeader(this.totalBytesWritten);
            }
            object = new HeaderWriter();
            this.totalBytesWritten += (long)((HeaderWriter)object).writeLocalFileHeader(this.zipModel, this.localFileHeader, this.outputStream);
            if (this.zipParameters.isEncryptFiles()) {
                this.initEncrypter();
                if (this.encrypter != null) {
                    if (zipParameters.getEncryptionMethod() == 0) {
                        byte[] byArray = ((StandardEncrypter)this.encrypter).getHeaderBytes();
                        this.outputStream.write(byArray);
                        this.totalBytesWritten += (long)byArray.length;
                        this.bytesWrittenForThisFile += (long)byArray.length;
                    } else if (zipParameters.getEncryptionMethod() == 99) {
                        byte[] byArray = ((AESEncrpyter)this.encrypter).getSaltBytes();
                        byte[] byArray2 = ((AESEncrpyter)this.encrypter).getDerivedPasswordVerifier();
                        this.outputStream.write(byArray);
                        this.outputStream.write(byArray2);
                        this.totalBytesWritten += (long)(byArray.length + byArray2.length);
                        this.bytesWrittenForThisFile += (long)(byArray.length + byArray2.length);
                    }
                }
            }
            this.crc.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ZipException(cloneNotSupportedException);
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void initEncrypter() throws ZipException {
        if (!this.zipParameters.isEncryptFiles()) {
            this.encrypter = null;
            return;
        }
        switch (this.zipParameters.getEncryptionMethod()) {
            case 0: {
                this.encrypter = new StandardEncrypter(this.zipParameters.getPassword(), (this.localFileHeader.getLastModFileTime() & 0xFFFF) << 16);
                break;
            }
            case 99: {
                this.encrypter = new AESEncrpyter(this.zipParameters.getPassword(), this.zipParameters.getAesKeyStrength());
                break;
            }
            default: {
                throw new ZipException("invalid encprytion method");
            }
        }
    }

    private void initZipModel(ZipModel zipModel) {
        this.zipModel = zipModel == null ? new ZipModel() : zipModel;
        if (this.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(new EndCentralDirRecord());
        }
        if (this.zipModel.getCentralDirectory() == null) {
            this.zipModel.setCentralDirectory(new CentralDirectory());
        }
        if (this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            this.zipModel.getCentralDirectory().setFileHeaders(new ArrayList());
        }
        if (this.zipModel.getLocalFileHeaderList() == null) {
            this.zipModel.setLocalFileHeaderList(new ArrayList());
        }
        if (this.outputStream instanceof SplitOutputStream && ((SplitOutputStream)this.outputStream).isSplitZipFile()) {
            this.zipModel.setSplitArchive(true);
            this.zipModel.setSplitLength(((SplitOutputStream)this.outputStream).getSplitLength());
        }
        this.zipModel.getEndCentralDirRecord().setSignature(101010256L);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length == 0) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 99) {
            if (this.pendingBufferLength != 0) {
                if (n2 >= 16 - this.pendingBufferLength) {
                    System.arraycopy(byArray, n, this.pendingBuffer, this.pendingBufferLength, 16 - this.pendingBufferLength);
                    this.encryptAndWrite(this.pendingBuffer, 0, this.pendingBuffer.length);
                    n = 16 - this.pendingBufferLength;
                    n2 -= n;
                    this.pendingBufferLength = 0;
                } else {
                    System.arraycopy(byArray, n, this.pendingBuffer, this.pendingBufferLength, n2);
                    this.pendingBufferLength += n2;
                    return;
                }
            }
            if (n2 != 0 && n2 % 16 != 0) {
                System.arraycopy(byArray, n2 + n - n2 % 16, this.pendingBuffer, 0, n2 % 16);
                this.pendingBufferLength = n2 % 16;
                n2 -= this.pendingBufferLength;
            }
        }
        if (n2 != 0) {
            this.encryptAndWrite(byArray, n, n2);
        }
    }

    private void encryptAndWrite(byte[] byArray, int n, int n2) throws IOException {
        if (this.encrypter != null) {
            try {
                this.encrypter.encryptData(byArray, n, n2);
            }
            catch (ZipException zipException) {
                throw new IOException(zipException.getMessage());
            }
        }
        this.outputStream.write(byArray, n, n2);
        this.totalBytesWritten += (long)n2;
        this.bytesWrittenForThisFile += (long)n2;
    }

    public void closeEntry() throws IOException, ZipException {
        if (this.pendingBufferLength != 0) {
            this.encryptAndWrite(this.pendingBuffer, 0, this.pendingBufferLength);
            this.pendingBufferLength = 0;
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 99) {
            if (this.encrypter instanceof AESEncrpyter) {
                this.outputStream.write(((AESEncrpyter)this.encrypter).getFinalMac());
                this.bytesWrittenForThisFile += 10L;
                this.totalBytesWritten += 10L;
            } else {
                throw new ZipException("invalid encrypter for AES encrypted file");
            }
        }
        this.fileHeader.setCompressedSize(this.bytesWrittenForThisFile);
        this.localFileHeader.setCompressedSize(this.bytesWrittenForThisFile);
        if (this.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setUncompressedSize(this.totalBytesRead);
            if (this.localFileHeader.getUncompressedSize() != this.totalBytesRead) {
                this.localFileHeader.setUncompressedSize(this.totalBytesRead);
            }
        }
        long l = this.crc.getValue();
        if (this.fileHeader.isEncrypted() && this.fileHeader.getEncryptionMethod() == 99) {
            l = 0L;
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 99) {
            this.fileHeader.setCrc32(0L);
            this.localFileHeader.setCrc32(0L);
        } else {
            this.fileHeader.setCrc32(l);
            this.localFileHeader.setCrc32(l);
        }
        this.zipModel.getLocalFileHeaderList().add(this.localFileHeader);
        this.zipModel.getCentralDirectory().getFileHeaders().add(this.fileHeader);
        HeaderWriter headerWriter = new HeaderWriter();
        this.totalBytesWritten += (long)headerWriter.writeExtendedLocalHeader(this.localFileHeader, this.outputStream);
        this.crc.reset();
        this.bytesWrittenForThisFile = 0L;
        this.encrypter = null;
        this.totalBytesRead = 0L;
    }

    public void finish() throws IOException, ZipException {
        this.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(this.totalBytesWritten);
        HeaderWriter headerWriter = new HeaderWriter();
        headerWriter.finalizeZipFile(this.zipModel, this.outputStream);
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    private void createFileHeader() throws ZipException {
        boolean bl;
        this.fileHeader = new FileHeader();
        this.fileHeader.setSignature(33639248);
        this.fileHeader.setVersionMadeBy(20);
        this.fileHeader.setVersionNeededToExtract(20);
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 99) {
            this.fileHeader.setCompressionMethod(99);
            this.fileHeader.setAesExtraDataRecord(this.generateAESExtraDataRecord(this.zipParameters));
        } else {
            this.fileHeader.setCompressionMethod(this.zipParameters.getCompressionMethod());
        }
        if (this.zipParameters.isEncryptFiles()) {
            this.fileHeader.setEncrypted(true);
            this.fileHeader.setEncryptionMethod(this.zipParameters.getEncryptionMethod());
        }
        String string = null;
        if (this.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(System.currentTimeMillis()));
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.zipParameters.getFileNameInZip())) {
                throw new ZipException("fileNameInZip is null or empty");
            }
            string = this.zipParameters.getFileNameInZip();
        } else {
            this.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(Zip4jUtil.getLastModifiedFileTime(this.sourceFile, this.zipParameters.getTimeZone())));
            this.fileHeader.setUncompressedSize(this.sourceFile.length());
            string = Zip4jUtil.getRelativeFileName(this.sourceFile.getAbsolutePath(), this.zipParameters.getRootFolderInZip(), this.zipParameters.getDefaultFolderPath());
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("fileName is null or empty. unable to create file header");
        }
        this.fileHeader.setFileName(string);
        if (Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getFileNameCharset())) {
            this.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(string, this.zipModel.getFileNameCharset()));
        } else {
            this.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(string));
        }
        if (this.outputStream instanceof SplitOutputStream) {
            this.fileHeader.setDiskNumberStart(((SplitOutputStream)this.outputStream).getCurrSplitFileCounter());
        } else {
            this.fileHeader.setDiskNumberStart(0);
        }
        int n = 0;
        if (!this.zipParameters.isSourceExternalStream()) {
            n = this.getFileAttributes(this.sourceFile);
        }
        byte[] byArray = new byte[]{(byte)n, 0, 0, 0};
        this.fileHeader.setExternalFileAttr(byArray);
        if (this.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setDirectory(string.endsWith("/") || string.endsWith("\\"));
        } else {
            this.fileHeader.setDirectory(this.sourceFile.isDirectory());
        }
        if (this.fileHeader.isDirectory()) {
            this.fileHeader.setCompressedSize(0L);
            this.fileHeader.setUncompressedSize(0L);
        } else if (!this.zipParameters.isSourceExternalStream()) {
            long l = Zip4jUtil.getFileLengh(this.sourceFile);
            if (this.zipParameters.getCompressionMethod() == 0) {
                if (this.zipParameters.getEncryptionMethod() == 0) {
                    this.fileHeader.setCompressedSize(l + 12L);
                } else if (this.zipParameters.getEncryptionMethod() == 99) {
                    int n2 = 0;
                    switch (this.zipParameters.getAesKeyStrength()) {
                        case 1: {
                            n2 = 8;
                            break;
                        }
                        case 3: {
                            n2 = 16;
                            break;
                        }
                        default: {
                            throw new ZipException("invalid aes key strength, cannot determine key sizes");
                        }
                    }
                    this.fileHeader.setCompressedSize(l + (long)n2 + 10L + 2L);
                } else {
                    this.fileHeader.setCompressedSize(0L);
                }
            } else {
                this.fileHeader.setCompressedSize(0L);
            }
            this.fileHeader.setUncompressedSize(l);
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 0) {
            this.fileHeader.setCrc32(this.zipParameters.getSourceFileCRC());
        }
        byte[] byArray2 = new byte[]{Raw.bitArrayToByte(this.generateGeneralPurposeBitArray(this.fileHeader.isEncrypted(), this.zipParameters.getCompressionMethod())), (bl = Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getFileNameCharset())) && this.zipModel.getFileNameCharset().equalsIgnoreCase("UTF8") || !bl && Zip4jUtil.detectCharSet(this.fileHeader.getFileName()).equals("UTF8") ? (byte)8 : 0};
        this.fileHeader.setGeneralPurposeFlag(byArray2);
    }

    private void createLocalFileHeader() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot create local file header");
        }
        this.localFileHeader = new LocalFileHeader();
        this.localFileHeader.setSignature(67324752);
        this.localFileHeader.setVersionNeededToExtract(this.fileHeader.getVersionNeededToExtract());
        this.localFileHeader.setCompressionMethod(this.fileHeader.getCompressionMethod());
        this.localFileHeader.setLastModFileTime(this.fileHeader.getLastModFileTime());
        this.localFileHeader.setUncompressedSize(this.fileHeader.getUncompressedSize());
        this.localFileHeader.setFileNameLength(this.fileHeader.getFileNameLength());
        this.localFileHeader.setFileName(this.fileHeader.getFileName());
        this.localFileHeader.setEncrypted(this.fileHeader.isEncrypted());
        this.localFileHeader.setEncryptionMethod(this.fileHeader.getEncryptionMethod());
        this.localFileHeader.setAesExtraDataRecord(this.fileHeader.getAesExtraDataRecord());
        this.localFileHeader.setCrc32(this.fileHeader.getCrc32());
        this.localFileHeader.setCompressedSize(this.fileHeader.getCompressedSize());
        this.localFileHeader.setGeneralPurposeFlag((byte[])this.fileHeader.getGeneralPurposeFlag().clone());
    }

    private int getFileAttributes(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file attributes");
        }
        if (!file.exists()) {
            return 0;
        }
        if (file.isDirectory()) {
            if (file.isHidden()) {
                return 18;
            }
            return 16;
        }
        if (!file.canWrite() && file.isHidden()) {
            return 3;
        }
        if (!file.canWrite()) {
            return 1;
        }
        if (file.isHidden()) {
            return 2;
        }
        return 0;
    }

    private int[] generateGeneralPurposeBitArray(boolean bl, int n) {
        int[] nArray = new int[8];
        nArray[0] = bl ? 1 : 0;
        if (n != 8) {
            nArray[1] = 0;
            nArray[2] = 0;
        }
        nArray[3] = 1;
        return nArray;
    }

    private AESExtraDataRecord generateAESExtraDataRecord(ZipParameters zipParameters) throws ZipException {
        if (zipParameters == null) {
            throw new ZipException("zip parameters are null, cannot generate AES Extra Data record");
        }
        AESExtraDataRecord aESExtraDataRecord = new AESExtraDataRecord();
        aESExtraDataRecord.setSignature(39169L);
        aESExtraDataRecord.setDataSize(7);
        aESExtraDataRecord.setVendorID("AE");
        aESExtraDataRecord.setVersionNumber(2);
        if (zipParameters.getAesKeyStrength() == 1) {
            aESExtraDataRecord.setAesStrength(1);
        } else if (zipParameters.getAesKeyStrength() == 3) {
            aESExtraDataRecord.setAesStrength(3);
        } else {
            throw new ZipException("invalid AES key strength, cannot generate AES Extra data record");
        }
        aESExtraDataRecord.setCompressionMethod(zipParameters.getCompressionMethod());
        return aESExtraDataRecord;
    }

    public void decrementCompressedFileSize(int n) {
        if (n <= 0) {
            return;
        }
        if ((long)n <= this.bytesWrittenForThisFile) {
            this.bytesWrittenForThisFile -= (long)n;
        }
    }

    protected void updateTotalBytesRead(int n) {
        if (n > 0) {
            this.totalBytesRead += (long)n;
        }
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

