/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogLevel;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.write.config.CallBackRecord;
import com.fr.write.config.CallBackRecordFactory;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateConfig
extends DMLConfig {
    protected Map pstmtMap = new HashMap();
    private List columnConfigListWithoutKey = null;
    private CallBackRecord callBackRecord = CallBackRecordFactory.createCallBackRecord("update", this);

    public int dmlSubmit(Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        if (!this.isSkipUpdate(calculator)) {
            return 1;
        }
        int n = this.simpleSubmit(connection, calculator, objectArray);
        if (map != null && n > 0) {
            Map map2 = this.callBackRecord.getRecord(connection, objectArray);
            map.putAll(map2);
        }
        return n;
    }

    protected int dmlSubmitBatch(int n, Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        return this.dmlSubmit(connection, calculator, objectArray, map);
    }

    public boolean isIgnoreUpdate(Calculator calculator) {
        return this.isUpdateSelected() && this.isAllNoChangedValue(calculator);
    }

    private boolean isSkipUpdate(Calculator calculator) {
        return !this.isUpdateSelected() || !this.isAllNoChangedValue(calculator);
    }

    private boolean isAllNoChangedValue(Calculator calculator) {
        if (calculator == null) {
            return false;
        }
        List list = this.columnConfigList;
        for (int i = 0; i < list.size(); ++i) {
            ColumnConfig columnConfig = (ColumnConfig)list.get(i);
            if (!columnConfig.isModified(calculator)) continue;
            return false;
        }
        return true;
    }

    public int simpleSubmit(Connection connection, Object[] objectArray) throws SQLException {
        return this.simpleSubmit(connection, null, objectArray);
    }

    public int simpleSubmit(Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        Where where = this.generateWhere(connection, objectArray);
        if (where == null || this.table == null) {
            return -1;
        }
        int n = this.getColumnConfigListWithoutKey().size();
        if (n == 0) {
            return -1;
        }
        return this.update(connection, calculator, objectArray, where);
    }

    private static boolean validate(Update update) {
        return update != null && update.getColumnCount() > 0;
    }

    private int update(Connection connection, Calculator calculator, Object[] objectArray, Where where) throws SQLException {
        String string = where == null ? "" : where.toStatementSQLString(this.getDialect(connection));
        PreparedStatement preparedStatement = this.getPreparedStatement(connection, calculator, string);
        this.fillUpdatePreparedStatement(preparedStatement, connection, where, objectArray);
        return preparedStatement.executeUpdate();
    }

    private PreparedStatement createPreparedStatement(Connection connection, Calculator calculator, String string) throws SQLException {
        int n = this.getColumnConfigCount();
        Dialect dialect = this.getDialect(connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            if (this.getColumnConfig(i).isKey()) continue;
            arrayList.add(dialect.column2SQL(this.getColumnName(i)) + "=?");
        }
        String string2 = this.getTable(calculator).toStatementSQLString(dialect);
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ');
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ');
        string3 = stringBuffer.toString();
        String string4 = "UPDATE " + string2 + " SET" + string3 + string;
        if (FRLogger.getLogger().isLoggable(FRLogLevel.DEBUG)) {
            FRLogger.getLogger().info(string4);
        }
        return connection.prepareStatement(string4.toString());
    }

    private void fillUpdatePreparedStatement(PreparedStatement preparedStatement, Connection connection, Where where, Object[] objectArray) throws SQLException {
        Dialect dialect = this.getDialect(connection);
        int n = 0;
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (columnConfig.isKey()) continue;
            DBUtils.applyColumnTypeValue(dialect, connection, this.getTable(), columnConfig.getColumnName(), columnConfig.getColumnValue(), preparedStatement, n + 1, this.getColumnType(columnConfig.getColumnName(), connection), objectArray[i]);
            ++n;
        }
        if (where != null) {
            where.applyColumnTypeValue(dialect, connection, this.getTable(), preparedStatement, n + 1);
        }
    }

    public String toString() {
        return "update " + this.table.toString() + " " + super.toString();
    }

    private PreparedStatement getPreparedStatement(Connection connection, Calculator calculator, String string) throws SQLException {
        StatementCacheKey statementCacheKey = new StatementCacheKey(connection, string);
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(statementCacheKey);
        if (preparedStatement == null) {
            preparedStatement = this.createPreparedStatement(connection, calculator, string);
            this.pstmtMap.put(statementCacheKey, preparedStatement);
        }
        return preparedStatement;
    }

    protected void closeStatement(Connection connection) throws SQLException {
        Set set = this.pstmtMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            StatementCacheKey statementCacheKey = (StatementCacheKey)iterator.next();
            if (statementCacheKey.conn != connection) continue;
            Statement statement = (Statement)this.pstmtMap.get(statementCacheKey);
            DBUtils.closeStatement(statement);
            iterator.remove();
        }
    }

    public List getColumnConfigListWithoutKey() {
        if (this.columnConfigListWithoutKey == null) {
            this.columnConfigListWithoutKey = new ArrayList();
            for (int i = 0; i < this.columnConfigList.size(); ++i) {
                ColumnConfig columnConfig = this.getColumnConfig(i);
                if (columnConfig.isKey()) continue;
                this.columnConfigListWithoutKey.add(columnConfig);
            }
        }
        return this.columnConfigListWithoutKey;
    }

    private class StatementCacheKey {
        private Connection conn;
        private String whereString;

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + this.getOuterType().hashCode();
            n2 = 31 * n2 + (this.conn == null ? 0 : this.conn.hashCode());
            n2 = 31 * n2 + (this.whereString == null ? 0 : this.whereString.hashCode());
            return n2;
        }

        public StatementCacheKey(Connection connection, String string) {
            this.conn = connection;
            this.whereString = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StatementCacheKey statementCacheKey = (StatementCacheKey)object;
            if (!ComparatorUtils.equals(this.getOuterType(), statementCacheKey.getOuterType())) {
                return false;
            }
            if (this.conn == null ? statementCacheKey.conn != null : !ComparatorUtils.equals(this.conn, statementCacheKey.conn)) {
                return false;
            }
            return !(this.whereString == null ? statementCacheKey.whereString != null : !ComparatorUtils.equals(this.whereString, statementCacheKey.whereString));
        }

        public Connection getConn() {
            return this.conn;
        }

        public void setConn(Connection connection) {
            this.conn = connection;
        }

        public String getWhereString() {
            return this.whereString;
        }

        public void setWhereString(String string) {
            this.whereString = string;
        }

        private UpdateConfig getOuterType() {
            return UpdateConfig.this;
        }
    }
}

