/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write;

import com.fr.data.DBFeedback;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.script.Calculator;
import com.fr.script.CharSetNameSpace;
import com.fr.stable.StringUtils;
import com.fr.write.DBManipulation;
import com.fr.write.WriteException;
import java.sql.Connection;
import java.sql.SQLException;

public class DBCommitWrapper {
    private DBFeedback feedback;

    public static void commit2db(Calculator calculator, DBManipulation dBManipulation) throws WriteException {
        new DBCommitWrapper().commit(calculator, false, dBManipulation);
    }

    public static void commit2db(Calculator calculator, DBManipulation dBManipulation, Connection connection) throws WriteException {
        new DBCommitWrapper().commit(calculator, false, dBManipulation, connection);
    }

    public static DBFeedback commit2dbAndFeedback(Calculator calculator, DBManipulation dBManipulation) throws WriteException {
        DBCommitWrapper dBCommitWrapper = new DBCommitWrapper();
        dBCommitWrapper.commit(calculator, true, dBManipulation);
        return dBCommitWrapper.feedback;
    }

    public static DBFeedback commit2dbAndFeedback(Calculator calculator, DBManipulation dBManipulation, Connection connection) throws WriteException {
        DBCommitWrapper dBCommitWrapper = new DBCommitWrapper();
        dBCommitWrapper.commit(calculator, true, dBManipulation, connection);
        return dBCommitWrapper.feedback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commit(Calculator calculator, boolean bl, DBManipulation dBManipulation) throws WriteException {
        if (dBManipulation == null) return;
        if (dBManipulation.getDmlConfig() == null) return;
        String string = dBManipulation.getDBName(calculator);
        NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
        Connection connection = null;
        try {
            block4: {
                try {
                    connection = nameDatabaseConnection.createConnection();
                    calculator.putConnection(string, connection);
                    this.commit(calculator, bl, dBManipulation, connection);
                    if (connection.getAutoCommit()) break block4;
                    connection.commit();
                }
                catch (Exception exception) {
                    throw new WriteException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + string + "\n" + exception.getMessage(), exception);
                }
            }
            Object var9_7 = null;
            DBUtils.closeConnection(connection);
            calculator.removeConnection(string);
            return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            DBUtils.closeConnection(connection);
            calculator.removeConnection(string);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commit(Calculator calculator, boolean bl, DBManipulation dBManipulation, Connection connection) throws WriteException {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        CharSetNameSpace charSetNameSpace = this.transformChartset(dBManipulation, calculator);
        try {
            try {
                if (bl) {
                    this.feedback = dBManipulation.getDmlConfig().executeAndFeedback(connection, calculator);
                } else {
                    dBManipulation.getDmlConfig().execute(connection, calculator);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                DBUtils.rollback(connection);
                throw new WriteException(exception.getMessage(), exception);
            }
            Object var8_7 = null;
            if (charSetNameSpace == null) return;
            calculator.removeNameSpace(charSetNameSpace);
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (charSetNameSpace == null) throw throwable;
            calculator.removeNameSpace(charSetNameSpace);
            throw throwable;
        }
    }

    private CharSetNameSpace transformChartset(DBManipulation dBManipulation, Calculator calculator) {
        String string = dBManipulation.getDBName(calculator);
        NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
        boolean bl = StringUtils.isNotBlank(nameDatabaseConnection.getNewCharsetName()) && StringUtils.isNotBlank(nameDatabaseConnection.getOriginalCharsetName()) && !ComparatorUtils.equals(nameDatabaseConnection.getNewCharsetName(), nameDatabaseConnection.getOriginalCharsetName());
        CharSetNameSpace charSetNameSpace = null;
        if (bl) {
            charSetNameSpace = new CharSetNameSpace(nameDatabaseConnection.getNewCharsetName(), nameDatabaseConnection.getOriginalCharsetName());
            calculator.pushNameSpace(charSetNameSpace);
        }
        return charSetNameSpace;
    }
}

