/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected ServletOutputStream output = null;

    public GZIPResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this.output = httpServletResponse.getOutputStream();
        this.gzipstream = new GZIPOutputStream((OutputStream)this.output);
    }

    public void close() throws IOException {
        this.gzipstream.finish();
        this.output.flush();
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.gzipstream.flush();
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.closed;
    }
}

