/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.cluster.stable.ClusterState;
import com.fr.dav.LocalEnv;
import com.fr.file.BaseClusterHelper;
import com.fr.general.IOUtils;
import com.fr.plugin.PluginConfigManager;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.file.RemoteXMLFileManagerProvider;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.web.utils.WebUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.ServletContext;

public class ServerEnv
extends LocalEnv {
    private ServletContext servletContext = null;
    private boolean packDeploy = false;
    private static final String WAR_PATH_XML = "warpath.xml";

    public ServerEnv(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.setPath();
        this.transferPlugins();
    }

    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        InputStream inputStream = this.servletContext.getResourceAsStream(StableUtils.pathJoin("/", "WEB-INF", "reportlets", string));
        return inputStream != null;
    }

    public InputStream readBean(String string, String string2) throws Exception {
        if (this.validTempFile(string2)) {
            return this.readResource(string, string2);
        }
        InputStream inputStream = this.readFromWar(string, string2);
        if (inputStream == null) {
            inputStream = this.readFromWar(string.toLowerCase(), string2);
        }
        if (inputStream == null) {
            inputStream = this.readResource(string, string2);
        }
        return inputStream;
    }

    private boolean validTempFile(String string) {
        return this.isPackDeploy() && StringUtils.isNotEmpty(string) && string.endsWith(".xml") && string.indexOf("resources") != -1;
    }

    private InputStream readFromWar(String string, String string2) {
        return this.servletContext.getResourceAsStream(StableUtils.pathJoin("/", "WEB-INF", string2, string));
    }

    public InputStream readResource(String string) throws Exception {
        return this.readResource(string, "resources");
    }

    public InputStream readResource(String string, String string2) throws Exception {
        if (!this.isPackDeploy()) {
            return super.readBean(string, string2);
        }
        return new FileInputStream(this.makeSureXMLExist(string, string2));
    }

    private File makeSureXMLExist(String string, String string2) {
        String string3 = StableUtils.pathJoin(this.getPath(), string2);
        String string4 = StableUtils.pathJoin(string3, string);
        try {
            File file = new File(string4);
            if (!file.exists()) {
                InputStream inputStream = this.readFromWar(string, string2);
                IOUtils.copy(inputStream, string, new File(string3));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return new File(string4);
    }

    public OutputStream writeBean(String string, String string2) throws Exception {
        if (!this.isPackDeploy()) {
            return super.writeBean(string, string2);
        }
        return new FileOutputStream(this.makeSureXMLExist(string, string2));
    }

    public boolean writeResource(XMLFileManagerProvider xMLFileManagerProvider) throws Exception {
        if (BaseClusterHelper.getClusterState() != ClusterState.MEMBER) {
            return super.writeResource(xMLFileManagerProvider);
        }
        return ((RemoteXMLFileManagerProvider)xMLFileManagerProvider).writeResource();
    }

    public void copyFileToInstallLibFolder(File file, String string, String string2) throws Exception {
    }

    public boolean isPackDeploy() {
        return this.packDeploy;
    }

    public String getAppName() {
        return this.isPackDeploy() ? ProductConstants.WEB_APP_NAME : super.getAppName();
    }

    private void setPath() {
        this.path = WebUtils.getWebINFPath(this.servletContext);
        if (StringUtils.isNotEmpty(this.path)) {
            return;
        }
        this.packDeploy = true;
        String string = "WebReport";
        try {
            InputStream inputStream = this.readFromWar(WAR_PATH_XML, "resources");
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        this.path = StableUtils.pathJoin(ProductConstants.getEnvHome(), string);
    }

    private void transferPlugins() {
        if (this.isPackDeploy()) {
            try {
                StableUtils.deleteFile(new File(StableUtils.pathJoin(this.getPath(), "plugins")));
                InputStream inputStream = this.readFromWar("pluginconfig.xml", "plugins");
                if (inputStream != null) {
                    String[] stringArray;
                    for (String string : stringArray = PluginConfigManager.getProviderInstance(inputStream).getInstalledPluginWrapper()) {
                        this.makeSureXMLExist("plugin.xml", StableUtils.pathJoin("plugins", string));
                    }
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public void setWebXMLConfigManager(XMLFileManagerProvider xMLFileManagerProvider) throws IOException {
        if (this.isPackDeploy()) {
            return;
        }
        super.setWebXMLConfigManager(xMLFileManagerProvider);
    }
}

