/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.array.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool<T> {
    public final int max;
    public int peak;
    private final Array<T> freeObjects;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public Pool(int n, int n2) {
        this.freeObjects = new Array(false, n);
        this.max = n2;
    }

    protected abstract T newObject();

    public T obtain() {
        return this.freeObjects.size == 0 ? this.newObject() : this.freeObjects.pop();
    }

    public void free(T t) {
        if (t == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (this.freeObjects.size < this.max) {
            this.freeObjects.add(t);
            this.peak = Math.max(this.peak, this.freeObjects.size);
        }
        this.reset(t);
    }

    protected void reset(T t) {
        if (t instanceof Poolable) {
            ((Poolable)t).reset();
        }
    }

    public void freeAll(Array<T> array) {
        if (array == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        Array<T> array2 = this.freeObjects;
        int n = this.max;
        for (int i = 0; i < array.size; ++i) {
            T t = array.get(i);
            if (t == null) continue;
            if (array2.size < n) {
                array2.add(t);
            }
            this.reset(t);
        }
        this.peak = Math.max(this.peak, array2.size);
    }

    public void clear() {
        this.freeObjects.clear();
    }

    public int getFree() {
        return this.freeObjects.size;
    }

    public static interface Poolable {
        public void reset();
    }
}

