/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.AbstractJavaScript;
import com.fr.js.Callback;
import com.fr.js.JavaScript;
import com.fr.js.JavaScriptImpl;
import com.fr.js.JavaScriptXMLUtils;
import com.fr.json.JSONObject;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FormSubmitJavaScript
extends AbstractJavaScript
implements Callback {
    private String action = "";
    private boolean asynchronous = true;
    private JavaScript callBack;

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setCallBack(JavaScript javaScript) {
        this.callBack = javaScript;
    }

    public JavaScript getCallBack() {
        return this.callBack;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean bl) {
        this.asynchronous = bl;
    }

    public String actionJS(Repository repository) {
        ParameterProvider[] parameterProviderArray = this.getParameters();
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < parameterProviderArray.length; ++i) {
            try {
                jSONObject.put(parameterProviderArray[i].getName(), parameterProviderArray[i].getValue());
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        this.paraMap.putAll(jSONObject.toMap());
        if (!this.paraMap.isEmpty() && this.callBack != null) {
            this.callBack.addParameterMap(this.paraMap);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("var config={");
        try {
            stringBuffer.append("url:\"").append(TemplateUtils.render(this.action)).append("\",");
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        stringBuffer.append("asyn:").append(this.asynchronous).append(",");
        stringBuffer.append("data:").append(jSONObject.toString()).append(",");
        stringBuffer.append("callback: function(){").append(this.callBack != null ? this.callBack.createJS(repository) : "").append("}");
        stringBuffer.append("};");
        stringBuffer.append("this.options.form.formSubmit(config);");
        return stringBuffer.toString();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Action")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setAction(string2);
                }
            } else if (string.equals("Asyn")) {
                if (xMLableReader.getElementValue() != null) {
                    this.setAsynchronous(false);
                }
            } else if (string.equals("CallBack")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setCallBack(new JavaScriptImpl(string3));
                }
            } else if ("JavaScript".equals(string)) {
                this.setCallBack(JavaScriptXMLUtils.readJavaScript(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.action)) {
            xMLPrintWriter.startTAG("Action").textNode(this.action).end();
        }
        if (!this.asynchronous) {
            xMLPrintWriter.startTAG("Asyn").textNode(String.valueOf(this.asynchronous)).end();
        }
        if (this.getCallBack() != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.getCallBack(), "JavaScript");
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof FormSubmitJavaScript && ComparatorUtils.equals(((FormSubmitJavaScript)object).action, this.action) && ((FormSubmitJavaScript)object).asynchronous == this.asynchronous && ComparatorUtils.equals(((FormSubmitJavaScript)object).getCallBack(), this.callBack);
    }

    public Object clone() throws CloneNotSupportedException {
        FormSubmitJavaScript formSubmitJavaScript = (FormSubmitJavaScript)super.clone();
        if (this.callBack != null) {
            formSubmitJavaScript.callBack = (JavaScript)this.callBack.clone();
        }
        return formSubmitJavaScript;
    }
}

