/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.http.HttpClient;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ProductConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.SiteTransformer;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SiteCenter {
    private static int TIME_OUT = 5000;
    private static final String[] SITE_SOURCE = new String[]{"http://support.finereport.com/site", "http://support.finereport.com:54321/site"};
    private static SiteCenter ourInstance;
    private Map<String, String> map = new HashMap<String, String>();
    private boolean loadSuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteCenter getInstance() {
        if (ourInstance != null) {
            return ourInstance;
        }
        Class<SiteCenter> clazz = SiteCenter.class;
        synchronized (SiteCenter.class) {
            if (ourInstance == null) {
                ourInstance = new SiteCenter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    private SiteCenter() {
        this.prepare();
    }

    private void prepare() {
        if (this.loadSuccess) {
            return;
        }
        new Thread(){

            public void run() {
                SiteCenter.this.loadConfig();
            }
        }.start();
    }

    private void loadConfig() {
        for (String string : SITE_SOURCE) {
            try {
                InputStream inputStream;
                String string2;
                HttpClient httpClient = new HttpClient(string + "?build=" + GeneralUtils.readBuildNO() + ProductConstants.BRANCH.toHttpQuery());
                httpClient.setTimeout(TIME_OUT);
                httpClient.asGet();
                if (!httpClient.isServerAlive() || !StringUtils.isNotBlank(string2 = IOUtils.inputStream2String(inputStream = httpClient.getResponseStream(), "UTF-8"))) continue;
                JSONObject jSONObject = new JSONObject(string2);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    this.map.put(string3, jSONObject.optString(string3));
                }
                this.loadSuccess = true;
                break;
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error("Cannot connect to site server:" + string);
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error("Cannot connect to site server:" + string);
            }
        }
    }

    public String acquireUrlByKind(String string, String string2) {
        String string3 = this.acquireUrlByKind(string);
        if (StringUtils.isEmpty(string3)) {
            return string2;
        }
        return string3;
    }

    public String acquireUrlByKind(String string) {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getExtraClassManager();
        if (extraClassManagerProvider != null) {
            Set set = extraClassManagerProvider.getArray("SiteTransformer");
            for (SiteTransformer siteTransformer : set) {
                if (!siteTransformer.match(string)) continue;
                return siteTransformer.transform(string);
            }
        }
        if (!this.loadSuccess) {
            new Thread(){

                public void run() {
                    SiteCenter.this.loadConfig();
                }
            }.start();
        }
        return this.map.get(string);
    }
}

