/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.cache.Attachment;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.DesUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.general.process.ExecuteResult;
import com.fr.general.process.LocalCommandExecutorServiceImpl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Expression;
import com.fr.stable.xml.XMLWriter;
import com.fr.third.antlr.ANTLRException;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class GeneralUtils {
    private static final int TAIL_LENGTH = 9;
    public static final String EMAIL_SUBJECT = "SUBJECT";
    public static int ascCodeA = 65;
    public static int ascCodeZ = 90;
    public static int ascCodea = 97;
    public static int ascCodez = 122;
    public static int ascCode0 = 48;
    public static int ascCode9 = 57;
    public static int ascCodef = 102;
    public static int ascCodeW = 87;
    private static short macMax = (short)255;
    private static int hexStep = 4;
    private static int macPara = 5;
    private static final int CMD_TIME_OUT = 5000;
    private static String[] macAddress;

    private GeneralUtils() {
    }

    public static String objectToString(Object object) {
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return StableUtils.convertNumberStringToString((Number)object, false);
        }
        if (object instanceof Date) {
            DefaultValues defaultValues = GeneralContext.getDefaultValues();
            if (object instanceof Time) {
                return defaultValues.getTimeFormat().format(object);
            }
            String string = defaultValues.getDateTimeFormat().format(object);
            if (string.endsWith("00:00:00")) {
                return string.substring(0, string.length() - 9);
            }
            return string;
        }
        if (object instanceof Image || object instanceof Attachment) {
            return "";
        }
        return object.toString();
    }

    public static Number objectToNumber(Object object) {
        return GeneralUtils.objectToNumber(object, false);
    }

    public static Number objectToNumberReturnNull(Object object) {
        return GeneralUtils.objectToNumber(object, true);
    }

    public static Number objectToNumber(Object object, boolean bl) {
        Number number;
        if (object == null) {
            return bl ? null : Integer.valueOf(0);
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        String string = GeneralUtils.objectToString(object);
        if (string != null) {
            string = string.trim();
        }
        if ((number = GeneralUtils.string2Number(string)) == null && !bl) {
            number = 0;
        }
        return number;
    }

    public static Number string2Number(String string) {
        return StableUtils.string2Number(string);
    }

    public static Map jsonString2Map(String string) throws JSONException {
        if (StringUtils.isNotBlank(string)) {
            return GeneralUtils.json2Map(new JSONObject(string));
        }
        return new HashMap();
    }

    public static Map json2Map(JSONObject jSONObject) throws JSONException {
        HashMap hashMap = new HashMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            XMLWriter xMLWriter;
            Serializable serializable;
            Object e = iterator.next();
            FArray<Object> fArray = jSONObject.get(e.toString());
            if (fArray instanceof JSONArray) {
                serializable = (JSONArray)((Object)fArray);
                xMLWriter = new FArray<Object>();
                for (int i = 0; i < ((JSONArray)serializable).length(); ++i) {
                    ((FArray)xMLWriter).add(((JSONArray)serializable).get(i));
                }
                fArray = xMLWriter;
            } else if (fArray instanceof JSONObject && ((JSONObject)(serializable = (JSONObject)((Object)fArray))).opt("type") != null && ((JSONObject)serializable).opt("value") != null) {
                if (ComparatorUtils.equals(((JSONObject)serializable).get("type"), (Object)"date")) {
                    fArray = DateUtils.string2Date(((JSONObject)serializable).get("value").toString(), false);
                } else if (ComparatorUtils.equals(((JSONObject)serializable).get("type"), (Object)"formula")) {
                    xMLWriter = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                    xMLWriter.setContent(((JSONObject)serializable).get("value").toString());
                    fArray = xMLWriter;
                }
            }
            hashMap.put(e, fArray);
        }
        return hashMap;
    }

    public static Class classForName(String string) throws ClassNotFoundException, NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader;
            EnvProvider envProvider = GeneralContext.getEnvProvider();
            if (envProvider == null) {
                throw classNotFoundException;
            }
            String string2 = envProvider.getPath();
            File file = new File(StableUtils.pathJoin(string2, "classes"));
            try {
                classLoader = new URLClassLoader(new URL[]{file.toURL()}, GeneralUtils.class.getClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return Class.forName(string, true, classLoader);
        }
    }

    public static void dealBuidExecuteSequence(Object object, List list, CalculatorProvider calculatorProvider) {
        if (object instanceof FormulaProvider) {
            FormulaProvider formulaProvider = (FormulaProvider)object;
            String string = formulaProvider.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtils.isEmpty(string) || StringUtils.isBlank(string)) {
                return;
            }
            try {
                Expression expression = calculatorProvider.parse(string);
                expression.trav4HuntBIL(list);
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
            }
        }
    }

    public static String readBuildNO() {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        String string = envProvider == null ? "build.txt" : envProvider.getBuildFilePath();
        return GeneralUtils.readBuildNO(string);
    }

    public static String readBuildNO(String string) {
        String string2 = IOUtils.readResourceAsString(string);
        if (StringUtils.isNotEmpty(string2)) {
            return string2;
        }
        return Inter.getLocText("FR-Basic_About_No_Build");
    }

    public static String readFullBuildNO() {
        return ProductConstants.BRANCH.getBranchName() + "-" + GeneralUtils.readBuildNO();
    }

    public static final String getUUID() {
        return UUIDHolder.UUID;
    }

    private static String execGetUUID() {
        String string = "";
        String string2 = System.getProperty("os.name", "");
        try {
            String[] stringArray;
            if (string2.startsWith("Windows")) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "wmic";
                stringArray2[1] = "csproduct";
                stringArray2[2] = "list";
                stringArray = stringArray2;
                stringArray2[3] = "full";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "dmidecode";
                stringArray3[1] = "-t";
                stringArray = stringArray3;
                stringArray3[2] = "1";
            }
            String[] stringArray4 = stringArray;
            LocalCommandExecutorServiceImpl localCommandExecutorServiceImpl = new LocalCommandExecutorServiceImpl();
            ExecuteResult executeResult = localCommandExecutorServiceImpl.executeCommand(stringArray4, 5000L);
            string = GeneralUtils.checkResult4UUID(executeResult);
            if (StringUtils.isEmpty(string)) {
                string = ProductConstants.APP_NAME + GeneralUtils.getMacAddress();
            }
        }
        catch (Throwable throwable) {
            try {
                string = ProductConstants.APP_NAME + GeneralUtils.getMacAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return GeneralUtils.encodeString(string);
        }
        catch (Throwable throwable) {
            return CodeUtils.passwordEncode(ProductConstants.APP_NAME);
        }
    }

    private static String encodeString(String string) {
        String string2 = DesUtils.getEncString(string);
        String string3 = DesUtils.getDecString(string2);
        if (ComparatorUtils.equals(string3, string)) {
            return string2;
        }
        return DesUtils.encodeWithHex(string);
    }

    public static boolean isUUIDMatch(String string) {
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        String[] stringArray = string.toUpperCase().split(",");
        String string2 = GeneralUtils.getUUID().toUpperCase();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!ComparatorUtils.equals(string2, stringArray[i].trim())) continue;
            return true;
        }
        return false;
    }

    public static final synchronized String[] getMacAddresses() throws IOException {
        if (macAddress == null) {
            Object object;
            String string = System.getProperty("os.name", "");
            String[] stringArray = null;
            if (string.startsWith("Windows")) {
                stringArray = new String[]{"ipconfig", "/all"};
            } else if (string.startsWith("AIX")) {
                stringArray = new String[]{"netstat", "-v"};
            } else if (string.startsWith("Solaris") || string.startsWith("SunOS")) {
                object = GeneralUtils.getFirstLineOfCommand(new String[]{"uname", "-n"});
                if (object != null) {
                    stringArray = new String[]{"/usr/sbin/arp", object};
                }
            } else if (new File("/usr/sbin/lanscan").exists()) {
                stringArray = new String[]{"/usr/sbin/lanscan"};
            } else if (new File("/sbin/ifconfig").exists()) {
                stringArray = new String[]{"/sbin/ifconfig", "-a"};
            } else if (string.startsWith("Linux")) {
                stringArray = new String[]{"ip", "a"};
            }
            object = new LocalCommandExecutorServiceImpl();
            ExecuteResult executeResult = object.executeCommand(stringArray, 5000L);
            Object[] objectArray = GeneralUtils.checkResult4Mac(executeResult);
            if (ArrayUtils.isEmpty(objectArray)) {
                macAddress = GeneralUtils.getMacAddressesInOldWay(stringArray);
                if (ArrayUtils.isEmpty(objectArray) && string.startsWith("AIX")) {
                    stringArray = new String[]{"netstat", "-in"};
                    macAddress = GeneralUtils.getMacAddressesInOldWay(stringArray);
                }
            }
            macAddress = objectArray;
        }
        return macAddress;
    }

    private static String[] checkResult4Mac(ExecuteResult executeResult) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (executeResult.getExitCode() != -1 && executeResult.getExecuteOut() != null) {
            String[] stringArray = executeResult.getExecuteOut().split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                string = GeneralUtils.parseMacAddress(stringArray[i]);
                if (string == null || GeneralUtils.parseShort(string) == macMax || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final String[] getMacAddressesInOldWay(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Process process = Runtime.getRuntime().exec(stringArray);
        if (process != null) {
            String string = null;
            BufferedReader bufferedReader = null;
            InputStream inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 128);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = GeneralUtils.parseMacAddress(string2);
                if (string == null || GeneralUtils.parseShort(string) == macMax || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String checkResult4UUID(ExecuteResult executeResult) throws Exception {
        String[] stringArray;
        if (executeResult.getExitCode() != -1 && executeResult.getExecuteOut() != null) {
            stringArray = executeResult.getExecuteOut().toUpperCase().split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].indexOf("UUID") == -1) continue;
                return stringArray[i].replaceAll("=", "").replaceAll("UUID", "").replaceAll(":", "").trim();
            }
        }
        if ((stringArray = new File("/var/lib/dbus/machine-id")).exists()) {
            return IOUtils.inputStream2String(new FileInputStream((File)stringArray)).trim();
        }
        return "";
    }

    public static boolean isMacAddressMatch(String string) throws IOException {
        if (StringUtils.isBlank(string)) {
            return true;
        }
        string = string.replaceAll("-", ":");
        Object[] objectArray = GeneralUtils.getMacAddresses();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectArray[i].toUpperCase();
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ArrayUtils.contains(objectArray, stringArray[i].toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String getMacAddress() throws IOException {
        String[] stringArray = GeneralUtils.getMacAddresses();
        if (ArrayUtils.getLength(stringArray) == 0) {
            return "";
        }
        return stringArray[0];
    }

    public static String[] getSystemPrinterNameArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, new HashPrintRequestAttributeSet());
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static short parseShort(String string) throws NullPointerException {
        string = string.toLowerCase();
        short s = 0;
        int n = 0;
        for (int i = 0; i < string.length() && n < hexStep; ++i) {
            char c = string.charAt(i);
            if (c >= ascCode0 && c <= ascCode9) {
                s = (short)(s << hexStep);
                n = (byte)(n + 1);
                s = (short)(s | c - ascCode0);
                continue;
            }
            if (c < ascCodea || c > ascCodef) continue;
            n = (byte)(n + 1);
            s = (short)(s << hexStep);
            s = (short)(s | c - ascCodeW);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstLineOfCommand(String[] stringArray) throws IOException {
        String string;
        block12: {
            IOException iOException3;
            Process process;
            block13: {
                process = null;
                BufferedReader bufferedReader = null;
                try {
                    process = Runtime.getRuntime().exec(stringArray);
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
                    string = bufferedReader.readLine();
                    Object var5_4 = null;
                    if (process == null) break block12;
                    if (bufferedReader == null) break block13;
                }
                catch (Throwable throwable) {
                    block16: {
                        IOException iOException22;
                        Object var5_5 = null;
                        if (process == null) break block16;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException22) {
                                // empty catch block
                            }
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            try {
                process.getErrorStream().close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            process.destroy();
        }
        return string;
    }

    private static String parseMacAddress(String string) {
        int n;
        int n2;
        int n3 = string.indexOf("0x");
        if (n3 != -1 && string.indexOf("ETHER") != -1 && (n2 = string.indexOf(32, n3)) > n3 + 2) {
            return string.substring(n3, n2);
        }
        n2 = 0;
        if (string.indexOf(45) > -1) {
            string = string.replace('-', ':');
        }
        if ((n = string.lastIndexOf(58)) > string.length() - 2) {
            return null;
        }
        int n4 = Math.min(string.length(), n + 3);
        ++n2;
        int n5 = n;
        while (n2 != macPara && n != -1 && n > 1) {
            --n;
            if (n5 - (n = string.lastIndexOf(58, n)) != 3 && n5 - n != 2) continue;
            ++n2;
            n5 = n;
        }
        if (n2 == macPara && n > 1) {
            return string.substring(n - 2, n4).trim();
        }
        return null;
    }

    public static boolean isLetter(char c) {
        return c >= ascCodeA && c <= ascCodeZ || c >= ascCodea && c <= ascCodez;
    }

    static /* synthetic */ String access$000() {
        return GeneralUtils.execGetUUID();
    }

    private static class UUIDHolder {
        static final String UUID = GeneralUtils.access$000();

        private UUIDHolder() {
        }
    }
}

