/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.form.ui.ToggleButton;
import com.fr.general.FRFont;
import com.fr.stable.CoreGraphHelper;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class CheckBox
extends ToggleButton {
    public static final Image CHECK_ON = BaseUtils.readImage("/com/fr/web/images/checkon.gif");
    public static final Image CHECK_OFF = BaseUtils.readImage("/com/fr/web/images/checkoff.gif");
    public static final int IMAGE_WIDTH = 13;
    public static final int IMAGE_START = 20;

    public String getXType() {
        return "checkbox";
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof CheckBox;
    }

    public BufferedImage toImage(Object object, int n, int n2, Style style) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n, n2);
        Graphics graphics = bufferedImage.getGraphics();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        Image image = this.checkValue(object) ? CHECK_ON : CHECK_OFF;
        int n3 = BaseUtils.getAlignment4Horizontal(style);
        int n4 = this.getPreferedWidth(n3, rectangle);
        GraphHelper.paintImageMoved(graphics, n4, 20, image, 1);
        this.paintText(style, n4, graphics);
        return bufferedImage;
    }

    private void paintText(Style style, int n, Graphics graphics) {
        FRFont fRFont = style.getFRFont();
        graphics.setColor(fRFont.getForeground());
        Font font = fRFont.applyResolutionNP(96);
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        GraphHelper.drawString(graphics, this.getText(), n, fontMetrics.getHeight());
    }

    private int getPreferedWidth(int n, Rectangle rectangle) {
        switch (n) {
            case 0: {
                return rectangle.width;
            }
            case 4: {
                return (rectangle.width - 13) * 2;
            }
        }
        return 26;
    }

    private boolean checkValue(Object object) {
        return object != null && Boolean.valueOf(object.toString()) != false;
    }
}

