/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dav;

import com.fr.base.AbstractEnv;
import com.fr.base.ConfigManager;
import com.fr.base.EnvException;
import com.fr.base.FRContext;
import com.fr.base.ModifiedTable;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.StoreProcedureParameter;
import com.fr.base.TableData;
import com.fr.base.platform.PlatformProvider;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.dav.CompileHelper;
import com.fr.dav.UserBaseEnv;
import com.fr.file.DatasourceManager;
import com.fr.file.WebXmlConfigManager;
import com.fr.file.filetree.FileNode;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.general.ModuleContext;
import com.fr.general.data.TableDataException;
import com.fr.plugin.ExtraClassManager;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLoader;
import com.fr.plugin.dependence.PluginServiceCreator;
import com.fr.plugin.dependence.PluginServiceManager;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.JavaCompileInfo;
import com.fr.stable.ParameterProvider;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.SvgProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.fun.EnvResourceTransferProvider;
import com.fr.stable.fun.ModuleShareProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.J2EEContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalEnv
extends AbstractEnv {
    public static final String[] FILE_TYPE = new String[]{"cpt", "frm", "form", "cht", "chart", "xls", "xlsx"};
    public static final int TIMEOUT = 30000;
    public static final String WAR_SUFFIX = ".war";
    public static final String LOCAL_PLUGIN_INFO = "some.info";
    public String path;
    private Timer userCheckTimer = null;
    private UserBaseEnv userBaseEnv = null;
    private String licName;
    private String buildFilePath;
    private ConcurrentHashMap<String, Object> fileLocks = new ConcurrentHashMap();
    private transient Object writeResourceLock = new Object();

    public static LocalEnv createEnv() {
        return LocalEnv.createEnv(null);
    }

    public static LocalEnv createEnv(String string) {
        return new LocalEnv(string);
    }

    public LocalEnv() {
    }

    public LocalEnv(String string) {
        this.path = string;
    }

    @Override
    public void registerUserEnv(UserBaseEnv userBaseEnv) {
        this.userBaseEnv = userBaseEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUserCheckTimer() {
        LocalEnv localEnv = this;
        synchronized (localEnv) {
            if (this.userCheckTimer != null) {
                return;
            }
            this.userCheckTimer = new Timer();
            this.userCheckTimer.schedule(new TimerTask(){

                public void run() {
                    try {
                        if (LocalEnv.this.userBaseEnv != null) {
                            LocalEnv.this.userBaseEnv.checkUserConnectedTimeOut();
                        }
                    }
                    catch (Throwable throwable) {
                        FRContext.getLogger().info(throwable.getMessage());
                    }
                }
            }, 120000L, 120000L);
        }
    }

    public boolean isNoRemoteUser() {
        return this.userCheckTimer == null;
    }

    @Override
    public ModifiedTable getDataSourceModifiedTables(String string) {
        if (ComparatorUtils.equals(string, "CONNECTION")) {
            return DatasourceManager.getProviderInstance().getConnectionTotalModifiedtables();
        }
        return DatasourceManager.getProviderInstance().getTableDataLocalModifyTable();
    }

    @Override
    public boolean writeDataSourceModifiedTables(ModifiedTable modifiedTable, String string) {
        if (ComparatorUtils.equals(string, "CONNECTION")) {
            DatasourceManager.getProviderInstance().updateSelfConnectionTotalModifiedTable(modifiedTable, "local");
        } else {
            DatasourceManager.getProviderInstance().updateSelfTableDataTotalModifiedTable(modifiedTable, "local");
        }
        return true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLicName() {
        return StringUtils.isEmpty(this.licName) ? "FineReport.lic" : this.licName;
    }

    @Override
    public String getBuildFilePath() {
        return StringUtils.isEmpty(this.buildFilePath) ? "build.txt" : this.buildFilePath;
    }

    @Override
    public void setBuildFilePath(String string) {
        this.buildFilePath = string;
    }

    @Override
    public void setLicName(String string) {
        this.licName = string;
    }

    @Override
    public String getEnvDescription() {
        return Inter.getLocText("Env-Local_Directory");
    }

    @Override
    public void signIn() throws Exception {
        this.checkValid();
    }

    private void checkValid() throws EnvException {
        File file = new File(this.path);
        if (!file.isDirectory()) {
            throw new EnvException(this.path + " is not a valid directory.");
        }
        if (!ComparatorUtils.equals(file.getName(), "WEB-INF")) {
            throw new EnvException(Inter.getLocText("FR-Designer_Env-Des1"));
        }
    }

    @Override
    public boolean signOut() throws Exception {
        return true;
    }

    @Override
    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        return new File(StableUtils.pathJoin(this.path, "reportlets", string)).exists();
    }

    @Override
    public void unlockTemplate(String string) throws Exception {
    }

    @Override
    public boolean createFolder(String string) {
        File file = new File(StableUtils.pathJoin(this.path, string));
        if (file.exists()) {
            return true;
        }
        return StableUtils.mkdirs(file);
    }

    @Override
    public boolean createFile(String string) throws Exception {
        String string2 = this.readExtraResourcePath(string);
        File file = new File(string2);
        return file.exists() || StableUtils.makesureFileExist(file);
    }

    @Override
    public boolean renameFile(String string, String string2) throws Exception {
        File file = new File(StableUtils.pathJoin(this.getPath(), string2));
        File file2 = new File(StableUtils.pathJoin(this.getPath(), string));
        return IOUtils.renameTo(file, file2);
    }

    @Override
    public boolean fileExists(String string) {
        String string2 = this.readExtraResourcePath(string);
        return new File(string2).exists();
    }

    @Override
    public boolean fileLocked(String string) throws Exception {
        return false;
    }

    @Override
    public FileNode[] listFile(String string) {
        String string2 = this.readExtraResourcePath(string);
        File file = new File(string2);
        return this.listFile(file, string);
    }

    private String readExtraResourcePath(String string) {
        Set set = ExtraClassManager.getInstance().getArray("EnvResourceTransferProvider");
        for (EnvResourceTransferProvider envResourceTransferProvider : set) {
            String string2 = envResourceTransferProvider.transferReportletPath(string);
            if (!StringUtils.isNotEmpty(string2)) continue;
            return string2;
        }
        return StableUtils.pathJoin(this.path, string);
    }

    @Override
    public FileNode[] listReportPathFile(String string) throws Exception {
        File file = new File(StableUtils.pathJoin(FRContext.getCurrentEnv().getWebReportPath(), string));
        return this.listFile(file, string);
    }

    private FileNode[] listFile(File file, String string) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        if (file.isFile()) {
            arrayList.add(new FileNode(string, file.isDirectory()));
        } else {
            int n;
            File[] fileArray = file.listFiles();
            int n2 = n = fileArray == null ? 0 : fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                arrayList.add(new FileNode(StableUtils.pathJoin(string, file2.getName()), file2.isDirectory()));
            }
        }
        return arrayList.toArray(new FileNode[arrayList.size()]);
    }

    @Override
    public FileNode[] listCpt(String string) {
        return this.listCpt(string, false);
    }

    @Override
    public FileNode[] listCpt(String string, boolean bl) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        try {
            this.listAll(string, arrayList, new String[]{"cpt"}, bl);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return arrayList.toArray(new FileNode[arrayList.size()]);
    }

    private void listAll(String string, List<FileNode> list, String[] stringArray, boolean bl) throws Exception {
        FileNode[] fileNodeArray = this.listFile(string);
        for (int i = 0; i < fileNodeArray.length; ++i) {
            FileNode fileNode = fileNodeArray[i];
            if (this.isAcceptFileType(fileNode, stringArray)) {
                list.add(fileNodeArray[i]);
                continue;
            }
            if (!fileNodeArray[i].isDirectory()) continue;
            if (bl) {
                this.listAll(string + File.separator + fileNodeArray[i].getName(), list, stringArray, true);
                continue;
            }
            list.add(fileNodeArray[i]);
        }
    }

    private boolean isAcceptFileType(FileNode fileNode, String[] stringArray) {
        for (String string : stringArray) {
            if (!fileNode.isFileType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testConnection(final Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    connection.testConnection();
                    return null;
                }
            });
            executorService.submit(futureTask);
            futureTask.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    public String getUser() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTableSchema(Connection connection) throws Exception {
        if (connection == null) {
            return null;
        }
        java.sql.Connection connection2 = connection.createConnection();
        if (connection2 == null) {
            throw new Exception("Cannot connect to database!");
        }
        Dialect dialect = DialectFactory.generateDialect(connection2);
        try {
            String[] stringArray = dialect.getSchemas(connection2);
            return stringArray;
        }
        finally {
            DBUtils.closeConnection(connection2);
        }
    }

    @Override
    public TableProcedure[] getTableProcedure(Connection connection, String string, String string2) throws Exception {
        TableProcedure[] tableProcedureArray = null;
        ResultSet resultSet = null;
        String string3 = null;
        java.sql.Connection connection2 = connection.createConnection();
        if (connection2 == null) {
            throw new Exception("Cannot connect to database!");
        }
        if (string2 != null) {
            string3 = connection2.getCatalog();
        }
        Dialect dialect = DialectFactory.generateDialect(connection2, connection.getDriver());
        if (ComparatorUtils.equals(string, "TABLE")) {
            tableProcedureArray = dialect.getTableProcedure(connection, connection2, string2, false);
        } else if (ComparatorUtils.equals(string, "VIEW")) {
            tableProcedureArray = this.getViewTableList(connection2, resultSet, string3, string2, dialect);
        } else if (ComparatorUtils.equals(string, "PROCEDURE")) {
            tableProcedureArray = dialect.getProcedureList(connection2, resultSet, string3, string2);
        } else if (ComparatorUtils.equals(string, "ALLTABLE")) {
            tableProcedureArray = dialect.getTableProcedure(connection, connection2, string2, true);
        }
        connection2.close();
        return tableProcedureArray;
    }

    private TableProcedure[] getViewTableList(java.sql.Connection connection, ResultSet resultSet, String string, String string2, Dialect dialect) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"VIEW"};
            try {
                resultSet = databaseMetaData.getTables(string, string2, "%", stringArray);
            }
            catch (SQLException sQLException) {
                resultSet = databaseMetaData.getTables(string, string2, "%", stringArray);
            }
            while (resultSet.next()) {
                arrayList.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), dialect));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    @Override
    public List getProcedures(Connection connection, String[] stringArray, boolean bl, boolean bl2) throws Exception {
        HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
        ArrayList<TableProcedure[]> arrayList = new ArrayList<TableProcedure[]>();
        java.sql.Connection connection2 = connection.createConnection();
        TableProcedure[] tableProcedureArray = null;
        String string = null;
        DatabaseMetaData databaseMetaData = connection2.getMetaData();
        int n = stringArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (string2 != null) {
                    string = connection2.getCatalog();
                }
                if (bl && !bl2) {
                    Dialect dialect = DialectFactory.generateDialect(connection2);
                    tableProcedureArray = ((OracleDialect)dialect).getProcedureList(connection2, null, null, string2);
                } else {
                    tableProcedureArray = DataCoreUtils.getTableProcedureOfStoreProcedure(databaseMetaData, string, string2, bl);
                }
                if (tableProcedureArray == null) {
                    tableProcedureArray = new TableProcedure[]{};
                }
                hashMap.put(string2, tableProcedureArray);
                arrayList.add(tableProcedureArray);
            }
        } else {
            tableProcedureArray = DataCoreUtils.getTableProcedureOfStoreProcedure(databaseMetaData, string, null, bl);
            if (tableProcedureArray == null) {
                tableProcedureArray = new TableProcedure[]{};
            }
            hashMap.put(null, tableProcedureArray);
            arrayList.add(tableProcedureArray);
        }
        connection2.close();
        DataCoreUtils.putProcedureMap(connection, hashMap);
        return arrayList;
    }

    @Override
    public ParameterProvider[] getTableDataParameters(TableData tableData) {
        ParameterProvider[] parameterProviderArray = null;
        if (tableData != null) {
            parameterProviderArray = tableData.getParameters(Calculator.createCalculator());
        }
        return parameterProviderArray == null ? new ParameterProvider[]{} : parameterProviderArray;
    }

    public Parameter[] getStoreProcedureParameters(StoreProcedure storeProcedure) throws Exception {
        return storeProcedure.get_IN_Parameters();
    }

    @Override
    public EmbeddedTableData previewTableData(Object object, Map map, int n) throws TableDataException {
        return this.previewTableData(object, map, n, -1, new String[0], new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public EmbeddedTableData previewTableData(Object object, Map map, int n, int n2, String[] stringArray, int[] nArray) throws TableDataException {
        TableData tableData = null;
        EmbeddedTableData embeddedTableData2 = null;
        try {
            tableData = (TableData)((TableData)object).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            JOptionPane.showMessageDialog(null, cloneNotSupportedException.getMessage());
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(map);
        calculator.pushNameSpace(parameterMapNameSpace);
        try {
            int n3 = n;
            if (n >= 0 && n2 >= n && tableData instanceof DBTableData) {
                java.sql.Connection connection = null;
                try {
                    DBTableData dBTableData = (DBTableData)tableData;
                    connection = dBTableData.getDatabase().createConnection();
                    Dialect dialect = DialectFactory.generateDialect(connection);
                    dBTableData.setQuery(dialect.getRowRangeSql(dBTableData.getQuery(), n, n2, stringArray));
                    n3 = -1;
                }
                catch (Exception exception) {
                    DBUtils.closeConnection(connection);
                    catch (Throwable throwable) {
                        DBUtils.closeConnection(connection);
                        throw throwable;
                    }
                }
                DBUtils.closeConnection(connection);
            }
            embeddedTableData2 = EmbeddedTableData.embedify(tableData, calculator, n3);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage());
            throw new TableDataException(tableDataException.getMessage(), tableDataException);
        }
        finally {
            calculator.removeNameSpace(parameterMapNameSpace);
        }
        return embeddedTableData2 == null ? new EmbeddedTableData() : embeddedTableData2;
    }

    public void openContainerFolder(FileNode fileNode) {
        if (fileNode == null) {
            return;
        }
        IOUtils.openWindowsFolder(StableUtils.pathJoin(this.path, fileNode.getEnvPath()));
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DIR".equals(xMLableReader.getTagName())) {
            this.path = xMLableReader.getElementValue();
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DIR").textNode(this.path).end();
    }

    private void writeTempFile(XMLFileManagerProvider xMLFileManagerProvider, String string, String string2) throws Exception {
        OutputStream outputStream = this.writeBean(string, string2);
        XMLTools.writeOutputStreamXML(xMLFileManagerProvider, outputStream);
        outputStream.flush();
        outputStream.close();
    }

    private void renameTo(String string, String string2, String string3) throws Exception {
        File file = new File(StableUtils.pathJoin(this.getPath(), string3, string2));
        File file2 = new File(StableUtils.pathJoin(this.getPath(), string3, string));
        IOUtils.renameTo(file, file2);
    }

    @Override
    public boolean writeResource(XMLFileManagerProvider xMLFileManagerProvider) throws Exception {
        return this.writeResource(xMLFileManagerProvider, "resources");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeResource(XMLFileManagerProvider xMLFileManagerProvider, String string) throws Exception {
        Object object;
        String string2 = xMLFileManagerProvider.fileName();
        String string3 = string2 + ".tmp";
        Object object2 = this.writeResourceLock;
        synchronized (object2) {
            if (!this.fileLocks.containsKey(string3)) {
                this.fileLocks.put(string3, new Object());
            }
            object = this.fileLocks.get(string3);
        }
        object2 = object;
        synchronized (object2) {
            this.writeTempFile(xMLFileManagerProvider, string3, string);
            this.renameTo(string2, string3, string);
        }
        this.setWebXMLConfigManager(xMLFileManagerProvider);
        return true;
    }

    public void setWebXMLConfigManager(XMLFileManagerProvider xMLFileManagerProvider) throws IOException {
        if (xMLFileManagerProvider instanceof ConfigManager && StringUtils.isNotEmpty(this.path)) {
            File file = new File(StableUtils.pathJoin(this.path, "web.xml"));
            WebXmlConfigManager webXmlConfigManager = new WebXmlConfigManager((ConfigManager)xMLFileManagerProvider, file);
            webXmlConfigManager.saveServletMapping();
        }
    }

    @Override
    public InputStream readResource(String string) throws Exception {
        return this.readBean(string, "resources");
    }

    @Override
    public InputStream readBean(String string, String string2) throws Exception {
        String string3 = this.readExtraResourcePath(string2);
        File file = new File(StableUtils.pathJoin(string3, string));
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    @Override
    public OutputStream writeBean(String string, String string2) throws Exception {
        String string3 = this.readExtraResourcePath(string2);
        File file = new File(StableUtils.pathJoin(string3, string));
        StableUtils.makesureFileExist(file);
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumns(String string, String string2, String string3) throws Exception {
        String[] stringArray;
        java.sql.Connection connection = null;
        try {
            connection = new NameDatabaseConnection(string).createConnection();
            Dialect dialect = DialectFactory.getDialectByName(string);
            stringArray = DBUtils.checkInColumnNames(connection, dialect, DataCoreUtils.createSelectSQL(string2, string3, dialect));
        }
        catch (Throwable throwable) {
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
        return stringArray;
    }

    @Override
    public String getWebReportPath() {
        return new File(this.getPath()).getParent();
    }

    @Override
    public String getProcedureText(String string, String string2) throws Exception {
        Connection connection = DatasourceManager.getProviderInstance().getConnection(string);
        String string3 = connection.getNewCharsetName();
        string3 = string3 == null ? "UTF-8" : string3;
        java.sql.Connection connection2 = connection.createConnection();
        Dialect dialect = DialectFactory.generateDialect(connection2);
        String string4 = dialect.getStoreProcedureText(connection2, string2, string3);
        connection2.close();
        return string4;
    }

    @Override
    public File[] readPathSvgFiles(String string) {
        string = StableUtils.pathJoin(GeneralContext.getEnvProvider().getPath(), "resources", string);
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists() && file.isDirectory()) {
            return file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith("svg");
                }
            });
        }
        return new File[0];
    }

    @Override
    public boolean writeSvgFile(SvgProvider svgProvider) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(svgProvider.getFilePath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        DOMSource dOMSource = new DOMSource((Node)svgProvider.getSvgDocument());
        StreamResult streamResult = new StreamResult(outputStreamWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                FRContext.getLogger().error(transformerException.getMessage());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            FRContext.getLogger().error(transformerConfigurationException.getMessage());
            return false;
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
        fileOutputStream.close();
        return true;
    }

    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(String string, String string2, String string3) throws Exception {
        Connection connection = DatasourceManager.getProviderInstance().getConnection(string);
        java.sql.Connection connection2 = connection.createConnection();
        Dialect dialect = DialectFactory.generateDialect(connection2);
        StoreProcedureParameter[] storeProcedureParameterArray = dialect.getStoreProcedureDeclarationParameters(connection2, string2, string3);
        connection2.close();
        return storeProcedureParameterArray;
    }

    @Override
    public ProcedureDataModel[] previewProcedureDataModel(StoreProcedure storeProcedure, Map map, int n) {
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(map);
        calculator.pushNameSpace(parameterMapNameSpace);
        return storeProcedure.creatDataModel(calculator);
    }

    @Override
    public String getAppName() {
        String string = new File(this.getPath()).getParent();
        if (J2EEContainer.isJBoss7() && !this.isPackDeploy()) {
            return ConfigManager.getProviderInstance().getJbossWebappName();
        }
        return new File(string).getName().replaceAll(WAR_SUFFIX, "");
    }

    @Override
    public boolean isOracle(Connection connection) throws Exception {
        java.sql.Connection connection2 = connection.createConnection();
        boolean bl = DialectFactory.generateDialect(connection2) instanceof OracleDialect;
        DBUtils.closeConnection(connection2);
        return bl;
    }

    @Override
    public String[] getSupportedTypes() {
        return FILE_TYPE;
    }

    @Override
    public boolean isSupportLocalFileOperate() {
        return true;
    }

    @Override
    public boolean hasFileFolderAllow(String string) {
        return true;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public boolean deleteFile(String string) {
        return StableUtils.deleteFile(new File(StableUtils.pathJoin(this.path, string)));
    }

    @Override
    public boolean testServerConnectionWithOutShowMessagePane() throws Exception {
        return true;
    }

    @Override
    public boolean isPackDeploy() {
        return false;
    }

    @Override
    public String getDesignerVersion() {
        return ProductConstants.DESIGNER_VERSION;
    }

    @Override
    public InputStream getDataSourceInputStream(String string) throws Exception {
        return new FileInputStream(StableUtils.pathJoin(this.getPath(), string));
    }

    @Override
    public void printLogMessage() throws Exception {
    }

    @Override
    public String getUserID() {
        return "";
    }

    @Override
    public void removeNoPrivilegeConnection() {
    }

    @Override
    public ArrayList getAllRole4Privilege(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleContext.startModule("com.fr.fs.FSModule");
        PlatformProvider platformProvider = StableFactory.getMarkedObject("PlatformProvider", PlatformProvider.class);
        try {
            String[] stringArray = platformProvider.getAllCompanyRole4Designer();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return arrayList;
    }

    @Override
    public JavaCompileInfo compilerSourceCode(String string) throws Exception {
        return CompileHelper.compile(string);
    }

    @Override
    public void copyFilesToPluginAndLibFolder(File file, Plugin plugin) throws Exception {
        Object[] objectArray = file.listFiles();
        if (ArrayUtils.isNotEmpty(objectArray)) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (((File)object).getAbsolutePath().endsWith(".jar")) {
                    String string = plugin.getNodeName() + "-" + i + ".jar";
                    String string2 = StableUtils.getInstallHome();
                    IOUtils.copy(new FileInputStream((File)object), string, new File(StableUtils.pathJoin(this.path, "lib")));
                    this.copyFileToInstallLibFolder((File)object, string, string2);
                    continue;
                }
                IOUtils.copy((File)object, new File(StableUtils.pathJoin(this.path, "plugins", plugin.getNodeName())));
            }
        }
    }

    public void copyFileToInstallLibFolder(File file, String string, String string2) throws Exception {
        IOUtils.copy(new FileInputStream(file), string, new File(StableUtils.pathJoin(string2, "lib")));
    }

    @Override
    public String[] deleteFileFromPluginAndLibFolder(Plugin plugin) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(StableUtils.pathJoin(this.path, "plugins", plugin.getNodeName()));
        hashSet.add(file.getAbsolutePath());
        plugin.delEmbFile();
        this.deleteJarFromLib(plugin.getNodeName(), hashSet);
        this.deleteJarFromInstallLib(plugin.getNodeName(), hashSet);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public void movePluginEmbFile(File file, Plugin plugin) throws Exception {
        plugin.moveEmbFile(file);
    }

    private void deleteJarFromLib(String string, Set<String> set) {
        File file = new File(StableUtils.pathJoin(this.path, "lib"));
        this.deleteJarFromFolder(file, string, set);
    }

    private void deleteJarFromInstallLib(String string, Set<String> set) {
        File file = new File(StableUtils.pathJoin(StableUtils.getInstallHome(), "lib"));
        this.deleteJarFromFolder(file, string, set);
    }

    private void deleteJarFromFolder(File file, String string, Set<String> set) {
        Object[] objectArray = file.listFiles();
        if (ArrayUtils.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!((File)object).getAbsolutePath().endsWith(".jar") || !((File)object).getName().startsWith(string)) continue;
                set.add(((File)object).getAbsolutePath());
            }
        }
    }

    @Override
    public void writePlugin(Plugin plugin) throws Exception {
        plugin.modifyActive(new File(StableUtils.pathJoin(this.path, "plugins", plugin.getNodeName(), "plugin.xml")));
    }

    @Override
    public String getPluginFilePath(Plugin plugin) {
        return StableUtils.pathJoin(this.path, "plugins", plugin.getNodeName());
    }

    @Override
    public void checkAndRegisterLic(FileNode fileNode, Plugin plugin) throws Exception {
        PluginLoader.getLoader().checkAndRegisterLic(fileNode, plugin);
    }

    @Override
    public void readPluginLicenses() throws Exception {
    }

    @Override
    public String pluginServiceAction(String string, String string2) throws Exception {
        PluginServiceCreator pluginServiceCreator = PluginServiceManager.getService(string);
        if (pluginServiceCreator == null) {
            return null;
        }
        return pluginServiceCreator.serviceAction(string2);
    }

    @Override
    public void pluginServiceStart(String string) {
        PluginServiceCreator pluginServiceCreator = PluginServiceManager.getService(string);
        if (pluginServiceCreator == null) {
            return;
        }
        pluginServiceCreator.startService();
    }

    @Override
    public File[] loadREUFile() {
        File file;
        String string = StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), "reportlets", "FineReport.Reuse");
        ModuleShareProcessor moduleShareProcessor = (ModuleShareProcessor)ExtraClassManager.getInstance().getSingle("ModuleShareProcessor");
        if (moduleShareProcessor != null) {
            string = moduleShareProcessor.getShareDir();
        }
        if ((file = new File(string)).exists() && file.isDirectory()) {
            return file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith("reu");
                }
            });
        }
        return new File[0];
    }

    @Override
    public boolean installREUFile(File file) {
        try {
            IOUtils.copy(file, new File(this.getSharePath()));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean removeREUFilesByName(String string) {
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        return StableUtils.deleteFile(new File(StableUtils.pathJoin(this.getSharePath(), string)));
    }

    @Override
    public String getSharePath() {
        String string = StableUtils.pathJoin(this.getPath(), "reportlets", "FineReport.Reuse");
        ModuleShareProcessor moduleShareProcessor = (ModuleShareProcessor)ExtraClassManager.getInstance().getSingle("ModuleShareProcessor");
        if (moduleShareProcessor != null) {
            string = moduleShareProcessor.getShareDir();
        }
        return string;
    }
}

