/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.BaseScriptUtils;
import com.fr.base.ParameterHelper;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.TemplateUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.data.impl.NameTableData;
import com.fr.data.impl.RecursionTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;

public class TableDataDictionary
extends FormulaDisplayDictionary {
    private TableData tableData;
    private transient String query;
    private transient TableData tempTableData;

    public TableDataDictionary() {
        this(TableData.EMPTY_TABLEDATA, 0, 1);
    }

    public TableDataDictionary(TableData tableData, int n, int n2) {
        this.setTableData(tableData);
        this.setKeyColumnIndex(n);
        this.setValueColumnIndex(n2);
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = super.dependence(calculatorProvider);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        if (this.tableData != null) {
            ParameterProvider[] parameterProviderArray = this.tableData.getParameters((Calculator)calculatorProvider);
            if (parameterProviderArray != null && parameterProviderArray.length != 0) {
                for (int i = 0; i < parameterProviderArray.length; ++i) {
                    ParameterProvider parameterProvider = parameterProviderArray[i];
                    if (parameterProvider == null || parameterProvider.getName() == null) continue;
                    arrayList.add(parameterProvider.getName());
                }
            } else if (this.isDBNameTableData((Calculator)calculatorProvider)) {
                DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
                return BaseScriptUtils.getDependenceByParameter(ParameterHelper.analyze4Parameters(dBTableData.getQuery(), true));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isDBNameTableData(Calculator calculator) {
        return this.getTableData() instanceof NameTableData && ((NameTableData)this.getTableData()).createTableData(calculator) instanceof DBTableData;
    }

    private boolean isNameTableData(Calculator calculator) {
        return this.tableData instanceof NameTableData;
    }

    private boolean isDBTableData(Calculator calculator) {
        if (this.isNameTableData(calculator)) {
            return ((NameTableData)this.tableData).createTableData(calculator) instanceof DBTableData;
        }
        return false;
    }

    protected TableData asTableData(Calculator calculator) {
        if (this.isNameTableData(calculator)) {
            this.tempTableData = ((NameTableData)this.getTableData()).getTableData();
            if (this.isDBTableData(calculator)) {
                DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
                ParameterMapNameSpace parameterMapNameSpace = this.getDBParameterNameSpace(calculator);
                calculator.pushNameSpace(parameterMapNameSpace);
                this.query = TemplateUtils.renderTpl(calculator, dBTableData.getQuery());
                DBTableData dBTableData2 = new DBTableData(dBTableData.getDatabase(), this.query);
                calculator.removeNameSpace(parameterMapNameSpace);
                dBTableData2.setShare(dBTableData.isShare());
                return dBTableData2;
            }
        }
        return this.getTableData();
    }

    protected boolean isShareAvailable(Calculator calculator) {
        if (!super.isShareAvailable(calculator) || !this.isNameTableData(calculator)) {
            return false;
        }
        TableData tableData = ((NameTableData)this.getTableData()).getTableData();
        if (tableData instanceof DBTableData) {
            return ComparatorUtils.equals(this.query, TemplateUtils.renderTpl(calculator, ((DBTableData)tableData).getQuery()));
        }
        if (tableData instanceof RecursionTableData) {
            return ComparatorUtils.equals(tableData, this.tempTableData);
        }
        return false;
    }

    public ParameterMapNameSpace getDBParameterNameSpace(Calculator calculator) {
        DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
        ParameterProvider[] parameterProviderArray = dBTableData.getParameters(calculator);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < parameterProviderArray.length; ++i) {
            try {
                String string = parameterProviderArray[i].getName();
                Object object = parameterProviderArray[i].getValue();
                if (!StableUtils.isNull(calculator.eval(string))) continue;
                if (object instanceof FormulaProvider) {
                    object = calculator.evalValue((FormulaProvider)object);
                }
                if (StringUtils.isEmpty(GeneralUtils.objectToString(object))) continue;
                hashMap.put(parameterProviderArray[i].getName(), parameterProviderArray[i].getValue());
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage());
            }
        }
        return ParameterMapNameSpace.create(hashMap);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ("TableDataDictAttr".equals(string = xMLableReader.getTagName()) || "TableDataMapAttr".equals(string))) {
            String string2 = xMLableReader.getAttrAsString("keyColumnIndex", null);
            if (string2 != null) {
                this.setKeyColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttrAsString("valueColumnIndex", null)) != null) {
                this.setValueColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttrAsString("tableDataName", null)) != null) {
                this.setTableData(new NameTableData(string2));
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        if ("TableData".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.setTableData(DataCoreXmlUtils.readXMLTableData(xMLableReader));
                        }
                        if ("Condition".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
                        }
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("TableDataDictAttr");
        DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.getTableData());
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableDataDictionary)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.tableData, ((TableDataDictionary)object).tableData);
    }

    public String toString() {
        return "TableDataDict[" + this.getTableData() + "]";
    }
}

