/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.DataPoint4Stock;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StockPlotGlyph
extends RectanglePlotGlyph {
    public static final String XML_TAG = "StockPlotGlyph";
    private static final long serialVersionUID = 3316033411141629460L;
    private static final int VOLUME = 0;
    private static final int OPEN = 1;
    private static final int HIGH = 2;
    private static final int LOW = 3;
    private static final int CLOSE = 4;
    private Image errorImage;
    private String errorToopTip;
    private int highLowLineStyle = 1;
    private Color highLowLineColor = Color.gray;
    private int upBarBorderLineStyle = 1;
    private Color upBarBorderLineBackground = Color.red;
    private Color upBarBackground = Color.red;
    private int downBarBorderLineStyle = 1;
    private Color downBarBorderLineBackground = Color.green;
    private Color downBarBackground = Color.green;

    public void setErrorImage(Image image) {
        this.errorImage = image;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorToopTip(String string) {
        this.errorToopTip = string;
    }

    public String getErrorToopTip() {
        return this.errorToopTip;
    }

    public void setUpBarBorderLineStyle(int n) {
        this.upBarBorderLineStyle = n;
    }

    public void setUpBarBorderLineBackground(Color color) {
        this.upBarBorderLineBackground = color;
    }

    public void setUpBarBackground(Color color) {
        this.upBarBackground = color;
    }

    public void setDownBarBorderLineStyle(int n) {
        this.downBarBorderLineStyle = n;
    }

    public void setDownBarBorderLineBackground(Color color) {
        this.downBarBorderLineBackground = color;
    }

    public void setDownBarBackground(Color color) {
        this.downBarBackground = color;
    }

    public void layoutAxisGlyph(int n) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), n);
    }

    public void doLayout(DataSheetGlyph dataSheetGlyph) {
        dataSheetGlyph.setBeginX(this.getxAxisGlyph().getBounds().getX() + this.getBounds().getX());
        dataSheetGlyph.setUnitLength(this.getxAxisGlyph().getUnitLen());
        Rectangle2D rectangle2D = this.getBounds();
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), dataSheetGlyph.getBeginX() + this.getxAxisGlyph().getAxisLength() - rectangle2D.getX(), rectangle2D.getHeight());
        this.setBounds(rectangle2D);
        dataSheetGlyph.setCrossValue(this.getxAxisGlyph().getCrossValue());
        dataSheetGlyph.setArrowValue(this.getxAxisGlyph().getArrowValue());
    }

    public DataSheetGlyph createDataSheetGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        return this.createSheetGlyphAndNotShowAxisGlyph(dataSheet, legendItemArray);
    }

    public void layoutDataSeriesGlyph(int n) {
        if (this.getErrorImage() != null) {
            return;
        }
        double d = this.getSecondAxisGlyph() != null ? this.getSecondAxisGlyph().getCrossValueInPlot() : 0.0;
        double d2 = this.getxAxisGlyph().getUnitLen();
        double d3 = (int)(d2 / 2.0);
        double d4 = Math.max(d2 - d3, 1.0);
        double d5 = (int)d4;
        DataSeries dataSeries = this.getSeries(0);
        int n2 = 0;
        for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
            if (dataSeries.getDataPoint(i).isValueIsNull()) continue;
            ++n2;
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        n2 = 0;
        int n3 = dataSeries.getDataPointCount();
        for (int i = 0; i < n3; ++i) {
            DataPoint4Stock dataPoint4Stock = (DataPoint4Stock)dataSeries.getDataPoint(i);
            if (dataPoint4Stock.isValueIsNull()) continue;
            double[] dArray3 = dataPoint4Stock.getStockValues();
            double d6 = dArray3[4];
            float f = (float)this.getxAxisGlyph().getPoint2D((double)this.getxAxisGlyph().getTickIndex4Value(i) + 0.5).getX();
            float f2 = this.getValueInBounds((float)this.getyAxisGlyph().getPoint2D(d6).getY());
            this.dealEveryShape(dataPoint4Stock, i, d4, d, d5);
            dArray[n2] = f;
            dArray2[n2] = f2;
            ++n2;
        }
        this.trendLineFitting(dArray, dArray2, dataSeries);
    }

    private void dealEveryShape(DataPoint4Stock dataPoint4Stock, int n, double d, double d2, double d3) {
        double[] dArray = dataPoint4Stock.getStockValues();
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        double d7 = dArray[3];
        double d8 = dArray[4];
        float f = (float)this.getxAxisGlyph().getPoint2D((double)this.getxAxisGlyph().getTickIndex4Value(n) + 0.5).getX();
        float f2 = this.getValueInBounds((float)this.getyAxisGlyph().getPoint2D(d6).getY());
        float f3 = this.getValueInBounds((float)this.getyAxisGlyph().getPoint2D(d7).getY());
        float f4 = this.getValueInBounds((float)this.getyAxisGlyph().getPoint2D(d5).getY());
        float f5 = this.getValueInBounds((float)this.getyAxisGlyph().getPoint2D(d8).getY());
        FoldLine foldLine = new FoldLine();
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f, f3);
        foldLine.setGeneralPath(generalPath);
        dataPoint4Stock.setHighLowLine(foldLine);
        ShapeGlyph shapeGlyph = new ShapeGlyph();
        dataPoint4Stock.setDrawImpl(shapeGlyph);
        if (Double.isNaN(d4) && Double.isNaN(d5)) {
            shapeGlyph.setShape(new Rectangle2D.Double((double)f - d, f5, d, 1.0));
            shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint4Stock, this.createColors4Series());
            foldLine.getLineStyleInfo().getAttrLineColor().setSeriesColor(this.highLowLineColor);
            foldLine.getLineStyleInfo().getAttrLineStyle().setLineStyle(this.highLowLineStyle);
        } else if (Double.isNaN(d4)) {
            this.dealUpDown(f4, f5, f, foldLine, shapeGlyph, d, null);
        } else if (Double.isNaN(d5)) {
            double d9 = this.getSecondAxisGlyph().getPoint2D(d4).getY();
            double d10 = this.getSecondAxisGlyph().getPoint2D(d2).getY() - d9;
            ShapeGlyph shapeGlyph2 = new ShapeGlyph();
            shapeGlyph2.setShape(new Rectangle2D.Double((double)f - d3 / 2.0, d9, d3, d10));
            dataPoint4Stock.setVolumeGlyph(shapeGlyph2);
            shapeGlyph2.dealCondition(this.getConditionCollection(), dataPoint4Stock, this.createColors4Series());
            shapeGlyph.setShape(new Rectangle2D.Double((double)f - d, f5, d, 1.0));
            shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint4Stock, this.createColors4Series());
            foldLine.getLineStyleInfo().getAttrLineColor().setSeriesColor(this.highLowLineColor);
            foldLine.getLineStyleInfo().getAttrLineStyle().setLineStyle(this.highLowLineStyle);
        } else {
            double d11 = this.getSecondAxisGlyph().getPoint2D(d4).getY();
            double d12 = this.getSecondAxisGlyph().getPoint2D(d2).getY() - d11;
            ShapeGlyph shapeGlyph3 = new ShapeGlyph();
            shapeGlyph3.setShape(new Rectangle2D.Double((double)f - d3 / 2.0, d11, d3, d12));
            dataPoint4Stock.setVolumeGlyph(shapeGlyph3);
            shapeGlyph3.dealCondition(this.getConditionCollection(), dataPoint4Stock, this.createColors4Series());
            this.dealUpDown(f4, f5, f, foldLine, shapeGlyph, d, shapeGlyph3);
        }
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        return new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0 - 3.0, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private float getValueInBounds(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if ((double)f > this.getBounds().getHeight()) {
            f = (float)this.getBounds().getHeight();
        }
        return f;
    }

    private void dealUpDown(double d, double d2, double d3, FoldLine foldLine, ShapeGlyph shapeGlyph, double d4, ShapeGlyph shapeGlyph2) {
        if (d > d2) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - d4 / 2.0, d2, d4, d - d2);
            shapeGlyph.setBackground((Background)ColorBackground.getInstance((Color)this.upBarBackground));
            shapeGlyph.setBorderColor(this.upBarBorderLineBackground);
            shapeGlyph.setBorderStyle(this.upBarBorderLineStyle);
            shapeGlyph.setShape(double_);
            foldLine.getLineStyleInfo().getAttrLineColor().setSeriesColor(this.upBarBackground);
            if (shapeGlyph2 != null) {
                shapeGlyph2.setBackground((Background)ColorBackground.getInstance((Color)this.upBarBackground));
            }
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - d4 / 2.0, d, d4, d2 - d);
            shapeGlyph.setBackground((Background)ColorBackground.getInstance((Color)this.downBarBackground));
            shapeGlyph.setBorderColor(this.downBarBorderLineBackground);
            shapeGlyph.setBorderStyle(this.downBarBorderLineStyle);
            shapeGlyph.setShape(double_);
            foldLine.getLineStyleInfo().getAttrLineColor().setSeriesColor(this.downBarBackground);
            if (shapeGlyph2 != null) {
                shapeGlyph2.setBackground((Background)ColorBackground.getInstance((Color)this.downBarBackground));
            }
        }
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.errorImage != null) {
            int n2 = (int)(this.getBounds().getWidth() - (double)this.errorImage.getWidth(null)) / 2;
            int n3 = (int)(this.getBounds().getHeight() - (double)this.errorImage.getHeight(null)) / 2;
            graphics2D.drawImage(this.errorImage, n2, n3, null);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n);
    }

    public boolean equals(Object object) {
        return object instanceof StockPlotGlyph && super.equals(object);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.errorImage != null) {
            ChartBaseUtils.image2JS(repository, jSONObject, this.errorImage);
        }
        jSONObject.put("errorToopTip", (Object)this.errorToopTip);
        jSONObject.put("upBarBorderLineStyle", this.upBarBorderLineStyle);
        if (this.upBarBorderLineBackground != null) {
            jSONObject.put("upBarBorderLineBackground", (Object)StableUtils.javaColorToCSSColor((Color)this.upBarBorderLineBackground));
        }
        if (this.upBarBackground != null) {
            jSONObject.put("upBarBackground", (Object)StableUtils.javaColorToCSSColor((Color)this.upBarBackground));
        }
        jSONObject.put("downBarBorderLineStyle", this.downBarBorderLineStyle);
        if (this.downBarBorderLineBackground != null) {
            jSONObject.put("downBarBorderLineBackground", (Object)StableUtils.javaColorToCSSColor((Color)this.downBarBorderLineBackground));
        }
        if (this.downBarBackground != null) {
            jSONObject.put("downBarBackground", (Object)StableUtils.javaColorToCSSColor((Color)this.downBarBackground));
        }
        jSONObject.put("highLowLineStyle", this.highLowLineStyle);
        if (this.highLowLineColor != null) {
            jSONObject.put("highLowLineColor", (Object)StableUtils.javaColorToCSSColor((Color)this.highLowLineColor));
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }

    public String getChartType() {
        return "Stock";
    }

    public boolean isSupportLegend() {
        return false;
    }
}

