/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.ScreenResolution;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Arc3DStyleBase;
import com.fr.chart.chartglyph.ArcHighLightStyleBase;
import com.fr.chart.chartglyph.ArcPlane3DStyle;
import com.fr.chart.chartglyph.ArcTopDownShadeStyle;
import com.fr.chart.chartglyph.ArcTransparentChartStyle;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataPointLabelInfo;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.stable.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class PiePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 7862387644048932954L;
    public static final double START_ANGLE = 90.0;
    private static final double LABEL_ANGLE = 10.0;
    private static final double MARGIN_WIDTH = 0.01;
    protected static final double FIRST_QUA = 90.0;
    protected static final double SECOND_QUA = 180.0;
    protected static final double THRID_QUA = 270.0;
    private static final double FOUTH_QUA = 360.0;
    private static final double BEST_RAD = 0.9;
    protected static final double WHEN_MORE_RAD = 0.8;
    protected static final double MOVE_GAP = 0.1;
    protected static final double NO_BOUNDS = 0.9;
    protected static final double RADIO_PERCENT = 1.2;
    private static final double BASE_PERCENT = 1.31;
    private static final double RADIUS_PERCENT_DIFF = 0.05;
    private static final double RADIUS_MIN_PERCENR = 0.5;
    private static final int MAX_SERIES_MODE = 5;
    protected static final double OUTSIDE_LABEL_RADIUS_COEFFICIENT = 1.3;
    private Arc3DStyleBase arc3DStyleBase;
    private ArcHighLightStyleBase arcHighLightStyle;
    protected transient double radius = 0.0;
    private transient double maxLabelWidth = 0.0;
    private transient ArrayList leftUp = new ArrayList();
    private transient ArrayList rightUp = new ArrayList();
    private transient ArrayList leftDown = new ArrayList();
    private transient ArrayList rightDown = new ArrayList();
    protected double radiusPercent = 0.9;

    protected double getSeriesStartAngle(int n, int n2) {
        double d = 90.0;
        for (int i = 0; i < n2; ++i) {
            d += this.getPercent(i, n) * 360.0;
        }
        return d;
    }

    protected double getHalfAngle(double d, int n, int n2) {
        return d + this.getPercent(n, n2) * 360.0 / 2.0;
    }

    protected double getTotalValue(int n) {
        double d = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            d += Math.abs(dataPoint4Pie.getValue());
        }
        return d;
    }

    protected double getPercent(int n, int n2) {
        double d = this.getTotalValue(n2);
        if (d <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
        return Math.abs(dataPoint4Pie.getValue()) / d;
    }

    private void clearList() {
        this.leftUp.clear();
        this.leftDown.clear();
        this.rightUp.clear();
        this.rightDown.clear();
    }

    private void sortList() {
        this.bubbleSort(this.leftUp);
        this.bubbleSort(this.leftDown);
        this.bubbleSort(this.rightUp);
        this.bubbleSort(this.rightDown);
    }

    private void bubbleSort(ArrayList arrayList) {
        PointAndAngle[] pointAndAngleArray = arrayList.toArray(new PointAndAngle[0]);
        int n = pointAndAngleArray.length - 1;
        for (int i = 0; i < n; ++i) {
            PointAndAngle pointAndAngle;
            int n2;
            for (n2 = i; n2 < n; ++n2) {
                if (!(pointAndAngleArray[n2].centerAngle > pointAndAngleArray[n2 + 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n2];
                pointAndAngleArray[n2] = pointAndAngleArray[n2 + 1];
                pointAndAngleArray[n2 + 1] = pointAndAngle;
            }
            for (n2 = --n; n2 > i; --n2) {
                if (!(pointAndAngleArray[n2].centerAngle < pointAndAngleArray[n2 - 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n2];
                pointAndAngleArray[n2] = pointAndAngleArray[n2 - 1];
                pointAndAngleArray[n2 - 1] = pointAndAngle;
            }
        }
        arrayList.clear();
        for (PointAndAngle pointAndAngle : pointAndAngleArray) {
            arrayList.add(pointAndAngle);
        }
    }

    public void layoutAxisGlyph(int n) {
    }

    protected void initLabelData(int n, int n2) {
        this.radius = this.getPieDimension(n) / 2.0;
        this.maxLabelWidth = this.getMaxLabelWidth(n, n2);
        this.getSeriesCountWithQuadrant(n);
    }

    public void layoutDataSeriesGlyph(int n) {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.deal4EachCategory(i, n);
        }
        this.dealLabelBoundsInOrder();
    }

    protected void dealLabelBoundsOutPlotBounds(Rectangle2D rectangle2D, GeneralPath generalPath, DataPoint dataPoint, List list, int n) {
        String string;
        double d;
        int n2;
        if (!this.isOutsideLabel(dataPoint.getSeriesIndex(), dataPoint.getCategoryIndex())) {
            super.dealLabelBoundsOutPlotBounds(rectangle2D, generalPath, dataPoint, list, n);
            return;
        }
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataPoint;
        if (!dataPoint4Pie.isShowLabel()) {
            return;
        }
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty((String)dataPoint.getDataLabel().text)) {
            return;
        }
        if (rectangle2D.getX() >= this.getBounds().getX() && rectangle2D.getMaxX() <= this.getBounds().getMaxX()) {
            return;
        }
        double d2 = rectangle2D.getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            d2 = rectangle2D.getMaxX() - this.getBounds().getX();
        } else if (rectangle2D.getMaxX() > this.getBounds().getMaxX()) {
            d2 = this.getBounds().getMaxX() - rectangle2D.getX();
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        String string2 = dataPoint4Pie.getDataLabel().getText();
        int n3 = ScreenResolution.getScreenResolution();
        for (n2 = 0; n2 < string2.length() && !((d = GlyphUtils.calculateTextDimensionWithNoRotation(string = string2.substring(0, n2) + "\u2026", textAttr, n3).getWidth()) > d2); ++n2) {
        }
        if (n2 == 0) {
            dataPoint4Pie.setShowText("\u2026");
        } else {
            dataPoint4Pie.setShowText(string2.substring(0, n2 - 1) + "\u2026");
        }
        double d3 = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint4Pie.getShowText(), textAttr, n3).getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            rectangle2D.setRect(this.getBounds().getX(), rectangle2D.getY(), d3, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getHeight());
        }
        dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
    }

    protected void deal4EachCategory(int n, int n2) {
        this.initLabelData(n, n2);
        this.dealWithDataSeries(n, n2);
    }

    protected void dealWithDataSeries(int n, int n2) {
        this.arc3DStyleBase = null;
        this.arcHighLightStyle = null;
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            if (dataPoint4Pie.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint4Pie);
            dataPoint4Pie.setDrawImpl(shapeGlyph);
            if (this.getSubType() != 1) continue;
            this.dealPlotStyle(this.plotStyle, dataPoint4Pie);
        }
        this.dealWithCategoryLabels(n, n2);
    }

    private boolean isExistOuterLabels() {
        return !this.leftUp.isEmpty() || !this.leftDown.isEmpty() || !this.rightUp.isEmpty() || !this.rightDown.isEmpty();
    }

    protected void dealWithCategoryLabels(int n, int n2) {
        if (this.isExistOuterLabels()) {
            this.dealOutSideLabels(n, n2);
            this.dealLabelBoundsOverLay(this.leftUp, n2, 0, 90.0, 180.0, true);
            this.dealLabelBoundsOverLay(this.leftDown, n2, 0, 180.0, 270.0, true);
            this.dealLabelBoundsOverLay(this.rightUp, n2, 0, 0.0, 90.0, false);
            this.dealLabelBoundsOverLay(this.rightDown, n2, 0, 270.0, 360.0, false);
        }
        this.dealInsideLabels(n, n2);
    }

    private void dealOutSideLabels(int n, int n2) {
        double d = 0.0;
        d = Math.max(d, this.dealEachArea(this.leftUp, n2));
        d = Math.max(d, this.dealEachArea(this.leftDown, n2));
        d = Math.max(d, this.dealEachArea(this.rightUp, n2));
        if ((d = Math.max(d, this.dealEachArea(this.rightDown, n2))) == 0.0) {
            return;
        }
        this.radiusPercent -= 0.05;
        if (this.radiusPercent >= 0.5) {
            this.deal4EachCategory(n, n2);
        }
    }

    private void dealLabelBoundsOverLay(ArrayList arrayList, int n, int n2, double d, double d2, boolean bl) {
        if (n2 >= 2) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        boolean bl2 = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            if (pointAndAngle.dataPoint4Pie.getDataLabel() == null || StringUtils.isEmpty((String)pointAndAngle.dataPoint4Pie.getDataLabel().text)) continue;
            Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
            if (generalPath.intersects(rectangle2D)) {
                if (this.adjustLabelBoundsY(generalPath, pointAndAngle, n, d, d2, bl)) continue;
                bl2 = false;
                break;
            }
            generalPath.append(rectangle2D, false);
        }
        if (bl2) {
            return;
        }
        this.dealLabelBoundsOverLay(arrayList, n, n2 + 1, d, d2, !bl);
    }

    protected boolean adjustLabelBoundsY(GeneralPath generalPath, PointAndAngle pointAndAngle, int n, double d, double d2, boolean bl) {
        Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
        double d3 = pointAndAngle.centerAngle;
        while (generalPath.intersects(rectangle2D)) {
            d3 = bl ? (d3 += 1.0) : (d3 -= 1.0);
            this.calculateLabelBoundsWithAngle(d3, pointAndAngle, n, rectangle2D);
        }
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        generalPath.append(rectangle2D, false);
        if (d3 < d || d3 > d2) {
            return false;
        }
        if (!this.isGuideLineShow(pointAndAngle.dataPoint4Pie) || !pointAndAngle.dataPoint4Pie.isShowLabel()) {
            return true;
        }
        GeneralPath generalPath2 = new GeneralPath();
        double d4 = 0.0;
        double d5 = 0.0;
        d4 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? rectangle2D.getX() + rectangle2D.getWidth() + 2.0 : rectangle2D.getX() - 2.0;
        d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        generalPath2.moveTo(d4, d5);
        d4 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d4 += 0.1 * this.radius) : (d4 -= 0.1 * this.radius);
        generalPath2.lineTo(d4, d5);
        Point2D point2D = this.getCenterPoint(pointAndAngle.dataPoint4Pie.getSeriesIndex(), pointAndAngle.dataPoint4Pie.getCategoryIndex());
        double d6 = this.radius + 2.0;
        d4 = point2D.getX() + d6 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d5 = point2D.getY() - d6 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath2.lineTo(d4, d5);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath2);
        return true;
    }

    private double dealEachArea(ArrayList arrayList, int n) {
        double d = this.getBounds().getX() + this.getBounds().getWidth();
        double d2 = this.getBounds().getX();
        double d3 = 0.0;
        this.checkPointsShowLabel(arrayList, n);
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            if (pointAndAngle.dataPoint4Pie.getDataLabel() == null) continue;
            this.dealOutsideLabelBoundsWhenNormal(double_, pointAndAngle, n);
            if (((RectangularShape)double_).getX() < d2) {
                d3 = d2 - ((RectangularShape)double_).getX();
            }
            if (!(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() > d)) continue;
            d3 = ((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() - d;
        }
        return d3;
    }

    private void checkPointsShowLabel(ArrayList arrayList, int n) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            TextGlyph textGlyph = pointAndAngle.dataPoint4Pie.getDataLabel();
            if (textGlyph == null || !StringUtils.isNotEmpty((String)textGlyph.getText())) continue;
            d += this.getLabelDim(pointAndAngle.dataPoint4Pie, n).getHeight();
        }
        if (d > this.radius) {
            this.removeAngleExtendMinPoint(arrayList);
            this.checkPointsShowLabel(arrayList, n);
        }
    }

    private void removeAngleExtendMinPoint(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle2 = (PointAndAngle)arrayList.get(i);
            if (!this.isSmallerThan(pointAndAngle2, pointAndAngle)) continue;
            pointAndAngle = pointAndAngle2;
        }
        pointAndAngle.dataPoint4Pie.setShowLabel(false);
        arrayList.remove(pointAndAngle);
    }

    protected boolean isSmallerThan(PointAndAngle pointAndAngle, PointAndAngle pointAndAngle2) {
        return pointAndAngle.getExtendAngle() < pointAndAngle2.getExtendAngle();
    }

    private void dealInsideLabels(int n, int n2) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            TextGlyph textGlyph;
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            if (dataPoint4Pie.isValueIsNull() || this.isOutsideLabel(i, n) || (textGlyph = dataPoint4Pie.getDataLabel()) == null || !StringUtils.isNotEmpty((String)textGlyph.getText())) continue;
            this.dealInsideLabelBounds(dataPoint4Pie, n2);
        }
    }

    protected void dealPlotStyle(int n, DataPoint4Pie dataPoint4Pie) {
        ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint4Pie.getDrawImpl();
        Arc2D.Double double_ = (Arc2D.Double)dataPoint4Pie.getShape();
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            if (n == 1) {
                double d;
                int n2 = dataPoint4Pie.getCategoryIndex();
                int n3 = dataPoint4Pie.getSeriesIndex();
                Point2D point2D = this.getCenterPoint(n3, n2);
                if (this.arc3DStyleBase == null) {
                    d = this.radius / 1.31;
                    this.arc3DStyleBase = new Arc3DStyleBase(this.getArcWithRadius(d));
                }
                chartStyle = new ArcPlane3DStyle(color, double_, double_, true);
                d = 0.1 * this.radius / 3.0;
                double d2 = this.getSeriesStartAngle(n2, n3);
                double d3 = this.getHalfAngle(d2, n3, n2);
                double d4 = this.radius / 1.2;
                double d5 = d * Math.cos(Math.toRadians(d3)) + point2D.getX() - d4;
                double d6 = -d * Math.sin(Math.toRadians(d3)) + point2D.getY() - d4;
                double_.setFrame(d5, d6, d4 * 2.0, d4 * 2.0);
            } else if (n == 2) {
                if (this.arcHighLightStyle == null) {
                    this.arcHighLightStyle = new ArcHighLightStyleBase(this.getArcWithRadius(this.radius));
                }
                chartStyle = new ArcTopDownShadeStyle(color, double_, double_, true);
                int n4 = dataPoint4Pie.getCategoryIndex();
                int n5 = dataPoint4Pie.getSeriesIndex();
                Point2D point2D = this.getCenterPoint(n5, n4);
                double d = this.radius / 1.2;
                double_.setFrame(point2D.getX() - d, point2D.getY() - d, d * 2.0, d * 2.0);
            } else if (n == 4) {
                chartStyle = new ArcTopDownShadeStyle(color, double_, double_, true);
            } else if (n == 5) {
                chartStyle = new ArcTransparentChartStyle(color, double_, true);
            }
            if (chartStyle != null) {
                if (this.isExistAttrByResult(dataPoint4Pie, AttrAlpha.class)) {
                    chartStyle.setAlpha(shapeGlyph.getAlpha());
                }
                if (this.isExistAttrByResult(dataPoint4Pie, AttrBorder.class)) {
                    chartStyle.setBorderWidth(shapeGlyph.getBorderStyle());
                    chartStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? Color.black : shapeGlyph.getBorderColor());
                }
                dataPoint4Pie.setDataPointStyle(chartStyle);
            }
        }
    }

    private Arc2D.Double getArcWithRadius(double d) {
        Point2D point2D = this.getCenterPoint(0, 0);
        return new Arc2D.Double(point2D.getX() - d, point2D.getY() - d, 2.0 * d, 2.0 * d, 0.0, 360.0, 0);
    }

    public int getSubType() {
        return 1;
    }

    protected ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint) {
        Shape shape = this.getArc2D(dataPoint);
        ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        return shapeGlyph;
    }

    protected Point2D getCenterPoint(int n, int n2) {
        double d = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d2 = (double)n2 * d + d / 2.0;
        return new Point2D.Double(d2, this.getBounds().getHeight() / 2.0);
    }

    protected Shape getArc2D(DataPoint dataPoint) {
        int n = dataPoint.getSeriesIndex();
        int n2 = dataPoint.getCategoryIndex();
        double d = this.getSeriesStartAngle(n2, n) % 360.0;
        Point2D point2D = this.getCenterPoint(n, n2);
        return this.getDataPointShape(point2D, d, this.radius, n, n2);
    }

    public void dealLeadLineSeries() {
        int n = this.getCategoryCount();
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i);
                if (dataPoint4Pie.isValueIsNull()) continue;
                ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint4Pie.getDrawImpl();
                double d = this.getHalfAngle(this.getSeriesStartAngle(i, j), j, i);
                if (shapeGlyph == null || shapeGlyph.getShape() == null || !(shapeGlyph.getShape() instanceof Arc2D)) continue;
                this.dealLeadLine((Arc2D)shapeGlyph.getShape(), dataPoint4Pie, d % 360.0);
            }
        }
    }

    protected double getPieDimension(int n) {
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangle2D.getWidth() / (double)this.getCategoryCount();
        double d2 = 0.0;
        d2 = d > rectangle2D.getHeight() ? rectangle2D.getHeight() / 1.2 : d / 1.2;
        d2 = this.deal4BestRad(d2, n);
        return d2;
    }

    protected double deal4BestRad(double d, int n) {
        DataPointLabelInfo dataPointLabelInfo = new DataPointLabelInfo();
        this.getConditionCollection().changeStyleConditionWithInfo(dataPointLabelInfo, this.getSeries(0).getDataPoint(n), null);
        if (dataPointLabelInfo != null && dataPointLabelInfo.getPosition() == 6) {
            d *= this.radiusPercent;
            if (this.getCategoryCount() > 1) {
                d *= 0.8;
            }
        }
        return d;
    }

    protected Shape getDataPointShape(Point2D point2D, double d, double d2, int n, int n2) {
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - d2, point2D.getY() - d2, 2.0 * d2, 2.0 * d2, d, this.getPercent(n, n2) * 360.0, 2);
        return double_;
    }

    protected void getSeriesCountWithQuadrant(int n) {
        this.clearList();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            if (this.getSeries(i).getDataPoint(n).isValueIsNull() || !this.isOutsideLabel(i, n)) continue;
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            double d = this.getHalfAngle(this.getSeriesStartAngle(n, i), i, n) % 360.0;
            DecimalFormat decimalFormat = new DecimalFormat("######0.00");
            if ((d = Double.valueOf(decimalFormat.format(d)).doubleValue()) >= 90.0 && d <= 180.0) {
                this.leftUp.add(new PointAndAngle(dataPoint4Pie, d));
                continue;
            }
            if (d > 180.0 && d <= 270.0) {
                this.leftDown.add(new PointAndAngle(dataPoint4Pie, d));
                continue;
            }
            if (d > 270.0 && d <= 360.0) {
                this.rightDown.add(new PointAndAngle(dataPoint4Pie, d));
                continue;
            }
            this.rightUp.add(new PointAndAngle(dataPoint4Pie, d));
        }
        this.sortList();
    }

    protected void dealLeadLine(Arc2D arc2D, DataPoint4Pie dataPoint4Pie, double d) {
        TextGlyph textGlyph;
        Rectangle2D rectangle2D;
        if (this.isGuideLineShow(dataPoint4Pie) && !arc2D.intersects(rectangle2D = (textGlyph = dataPoint4Pie.getDataLabel()).getBounds())) {
            Point2D point2D = Cylinder.getArcPoint(arc2D, d);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            this.setDataPointBoundsWithXYWH(dataPoint4Pie, d, rectangle2D, d2, d3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDataPointBoundsWithXYWH(DataPoint4Pie dataPoint4Pie, double d, Rectangle2D rectangle2D, double d2, double d3) {
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = this.bounds.getHeight() * 0.01;
        if (d2 < d4 - d8) {
            d6 = rectangle2D.getX() - d8;
            d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else if (d2 > d4 + rectangle2D.getWidth() + d8) {
            d6 = rectangle2D.getX() + rectangle2D.getWidth();
            d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d4 = rectangle2D.getX() + rectangle2D.getWidth() - d8;
            d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else if (this.isInTopAreaOrBottomArea(d)) {
            if (d3 > rectangle2D.getY() + rectangle2D.getHeight()) {
                d6 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d7 = rectangle2D.getY() + rectangle2D.getHeight() + d8;
                d4 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d5 = rectangle2D.getY() + rectangle2D.getHeight();
            } else {
                if (!(d3 < rectangle2D.getY())) return;
                d6 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d7 = rectangle2D.getY() - d8;
                d4 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                d5 = rectangle2D.getY();
            }
        } else if (d >= 100.0 && d <= 260.0) {
            d6 = rectangle2D.getX() + rectangle2D.getWidth();
            d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d4 = rectangle2D.getX() + rectangle2D.getWidth() - d8;
            d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        } else {
            d6 = rectangle2D.getX() + d8;
            d7 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            d4 = rectangle2D.getX() + d8 * 2.0;
            d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        }
        this.makeSureLeadLinePath(dataPoint4Pie, d2, d3, d6, d7, d4, d5);
    }

    private boolean isInTopAreaOrBottomArea(double d) {
        return d > 80.0 && d < 100.0 || d > 260.0 && d < 280.0;
    }

    private void makeSureLeadLinePath(DataPoint4Pie dataPoint4Pie, double d, double d2, double d3, double d4, double d5, double d6) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d, (float)d2);
        generalPath.curveTo((float)d3, (float)d4, (float)(d + d5) / 2.0f, (float)(d2 + d6) / 2.0f, (float)d5, (float)d6);
        dataPoint4Pie.setLeadLine(generalPath);
    }

    protected boolean isGuideLineShow(DataPoint dataPoint) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return false;
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        String string = textGlyph.getText();
        return string != null && attrContents.isShowGuidLine() && textGlyph.getBounds() != null;
    }

    private Rectangle2D avoidCoverLabelBounds(GeneralPath generalPath, Rectangle2D rectangle2D, double d, double d2, double d3, double d4) {
        if (rectangle2D == null) {
            return null;
        }
        double d5 = d;
        this.whileTmp(generalPath, rectangle2D, d5, d3, d4, d2);
        if (!generalPath.intersects(rectangle2D)) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
            generalPath.append(double_, false);
            return double_;
        }
        return null;
    }

    private void whileTmp(GeneralPath generalPath, Rectangle2D rectangle2D, double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(rectangle2D);
        double d5 = 0.0;
        double d6 = 0.5;
        while (generalPath.intersects(rectangle2D)) {
            d += d6;
            if (d5 > 360.0) {
                rectangle2D.setRect(double_);
                break;
            }
            double d7 = d2 + d4 * Math.cos(Math.PI * d / 180.0);
            double d8 = d3 - d4 * Math.sin(Math.PI * d / 180.0);
            double d9 = 45.0;
            if (d > 90.0 && d < d9 + 180.0) {
                rectangle2D.setRect(d7 - rectangle2D.getWidth(), d8 - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            } else if (d >= d9 + 180.0 && d < 270.0) {
                rectangle2D.setRect(d7 - rectangle2D.getWidth(), d8 - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else if (d >= 270.0 && d < d9 + 270.0) {
                rectangle2D.setRect(d7, d8 - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                rectangle2D.setRect(d7, d8 - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            d5 += d6;
        }
    }

    public void drawShape4Series(Graphics graphics, int n) {
        DataPoint4Pie dataPoint4Pie;
        int n2;
        int n3;
        DataSeries dataSeries;
        int n4;
        super.drawShape4Series(graphics, n);
        int[] nArray = this.getDrawSequence();
        int n5 = this.getSeriesSize();
        for (n4 = 0; n4 < n5; ++n4) {
            dataSeries = this.getSeries(nArray[n4]);
            n3 = dataSeries.getDataPointCount();
            for (n2 = 0; n2 < n3; ++n2) {
                dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
                if (!dataPoint4Pie.isBorderDefault()) continue;
                dataPoint4Pie.drawOnlyBorder(graphics, n);
            }
        }
        n5 = this.getSeriesSize();
        for (n4 = 0; n4 < n5; ++n4) {
            dataSeries = this.getSeries(nArray[n4]);
            n3 = dataSeries.getDataPointCount();
            for (n2 = 0; n2 < n3; ++n2) {
                dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
                if (dataPoint4Pie.isBorderDefault()) continue;
                dataPoint4Pie.drawOnlyBorder(graphics, n);
            }
        }
    }

    protected double changeRadius(int n, int n2) {
        return this.radius * 1.3;
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            if (this.isOutsideLabel(dataPoint.getSeriesIndex(), dataPoint.getCategoryIndex())) {
                this.dealOutsideLabelBounds(dataPoint, n);
            } else {
                this.dealInsideLabelBounds(dataPoint, n);
            }
        }
    }

    protected boolean isOutsideLabel(int n, int n2) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, this.getSeries(n));
        return attrContents.getPosition() == 6 || attrContents.isShowGuidLine();
    }

    private void dealOutsideLabelBounds(DataPoint dataPoint, int n) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n2 = dataPoint.getCategoryIndex();
        int n3 = dataPoint.getSeriesIndex();
        double d = this.getSeriesStartAngle(n2, n3) % 360.0;
        double d2 = this.getHalfAngle(d, n3, n2) % 360.0;
        this.dealOutsideLabelBoundsWhenNormal(double_, new PointAndAngle((DataPoint4Pie)dataPoint, d2), n);
        dataPoint.getDataLabel().setBounds(double_);
    }

    protected void dealInsideLabelBounds(DataPoint dataPoint, int n) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n2 = dataPoint.getSeriesIndex();
        int n3 = dataPoint.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n2, n3);
        double d = this.getLabelDim(dataPoint, n).getHeight();
        double d2 = this.getLabelDim(dataPoint, n).getWidth();
        double d3 = 0.5;
        double d4 = this.changeRadius(n3, n2);
        TextGlyph textGlyph = dataPoint.getDataLabel();
        double d5 = this.getSeriesStartAngle(n3, n2) % 360.0;
        double d6 = this.getHalfAngle(d5, n2, n3) % 360.0;
        Shape shape = this.getDataPointShape(point2D, d5, d4, n2, n3);
        double d7 = d4 * Math.cos(Math.PI * d6 / 180.0);
        double d8 = d4 * Math.sin(Math.PI * d6 / 180.0);
        for (d3 = 0.5; d3 < 1.0; d3 += 0.1) {
            double d9 = point2D.getX() + d7 * d3;
            double d10 = point2D.getY() - d8 * d3;
            double d11 = d9 - d2 / 2.0;
            double d12 = d10 - d / 2.0;
            ((Rectangle2D)double_).setRect(d11, d12, d2, d);
            if (!this.isNotNeedMoveChangeLabelRadius(shape, double_)) continue;
            textGlyph.setBounds(double_);
            break;
        }
        if (d3 >= 0.9) {
            textGlyph.setBounds(null);
        }
    }

    protected boolean isNotNeedMoveChangeLabelRadius(Shape shape, Rectangle2D rectangle2D) {
        return shape == null ? false : shape.contains(rectangle2D);
    }

    private void dealOutsideLabelBoundsWhenNormal(Rectangle2D rectangle2D, PointAndAngle pointAndAngle, int n) {
        Point2D point2D = this.calculateLabelBoundsWithAngle(pointAndAngle.centerAngle, pointAndAngle, n, rectangle2D);
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        if (this.isGuideLineShow(pointAndAngle.dataPoint4Pie)) {
            this.dealWidthLine(point2D, pointAndAngle);
        }
    }

    protected Point2D calculateLabelBoundsWithAngle(double d, PointAndAngle pointAndAngle, int n, Rectangle2D rectangle2D) {
        int n2 = pointAndAngle.dataPoint4Pie.getSeriesIndex();
        int n3 = pointAndAngle.dataPoint4Pie.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n2, n3);
        Dimension2D dimension2D = this.getLabelDim(pointAndAngle.dataPoint4Pie, n);
        double d2 = dimension2D.getHeight();
        double d3 = dimension2D.getWidth();
        double d4 = this.plotStyle != 1 ? this.radius * 1.2 : this.radius;
        double d5 = point2D.getX() + d4 * Math.cos(Math.PI * d / 180.0);
        double d6 = point2D.getY() - d4 * Math.sin(Math.PI * d / 180.0);
        double d7 = (this.plotStyle != 1 ? this.radius : this.radius / 1.2) * 0.1 + 2.0;
        if (pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0) {
            rectangle2D.setRect(d5 - d7 - d3, d6 - d2 / 2.0, d3, d2);
        } else {
            rectangle2D.setRect(d5 + d7, d6 - d2 / 2.0, d3, d2);
        }
        return point2D;
    }

    protected void dealWidthLine(Point2D point2D, PointAndAngle pointAndAngle) {
        double d = this.plotStyle != 1 ? this.radius : this.radius / 1.2;
        GeneralPath generalPath = new GeneralPath();
        double d2 = d + 2.0;
        double d3 = point2D.getX() + d2 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        double d4 = point2D.getY() - d2 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.moveTo(d3, d4);
        d2 = d * 1.2;
        d3 = point2D.getX() + d2 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d4 = point2D.getY() - d2 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.lineTo(d3, d4);
        d3 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d3 -= d * 0.1) : (d3 += d * 0.1);
        generalPath.lineTo(d3, d4);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath);
    }

    private double getLabelMargin(int n, double d) {
        return Math.max((this.bounds.getHeight() / 2.0 - d * (double)n) / (double)(n + 1), 0.0);
    }

    protected Dimension2D getLabelDim(DataPoint dataPoint, int n) {
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty((String)dataPoint.getDataLabel().getText())) {
            return new Dimension(0, 0);
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n);
    }

    private Rectangle2D dealOutsideLabelBoundsWithLargeSeriesSize(Rectangle2D rectangle2D, double d, DataPoint dataPoint, int n) {
        int n2 = dataPoint.getCategoryIndex();
        Dimension2D dimension2D = this.getLabelDim(dataPoint, n);
        double d2 = dimension2D.getHeight();
        double d3 = dimension2D.getWidth();
        double d4 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d5 = (d4 - this.getPieDimension(n2)) / 2.0;
        double d6 = (d5 - this.maxLabelWidth) / 2.0;
        DecimalFormat decimalFormat = new DecimalFormat("######0.00");
        d = Double.valueOf(decimalFormat.format(d));
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d <= 180.0 && d >= 90.0) {
            d7 = this.getLabelMargin(this.leftUp.size(), d2);
            d8 = (d6 > 0.0 ? d5 - d6 - d3 : d4 * 0.01) + d4 * (double)n2;
            int n3 = this.leftUp.indexOf(new Double(d));
            d9 = (double)n3 * (d7 + d2) + d7;
            if (n3 >= 0 && n3 < this.leftUp.size()) {
                this.leftUp.set(n3, new Double(Double.MAX_VALUE));
            }
        } else if (d <= 270.0 && d > 180.0) {
            d7 = this.getLabelMargin(this.leftDown.size(), d2);
            d8 = (d6 > 0.0 ? d5 - d6 - d3 : d4 * 0.01) + d4 * (double)n2;
            int n4 = this.leftDown.indexOf(new Double(d));
            d9 = (double)n4 * (d7 + d2) + d7 + this.bounds.getHeight() / 2.0;
            if (n4 >= 0 && n4 < this.leftDown.size()) {
                this.leftDown.set(n4, new Double(Double.MAX_VALUE));
            }
        } else if (d <= 360.0 && d > 270.0) {
            d7 = this.getLabelMargin(this.rightDown.size(), d2);
            d8 = (d6 > 0.0 ? d5 + this.getPieDimension(n2) + d6 : d4 * 0.99 - d3) + d4 * (double)n2;
            int n5 = this.rightDown.indexOf(new Double(d));
            d9 = this.bounds.getHeight() - (double)n5 * (d2 + d7);
            if (n5 >= 0 && n5 < this.rightDown.size()) {
                this.rightDown.set(n5, new Double(Double.MAX_VALUE));
            }
        } else {
            d7 = this.getLabelMargin(this.rightUp.size(), d2);
            d8 = (d6 > 0.0 ? d5 + this.getPieDimension(n2) + d6 : d4 * 0.99 - d3) + d4 * (double)n2;
            int n6 = this.rightUp.indexOf(new Double(d));
            d9 = this.bounds.getHeight() / 2.0 - (double)n6 * (d2 + d7);
            if (n6 >= 0 && n6 < this.rightUp.size()) {
                this.rightUp.set(n6, new Double(Double.MAX_VALUE));
            }
        }
        rectangle2D.setRect(d8, d9, d3, d2);
        return rectangle2D;
    }

    protected double getMaxLabelWidth(int n, int n2) {
        double d = 0.0;
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataPoint dataPoint = this.getSeries(i).getDataPoint(n);
            AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
            TextAttr textAttr = attrContents.getTextAttr();
            if (textAttr == null || dataPoint.getDataLabel() == null) continue;
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n2);
            d = Math.max(d, dimension2D.getWidth());
        }
        return d;
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.arc3DStyleBase != null) {
            this.arc3DStyleBase.paintStyle(graphics);
        } else if (this.arcHighLightStyle != null) {
            this.arcHighLightStyle.paintStyle(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n);
    }

    public boolean equals(Object object) {
        return object instanceof PiePlotGlyph;
    }

    public String getPlotGlyphType() {
        return "PiePlotGlyph";
    }

    public String getChartType() {
        return "Pie";
    }

    public class PointAndAngle {
        public double centerAngle;
        public DataPoint4Pie dataPoint4Pie;

        public PointAndAngle(DataPoint4Pie dataPoint4Pie, double d) {
            this.dataPoint4Pie = dataPoint4Pie;
            this.centerAngle = d;
        }

        public double getExtendAngle() {
            Arc2D.Double double_ = (Arc2D.Double)this.dataPoint4Pie.getShape();
            if (double_ != null) {
                return double_.extent;
            }
            return 0.0;
        }

        public Arc2D.Double getArcWithRadius(double d) {
            Arc2D.Double double_ = (Arc2D.Double)this.dataPoint4Pie.getShape();
            if (double_ != null) {
                return null;
            }
            Point point = new Point((int)(double_.getX() + double_.getWidth() / 2.0), (int)(double_.getY() + double_.getHeight() / 2.0));
            return new Arc2D.Double(((Point2D)point).getX() - d, ((Point2D)point).getY() - d, 2.0 * d, 2.0 * d, double_.getAngleStart(), double_.getAngleExtent(), 0);
        }
    }
}

