/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Arc3DStyleBase;
import com.fr.chart.chartglyph.ArcHighLightStyleBase;
import com.fr.chart.chartglyph.ArcPlane3DStyle;
import com.fr.chart.chartglyph.ArcTopDownShadeStyle;
import com.fr.chart.chartglyph.ArcTransparentChartStyle;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DonutHighLightStyle;
import com.fr.chart.chartglyph.DonutPlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Donut2DPlotGlyph
extends DonutPlotGlyph {
    private static final long serialVersionUID = 44023787828180817L;
    private static final double TRYMAX = 8.0;
    private static final double THREED_BASE = 7.0;
    private static final double ROUND_ANGLE = 360.0;
    private Arc3DStyleBase arc3DStyleBase;
    private ArcHighLightStyleBase arcHighLightStyleBase;

    public void layoutDataSeriesGlyph(int n) {
        this.initArcValues();
        this.labelBounds.clear();
        int n2 = this.getCategoryCount();
        for (int i = 0; i < n2; ++i) {
            this.dealWithDataSeries(i, n);
        }
    }

    private void dealWithDataSeries(int n, int n2) {
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            if (dataPoint.isValueIsNull() || dataPoint.getValue() <= 0.0) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint, n, i);
            dataPoint.setDrawImpl(shapeGlyph);
            this.dealLabelBounds(dataPoint, n2);
            this.dealPlotStyle(this.plotStyle, dataPoint);
        }
    }

    private void dealPlotStyle(int n, DataPoint dataPoint) {
        ShapeGlyph shapeGlyph = (ShapeGlyph)dataPoint.getDrawImpl();
        Shape shape = dataPoint.getShape();
        Arc2D.Double double_ = this.getOuterArcShape(dataPoint.getCategoryIndex(), dataPoint.getSeriesIndex());
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            if (n == 1) {
                if (this.arc3DStyleBase == null) {
                    this.arc3DStyleBase = new Arc3DStyleBase(this.get3DStyleBaseShape(), this.getOuterArc());
                }
                chartStyle = new ArcPlane3DStyle(color, double_, shape, true, this.getCategoryCount(), this.radius);
            } else if (n == 2) {
                if (this.arcHighLightStyleBase == null) {
                    this.arcHighLightStyleBase = new ArcHighLightStyleBase(this.getArcHighlightShadow(), this.getArcGradientArc());
                }
                double d = this.radius - this.arcWidth * this.categoryGap / 2.0;
                chartStyle = new DonutHighLightStyle(color, d, this.centerPoint, shape);
            } else if (n == 4) {
                chartStyle = new ArcTopDownShadeStyle(color, double_, shape, true, this.getCategoryCount(), this.radius);
            } else if (n == 5) {
                chartStyle = new ArcTransparentChartStyle(color, shape, true);
            }
            if (chartStyle != null && this.isExistAttrByResult(dataPoint, AttrAlpha.class)) {
                chartStyle.setAlpha(shapeGlyph.getAlpha());
            }
            if (chartStyle != null && this.isExistAttrByResult(dataPoint, AttrBorder.class)) {
                chartStyle.setBorderWidth(shapeGlyph.getBorderStyle());
                chartStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? Color.black : shapeGlyph.getBorderColor());
            }
            if (chartStyle != null) {
                dataPoint.setDataPointStyle(chartStyle);
            }
        }
    }

    private Arc2D getArcWithRadius(double d) {
        return new Arc2D.Double(this.centerPoint.getX() - d, this.centerPoint.getY() - d, 2.0 * d, 2.0 * d, 0.0, 360.0, 0);
    }

    private Arc2D getArcHighlightShadow() {
        return this.getArcWithRadius(this.outerArcRadius - this.arcWidth * this.categoryGap / 2.0);
    }

    private Arc2D getArcGradientArc() {
        double d = this.innerRadius + this.arcWidth * this.categoryGap / 2.0;
        return this.getArcWithRadius(d);
    }

    private Arc2D getOuterArc() {
        double d = this.radius * (1.0 - this.innerRadiusPercent / 7.0);
        return this.getArcWithRadius(d);
    }

    private Shape get3DStyleBaseShape() {
        double d = this.radius * (1.0 - this.innerRadiusPercent / 7.0);
        double d2 = d - this.radius * (1.0 - this.innerRadiusPercent);
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d, this.centerPoint.getY() - d, 2.0 * d, 2.0 * d, 0.0, 360.0, 0);
        Arc2D.Double double_2 = new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 0.0, 360.0, 0);
        Area area = new Area(double_);
        area.subtract(new Area(double_2));
        return area;
    }

    private ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint, int n, int n2) {
        Shape shape = this.getArc2DPath(n, n2);
        ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        return shapeGlyph;
    }

    private Arc2D.Double getOuterArcShape(int n, int n2) {
        double d = this.getSeriesStartAngle(n, n2, false) % 360.0;
        double d2 = this.getActOuterRadius(n);
        double d3 = this.getPercent(n2, n) * (360.0 - this.getSeriesGapAngle(n, n2, false));
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 180.0 - d, -d3, 2);
        return double_;
    }

    private Shape getArc2DPath(int n, int n2) {
        double d = this.getSeriesStartAngle(n, n2, true) % 360.0;
        double d2 = this.getArcInnerRadius(n);
        double d3 = this.getPercent(n2, n) * (360.0 - this.getSeriesGapAngle(n, n2, true));
        double d4 = this.getSeriesStartAngle(n, n2, false) % 360.0;
        double d5 = this.getActOuterRadius(n);
        double d6 = this.getPercent(n2, n) * (360.0 - this.getSeriesGapAngle(n, n2, false));
        GeneralPath generalPath = new GeneralPath();
        Arc2D.Double double_ = new Arc2D.Double(this.centerPoint.getX() - d5, this.centerPoint.getY() - d5, 2.0 * d5, 2.0 * d5, 180.0 - d4, -d6, 0);
        Arc2D.Double double_2 = new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 180.0 - d - d3, d3, 0);
        generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
        generalPath.append(double_, true);
        generalPath.lineTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            int n2 = dataPoint.getSeriesIndex();
            int n3 = dataPoint.getCategoryIndex();
            double d = this.getSeriesStartAngle(n3, n2, true) % 360.0;
            double d2 = this.getPercent(n2, n3) * 360.0;
            double d3 = (d2 / 2.0 + d) % 360.0;
            double d4 = this.innerRadius + this.arcWidth * (double)n3 + this.arcWidth / 2.0;
            double d5 = this.centerPoint.getX() - d4 * Math.cos(d3 / 180.0 * Math.PI);
            double d6 = this.centerPoint.getY() - d4 * Math.sin(d3 / 180.0 * Math.PI);
            Dimension2D dimension2D = this.getLabelDim(dataPoint, n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5 - dimension2D.getWidth() / 2.0, d6 - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            if (this.isBlankBounds(double_)) {
                textGlyph.setBounds(double_);
                this.labelBounds.add(double_);
            } else {
                int n4 = 4;
                int n5 = 0;
                while ((double)n5 < 8.0) {
                    int n6 = (int)((double)n5 / 2.0) + 1;
                    n6 = n5 % 2 == 0 ? n4 - n6 : n4 + n6;
                    d3 = (d + (double)n6 * d2 / 8.0) % 360.0;
                    d5 = this.centerPoint.getX() - d4 * Math.cos(d3 / 180.0 * Math.PI);
                    d6 = this.centerPoint.getY() - d4 * Math.sin(d3 / 180.0 * Math.PI);
                    double_ = new Rectangle2D.Double(d5 - dimension2D.getWidth() / 2.0, d6 - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
                    if (this.isBlankBounds(double_)) {
                        textGlyph.setBounds(double_);
                        this.labelBounds.add(double_);
                        break;
                    }
                    ++n5;
                }
            }
        }
    }

    private boolean isBlankBounds(Rectangle2D rectangle2D) {
        boolean bl = true;
        for (int i = 0; i < this.labelBounds.size(); ++i) {
            if (!ChartUtils.rectangleOverlapped((Rectangle2D)this.labelBounds.get(i), rectangle2D)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.arc3DStyleBase != null) {
            this.arc3DStyleBase.paintStyle(graphics);
        } else if (this.arcHighLightStyleBase != null) {
            this.arcHighLightStyleBase.paintStyle(graphics);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n);
    }

    public String getPlotGlyphType() {
        return "Donut2DPlotGlyph";
    }

    protected double getSeriesStartAngle(int n, int n2, boolean bl) {
        double d = 135.0;
        double d2 = this.getSeriesGapAngle(n, n2, bl);
        double d3 = d2 / (double)this.getSeriesSize();
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d4 += this.getPercent(i, n) * (360.0 - d2);
        }
        return d += d4 + d3 * (double)n2 + d3 / 2.0;
    }

    protected double getSeriesGapAngle(int n, int n2, boolean bl) {
        int n3 = this.getNonzeroSeriesCount(n);
        double d = this.seriesGap;
        if (n3 <= 1) {
            d = 0.0;
        }
        double d2 = d * 2.0 * Math.PI * this.innerRadius;
        double d3 = bl ? this.getArcInnerRadius(n) : this.getActOuterRadius(n);
        return d2 / d3 * 360.0 / (Math.PI * 2);
    }

    private int getNonzeroSeriesCount(int n) {
        int n2 = 0;
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            if (dataPoint == null || !(dataPoint.getValue() > 0.0)) continue;
            ++n2;
        }
        return n2;
    }

    private Dimension2D getLabelDim(DataPoint dataPoint, int n) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n);
    }

    public boolean equals(Object object) {
        return object instanceof Donut2DPlotGlyph && super.equals(object);
    }

    public String getChartType() {
        return "Donut";
    }
}

