/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class CompositePiePlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = 8976370546122236609L;
    private static final double CIR_ANGLE = 360.0;
    private static final double PIE_ANGLE = 180.0;
    private static final double RIGHT_PO = 0.3;
    public static final double SMALLPERCENT_LABEL_RADIUS_COEFFICIENT = 0.7;
    public static final double SUB_CENTER_COEFFICIENT = 0.8;
    private List list = new ArrayList();
    private int subType = 1;
    protected double smallPercent = 0.05;

    public void setSubType(int n) {
        this.subType = n;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSmallPercent(double d) {
        this.smallPercent = d;
    }

    public void draw(Graphics graphics, int n) {
        super.draw(graphics, n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics.getColor();
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        graphics2D.setColor(new Color(125, 125, 125));
        for (int i = 0; i < this.list.size(); ++i) {
            GeneralPath generalPath = (GeneralPath)this.list.get(i);
            GraphHelper.draw((Graphics)graphics2D, (Shape)generalPath, (int)1);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        graphics2D.setColor(color);
    }

    public void layoutDataSeriesGlyph(int n) {
        this.list.clear();
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.initLabelData(i, n);
            this.dealWithDataSeries(i, n);
            GeneralPath generalPath = this.getLinePath(i);
            if (generalPath == null) continue;
            this.list.add(generalPath);
        }
        this.dealLabelBoundsInOrder();
    }

    protected double deal4BestRad(double d, int n) {
        return super.deal4BestRad(d, n) * 0.8;
    }

    protected double getSeriesStartAngle(int n, int n2) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n2).getDataPoint(n);
        boolean bl = dataPoint4Pie.getPercentValue() >= this.smallPercent || n2 == this.getSeriesSize() - 1;
        double d = this.getStartAngle(n2, n);
        for (int i = 0; i < n2; ++i) {
            DataPoint4Pie dataPoint4Pie2 = (DataPoint4Pie)this.getSeries(i).getDataPoint(n);
            if (bl) {
                if (!(dataPoint4Pie2.getPercentValue() >= this.smallPercent) && i != this.getSeriesSize() - 1) continue;
                d += this.getPercent(i, n) * 360.0;
                continue;
            }
            if (!(dataPoint4Pie2.getPercentValue() < this.smallPercent) || i == this.getSeriesSize() - 1) continue;
            d += this.getPercent(i, n) * 360.0;
        }
        return d;
    }

    protected double getStartAngle(int n, int n2) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n).getDataPoint(n2);
        if (dataPoint4Pie.getPercentValue() >= this.smallPercent || n == this.getSeriesSize() - 1) {
            return this.getPercent(this.getSeriesSize() - 1, n2) * 180.0;
        }
        return 90.0;
    }

    protected double getPercent(int n, int n2) {
        boolean bl = this.isMainPie(n, n2);
        double d = this.getTotalValue(n2, bl);
        if (d <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
        return Math.abs(dataPoint4Pie.getValue()) / d;
    }

    protected double getTotalValue(int n, boolean bl) {
        double d = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            double d2 = dataPoint4Pie.getPercentValue();
            if (bl) {
                if (!(d2 >= this.smallPercent) && i != this.getSeriesSize() - 1) continue;
                d += Math.abs(dataPoint4Pie.getValue());
                continue;
            }
            if (!(d2 < this.smallPercent) || i == this.getSeriesSize() - 1) continue;
            d += Math.abs(dataPoint4Pie.getValue());
        }
        return d;
    }

    protected double changeRadius(int n, int n2) {
        boolean bl = this.isMainPie(n2, n);
        return bl ? this.radius * 1.3 : this.radius * 0.7;
    }

    protected GeneralPath getLinePath(int n) {
        if (this.getSubType() == 2 && this.getPercent(this.getSeriesSize() - 1, n) > 0.0) {
            return this.getLinePath4PieSub(n);
        }
        if (this.getSubType() == 3 && this.getPercent(this.getSeriesSize() - 1, n) > 0.0) {
            return this.getLinePath4BarSub(n);
        }
        return null;
    }

    protected Point2D getCenterPoint(int n, int n2) {
        DataSeries dataSeries = this.getSeries(n);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
        if (dataPoint4Pie.isValueIsNull()) {
            return null;
        }
        double d = this.getBounds().getWidth() / (double)this.getCategoryCount();
        if (this.getSubType() == 2 || this.getSubType() == 3) {
            if (dataPoint4Pie.getPercentValue() < this.smallPercent && n != this.getSeriesSize() - 1) {
                double d2 = (double)n2 * d + d * 0.8;
                return new Point2D.Double(d2, this.getBounds().getHeight() / 2.0);
            }
            double d3 = (double)n2 * d + d * 0.3;
            return new Point2D.Double(d3, this.getBounds().getHeight() / 2.0);
        }
        return null;
    }

    protected boolean isOutsideLabel(int n, int n2) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, this.getSeries(n).getDataPoint(n2), null);
        return (attrContents.getPosition() == 6 || attrContents.isShowGuidLine()) && this.isMainPie(n, n2);
    }

    protected Shape getArc2D(DataPoint dataPoint) {
        int n = dataPoint.getSeriesIndex();
        int n2 = dataPoint.getCategoryIndex();
        double d = this.getSeriesStartAngle(n2, n) % 360.0;
        Point2D point2D = this.getCenterPoint(n, n2);
        if (!(dataPoint.getPercentValue() < this.smallPercent) || n == this.getSeriesSize() - 1) {
            return this.getDataPointShape(point2D, d, this.radius, n, n2);
        }
        if (this.getSubType() == 2) {
            return this.getDataPointShape(point2D, d, this.radius / 2.0, n, n2);
        }
        if (this.getSubType() == 3) {
            return this.get4PieBar(n, n2, point2D, this.radius / 2.0);
        }
        return null;
    }

    private Rectangle2D get4PieBar(int n, int n2, Point2D point2D, double d) {
        double d2 = 0.0;
        boolean bl = this.isMainPie(n, n2);
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.isMainPie(i, n2);
            if (bl != bl2) continue;
            double d3 = this.getPercent(i, n2);
            d2 += d3;
        }
        double d4 = this.getPercent(n, n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d / 2.0, point2D.getY() - d + d2 * 2.0 * d, d, d * 2.0 * d4);
        return double_;
    }

    private GeneralPath getLinePath4BarSub(int n) {
        Point2D point2D;
        GeneralPath generalPath = new GeneralPath();
        double d = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d2 = (double)n * d + d * 0.8;
        Point2D.Double double_ = new Point2D.Double(d2, this.getBounds().getHeight() / 2.0);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(this.getSeriesSize() - 1).getDataPoint(n);
        Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
        Point2D point2D2 = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getStartPoint() : arc2D.getEndPoint();
        Point2D point2D3 = point2D = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getEndPoint() : arc2D.getStartPoint();
        if (arc2D.getAngleExtent() >= 180.0) {
            Point2D.Double double_2 = new Point2D.Double(arc2D.getCenterX(), arc2D.getCenterY());
            double d3 = this.getAngle4Pie(double_2, new Point2D.Double(((Point2D)double_).getX() - this.radius / 2.0 / 2.0, ((Point2D)double_).getY() - this.radius / 2.0));
            point2D2 = new Point2D.Double(((Point2D)double_2).getX() + Math.cos(d3) * this.radius, ((Point2D)double_2).getY() - Math.sin(d3) * this.radius);
            point2D = new Point2D.Double(((Point2D)double_2).getX() + Math.cos(d3) * this.radius, ((Point2D)double_2).getY() + Math.sin(d3) * this.radius);
        }
        if (double_ != null) {
            generalPath.moveTo((float)(((Point2D)double_).getX() - this.radius / 2.0 / 2.0), (float)(((Point2D)double_).getY() - this.radius / 2.0));
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        }
        if (double_ != null) {
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)(((Point2D)double_).getX() - this.radius / 2.0 / 2.0), (float)(((Point2D)double_).getY() + this.radius / 2.0));
        }
        return generalPath;
    }

    private GeneralPath getLinePath4PieSub(int n) {
        GeneralPath generalPath = new GeneralPath();
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(this.getSeriesSize() - 1).getDataPoint(n);
        Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
        Point2D point2D = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getStartPoint() : arc2D.getEndPoint();
        Point2D point2D2 = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getEndPoint() : arc2D.getStartPoint();
        Point2D point2D3 = this.getPoint(n, true);
        Point2D point2D4 = this.getPoint(n, false);
        if (arc2D.getAngleExtent() >= 180.0) {
            Point2D.Double double_ = new Point2D.Double(arc2D.getCenterX(), arc2D.getCenterY());
            double d = this.getAngle4Pie(double_, point2D3);
            point2D = new Point2D.Double(((Point2D)double_).getX() + Math.cos(d) * this.radius, ((Point2D)double_).getY() - Math.sin(d) * this.radius);
            double d2 = this.getAngle4Pie(double_, point2D4);
            point2D2 = new Point2D.Double(((Point2D)double_).getX() + Math.cos(d2) * this.radius, ((Point2D)double_).getY() + Math.sin(d2) * this.radius);
        }
        if (point2D3 != null) {
            generalPath.moveTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        if (point2D4 != null) {
            generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        }
        return generalPath;
    }

    private double getAngle4Pie(Point2D point2D, Point2D point2D2) {
        double d = Math.abs(point2D.getX() - point2D2.getX());
        double d2 = Math.abs(point2D.getY() - point2D2.getY());
        double d3 = Math.atan(d2 / d);
        double d4 = Math.acos(this.radius * Math.sin(d3) / d2);
        return d3 + d4;
    }

    private Point2D getPoint(int n, boolean bl) {
        Point2D.Double double_ = null;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(i).getDataPoint(n);
            Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
            if (!(dataPoint4Pie.getPercentValue() < this.smallPercent) || i == this.getSeriesSize() - 1) continue;
            Rectangle2D rectangle2D = arc2D.getBounds2D();
            double d = rectangle2D.getY();
            if (!bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight();
            }
            double d2 = arc2D.getWidth() / 2.0;
            double d3 = arc2D.getCenterY();
            double d4 = arc2D.getCenterX();
            double d5 = (d3 - d) / d2;
            d5 = Math.min(1.0, d5);
            d5 = Math.max(-1.0, d5);
            double d6 = Math.asin(d5) * 180.0 / Math.PI;
            double d7 = d4 + d2 * Math.cos(Math.PI * d6 / 180.0);
            if (!this.isNewPoint(double_, bl, d)) continue;
            double_ = new Point2D.Double(d7, d);
        }
        return double_;
    }

    private boolean isNewPoint(Point2D point2D, boolean bl, double d) {
        return point2D == null || bl && d <= point2D.getY() || !bl && d >= point2D.getY();
    }

    private boolean isMainPie(int n, int n2) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n).getDataPoint(n2);
        return dataPoint4Pie.getPercentValue() >= this.smallPercent || n == this.getSeriesSize() - 1;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("subType", this.subType);
        jSONObject.put("smallPercent", this.smallPercent);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "CompositePiePlotGlyph";
    }

    public String getChartType() {
        return "CompositePie";
    }

    public String getSmallIconType() {
        return "Pie";
    }
}

