/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.Area3D;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Area3DPlotGlyph
extends CategoryPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = 823999902188932597L;
    private static final double HALF = 0.5;
    private Projection projection = new Projection();
    private int deep = -1;
    private int deepBase = -1;
    private double seriesIntervalPercent;

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setSeriesIntervalPercent(double d) {
        this.seriesIntervalPercent = d;
    }

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void set3DDeepBase(int n) {
        this.deepBase = n;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void layoutAxisGlyph(int n) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), true, n);
    }

    protected void resetClip(Graphics2D graphics2D) {
    }

    public void layoutDataSeriesGlyph(int n) {
        double d = this.getDeep();
        if (d == -1.0) {
            d = this.getProjection().projecteeDeep(this.getDeepBase());
        }
        Color[] colorArray = this.createColors4Series();
        this.layoutWithStacked(d, n, colorArray);
        this.dealLabelBoundsInOrder();
    }

    private void layoutWithStacked(double d, int n, Color[] colorArray) {
        double d2 = d / (1.0 + this.seriesIntervalPercent);
        double d3 = -this.seriesIntervalPercent * d2 * 0.5;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            int n2;
            DataSeries dataSeries = this.getSeries(i);
            Area3D area3D = new Area3D(d3, d2);
            dataSeries.setDrawImpl(area3D);
            area3D.setProjection(this.projection);
            area3D.setTopSize(this.getCategoryCount());
            if (i == 0) {
                area3D.setIsFirst(true);
            }
            this.getConditionCollection().changeStyleConditionWithInfo(area3D.getColorInfo(), dataSeries, colorArray);
            double[] dArray = new double[dataSeries.getDataPointCount()];
            for (n2 = 0; n2 < dataSeries.getDataPointCount(); ++n2) {
                DataPoint dataPoint = dataSeries.getDataPoint(n2);
                this.calculatePreValueWithStacked(area3D, dataPoint, dArray, d3, n2, i, n);
            }
            for (n2 = dArray.length - 1; n2 >= 0; --n2) {
                area3D.lineTo((float)this.getxAxisGlyph().getPoint2D(n2).getX(), (float)dArray[n2]);
            }
            area3D.closePath();
        }
    }

    private void calculatePreValueWithStacked(Area3D area3D, DataPoint dataPoint, double[] dArray, double d, int n, int n2, int n3) {
        double d2 = this.getDataPointPercentValue(n2, n);
        float f = (float)this.getxAxisGlyph().getPointInBounds(n).getX();
        double d3 = 0.0;
        double d4 = 0.0;
        d4 = this.getPrePercentValue(n2, n);
        d3 = this.getPrePercentValue(n2 - 1, n);
        float f2 = (float)(this.getyAxisGlyph().getBounds().getY() + (double)((float)this.getyAxisGlyph().getPointInBounds(d4).getY()));
        dArray[n] = this.getyAxisGlyph().getBounds().getY() + (double)((float)this.getyAxisGlyph().getPointInBounds(d3).getY());
        this.dealPointPath(dataPoint, area3D, f, f2, d, n);
        this.dealDataPointLabel(dataPoint, n3);
    }

    private double getPrePercentValue(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            d += Math.abs(dataSeries.getDataPoint(n2).getValue());
            if (i > n) continue;
            d2 += Math.abs(dataSeries.getDataPoint(n2).getValue());
        }
        if (!this.getyAxisGlyph().isPercentage()) {
            return d2;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return d2 / d;
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n);
    }

    private void dealPointPath(DataPoint dataPoint, Area3D area3D, float f, float f2, double d, int n) {
        if (n == 0) {
            area3D.moveTo(f, f2);
        } else {
            area3D.lineTo(f, f2);
        }
        Point2D point2D = this.projection.projectee(f, f2, d);
        dataPoint.setShape(new Arc2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0, 0.0, 360.0, 2));
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw3DInfo(graphics, n);
        this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n);
        if (this.isStacked()) {
            int n2;
            int n3 = this.getSeriesSize();
            for (n2 = 0; n2 < n3; ++n2) {
                this.getSeries(n2).draw(graphics, n);
            }
            n3 = this.getSeriesSize();
            for (n2 = 0; n2 < n3; ++n2) {
                this.getSeries(n2).drawLabel(graphics, n);
            }
        } else {
            int n4;
            for (n4 = this.getSeriesSize() - 1; n4 >= 0; --n4) {
                this.getSeries(n4).draw(graphics, n);
            }
            for (n4 = this.getSeriesSize() - 1; n4 >= 0; --n4) {
                this.getSeries(n4).drawLabel(graphics, n);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public boolean equals(Object object) {
        return object instanceof Area3DPlotGlyph && super.equals(object) && ((Area3DPlotGlyph)object).deep == this.deep && ((Area3DPlotGlyph)object).seriesIntervalPercent == this.seriesIntervalPercent && ComparatorUtils.equals((Object)((Area3DPlotGlyph)object).projection, (Object)this.projection);
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("projection", (Object)this.projection.toJSONObject());
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        jSONObject.put("deep", this.deep);
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = "Area3DPlotGlyph";
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percent";
        }
        return string;
    }

    public String getPlotGlyphType() {
        return "Area3DPlotGlyph";
    }

    public String getChartType() {
        return "Area3D";
    }

    public String getSmallIconType() {
        return "Area";
    }
}

