/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class MapSingleLayerTableDefinition
extends TableDataDefinition {
    public static final String XML_TAG = "MapSingleLayerTableDefinition";
    private static final long serialVersionUID = -8537307090949351871L;
    private String areaName;
    private ArrayList list = new ArrayList();

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        MapChartData mapChartData = new MapChartData();
        this.createMapDataWithLayerIndex(mapChartData, dataModel);
        return mapChartData;
    }

    public void createMapDataWithLayerIndex(MapChartData mapChartData, DataModel dataModel) {
        int n = this.list.size();
        if (StringUtils.isNotEmpty((String)this.getAreaName()) && n > 0) {
            try {
                int n2 = dataModel.getRowCount();
                int n3 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.getAreaName());
                if (n3 != -1) {
                    for (int i = 0; i < n2; ++i) {
                        Object object = dataModel.getValueAt(i, n3);
                        if (object == null || !StringUtils.isNotEmpty((String)Utils.objectToString((Object)object))) continue;
                        MapAreaValue mapAreaValue = new MapAreaValue();
                        mapChartData.addMapData(Utils.objectToString((Object)object), mapAreaValue);
                        for (int j = 0; j < n; ++j) {
                            SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(j);
                            if (seriesDefinition == null || seriesDefinition.getValue() == null) continue;
                            String string = Utils.objectToString((Object)seriesDefinition.getSeriesName());
                            String string2 = Utils.objectToString((Object)seriesDefinition.getValue());
                            int n4 = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)string2);
                            if (n4 == -1) continue;
                            Object object2 = dataModel.getValueAt(i, n4);
                            Number number = Utils.objectToNumber((Object)object2, (boolean)false);
                            mapAreaValue.addTitleValue(new MapTitleValue(string, number.doubleValue()));
                        }
                    }
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error("Some error In Map Table Data");
            }
        }
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        jSONObject.put("areaName", (Object)this.areaName);
        if (this.list != null) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.list.size(); ++i) {
                jSONArray.put((Object)((SeriesDefinition)this.list.get(i)).toJSONObject());
            }
            jSONObject.put("titleValues", (Object)jSONArray);
        }
        return jSONObject;
    }

    public String getDataDefinitionType() {
        return "MapSingleLayerDefinition";
    }

    public void setAreaName(String string) {
        this.areaName = string;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void addTitleValue(SeriesDefinition seriesDefinition) {
        this.list.add(seriesDefinition);
    }

    public void clearTitleValue() {
        this.list.clear();
    }

    public int getTitleValueSize() {
        return this.list.size();
    }

    public SeriesDefinition getTitleValueWithIndex(int n) {
        if (n >= 0 && n < this.list.size()) {
            return (SeriesDefinition)this.list.get(n);
        }
        return null;
    }

    public ArrayList getSeriesDefinitionList() {
        return this.list;
    }

    public boolean equals(Object object) {
        return object instanceof MapSingleLayerTableDefinition && ComparatorUtils.equals((String)((MapSingleLayerTableDefinition)object).areaName, (String)this.areaName) && ComparatorUtils.equals((Object)this.list, (Object)((MapSingleLayerTableDefinition)object).getSeriesDefinitionList()) && super.equals(object);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("AreaName");
        xMLPrintWriter.attr("areaName", this.getAreaName());
        xMLPrintWriter.end();
        int n = this.list.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                xMLPrintWriter.startTAG("DefinitionList");
                SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i);
                seriesDefinition.writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"AreaName", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MapSingleLayerTableDefinition.this.setAreaName(xMLableReader.getAttrAsString("areaName", ""));
                    }
                });
            } else if (ComparatorUtils.equals((String)"DefinitionList", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject((XMLReadable)new SeriesDefinition());
                        MapSingleLayerTableDefinition.this.addTitleValue(seriesDefinition);
                    }
                });
            } else if (ComparatorUtils.equals((String)"SeriesDefinition", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject((XMLReadable)new SeriesDefinition());
                        MapSingleLayerTableDefinition.this.setAreaName(Utils.objectToString((Object)seriesDefinition.getSeriesName()));
                        seriesDefinition.setSeriesName(Inter.getLocText((String)"Chart-Use_Value"));
                        MapSingleLayerTableDefinition.this.addTitleValue(seriesDefinition);
                    }
                });
            }
        }
    }
}

