/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.AttrCurveLine;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class AttrAreaSeries
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrAreaSeries";
    private ChartAxisPosition axisPosition = ChartAxisPosition.AXIS_RIGHT;
    private boolean isCurve = false;
    private String markerType = "NullMarker";

    public AttrAreaSeries(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public AttrAreaSeries() {
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.setCurve(xMLableReader.getAttrAsBoolean("isCurve", false));
            this.setMarkerType(xMLableReader.getAttrAsString("markerType", "NullMarker"));
            this.setAxisPosition(ChartAxisPosition.parse(xMLableReader.getAttrAsString("axisPosition", ChartAxisPosition.AXIS_LEFT.getAxisPosition())));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("isCurve", this.isCurve).attr("markerType", this.markerType).attr("axisPosition", this.axisPosition.getAxisPosition()).end();
        xMLPrintWriter.end();
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(String string) {
        this.markerType = string;
    }

    public ChartAxisPosition getAxisPosition() {
        return this.axisPosition;
    }

    public void setAxisPosition(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public void addNormalAttrConditions(List list) {
        list.add(new AttrMarkerType(this.markerType));
        list.add(new AttrCurveLine(this.isCurve));
    }

    public boolean equals(Object object) {
        return object instanceof AttrAreaSeries && ((AttrAreaSeries)object).isCurve == this.isCurve && ComparatorUtils.equals((String)((AttrAreaSeries)object).markerType, (String)this.markerType) && ComparatorUtils.equals((Object)((Object)((AttrAreaSeries)object).axisPosition), (Object)((Object)this.axisPosition));
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isCurve", this.isCurve);
        jSONObject.put("markerType", (Object)this.markerType);
        jSONObject.put("axisPosition", (Object)this.axisPosition.getAxisPosition());
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

