/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int MAXVCLEN = 255;
    private String value;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        this.setIfxType(13);
        this.value = string;
        if (this.value == null) {
            this.nullify();
            return;
        }
        this.unnullify();
    }

    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return JavaToIfxType.JavaToIfxChar(this.value, string);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public byte[] toIfxTuple() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return JavaToIfxType.JavaToIfxVarChar(this.value, string, this.encodedLength);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        try {
            int n = byArray[0] & 0xFF;
            String string = this.conn.getdbEncoding();
            if (n == 0) {
                this.value = new String("");
                this.unnullify();
                return;
            }
            if (n == 1 && byArray[1] == 0) {
                this.value = null;
                this.nullify();
                return;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            this.value = IfxToJavaType.IfxToJavaChar(byArray2, (short)0, string);
            this.unnullify();
            return;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        this.clearWarning();
        String string2 = string.trim();
        this.value = string2.length() > 255 ? string2.substring(0, 255) : string2;
        this.unnullify();
    }

    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.value);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return by;
    }

    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
            return;
        }
        this.fromByte((byte)by);
    }

    public void fromByte(byte by) throws SQLException {
        this.value = String.valueOf(by);
        this.unnullify();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
            return;
        }
        this.fromBoolean((boolean)bl);
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? "true" : "false";
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Integer n = new Integer(this.value);
            return n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
            return;
        }
        this.fromInt((int)n);
    }

    public void fromInt(int n) throws SQLException {
        this.value = Integer.toString(n);
        this.unnullify();
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s = new Short(this.value);
            return s;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
            return;
        }
        this.fromShort((short)s);
    }

    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
            return;
        }
        this.fromLong((long)l);
    }

    public void fromLong(long l) throws SQLException {
        this.value = String.valueOf(l);
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f = Float.valueOf(this.value);
        return f.floatValue();
    }

    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
            return;
        }
        this.fromFloat(f.floatValue());
    }

    public void fromFloat(float f) throws SQLException {
        this.value = String.valueOf(f);
        this.unnullify();
    }

    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return date;
    }

    public void fromDate(Date date) throws SQLException {
        if (date == null) {
            this.nullify();
            return;
        }
        this.value = dateUtil.convertDateStr(date, this.conn);
        this.unnullify();
    }

    public Time toTime() throws SQLException {
        Time time;
        if (this.isNull()) {
            return null;
        }
        try {
            time = Time.valueOf(this.value);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return time;
    }

    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
            return;
        }
        this.value = time.toString();
        this.unnullify();
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            timestamp = Timestamp.valueOf(this.value);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
            return;
        }
        this.value = timestamp.toString();
        this.unnullify();
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d = Double.valueOf(this.value);
        return d;
    }

    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
            return;
        }
        this.fromDouble((double)d);
    }

    public void fromDouble(double d) throws SQLException {
        this.value = String.valueOf(d);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
            return;
        }
        this.value = bigDecimal.toString();
        this.unnullify();
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxVarChar.value);
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        byte[] byArray = this.value.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream != null) {
            if (n == 0) {
                this.value = "";
                return;
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            try {
                int n3;
                do {
                    n3 = inputStream.read(byArray, n2, n);
                    n2 += n3;
                } while ((n -= n3) > 0);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
            this.value = new String(byArray);
        }
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }
}

