/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.memoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class IfxSqli
implements IfxProtocol {
    IfxResultSetMetaData desc;
    private FileOutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileAmount;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short tupleSize;
    private short statementID;
    private short statementType;
    private IfxSqliConnect conn;
    private Trace trace;
    private Trace protoTrace;
    private String dbEncoding;
    private long serial8Inserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean cursorOpen = false;
    private boolean typeSent = false;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private String sqlerrm;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort;
    private boolean OpenDBStmt = false;
    private String serverVersion;
    private Vector offsetVector = new Vector();
    private int totalTupleSize;
    private int curOffset;
    private int totalTuples;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit = false;
    private int Tupid;
    private int fpHandle;
    private Vector fpRet;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    private final int INFX_BUFSIZE = 4096;
    private final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    private IfxRowColumn rowColumn;
    private IfxDataOutputStream os;
    private IfxDataInputStream is;
    private boolean SQ_CLOSERecvd = false;
    private boolean SQ_CLOSESent = false;
    private boolean first = true;
    private Vector DBList;

    public IfxSqli(IfxSqliConnect ifxSqliConnect) {
        this.conn = ifxSqliConnect;
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
    }

    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void clear() {
        this.serial8Inserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        this.sqlerrm = null;
        int n = 0;
        while (n < 10) {
            this.sqlerrd[n] = 0;
            if (n < 8) {
                this.serverWarningsString.setCharAt(n, ' ');
            }
            n = (short)(n + 1);
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.cursorOpen = false;
        this.tupleSize = 0;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void resetTuples() {
        this.offsetVector.removeAllElements();
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.totalTupleSize = 0;
        this.curOffset = 0;
        this.curRow = -1;
        this.totalTuples = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
            this.rowColumn = null;
        }
    }

    public void executeBegin() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendBegin() throws SQLException {
        try {
            this.os.writeSmallInt((short)35);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCommit() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.statementType != 56) {
            this.cursorOpen = false;
        }
    }

    private void sendCommit() throws SQLException {
        try {
            this.os.writeSmallInt((short)19);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeRollback() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.cursorOpen = false;
    }

    public void executeGetDBList() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    public Vector getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        try {
            this.os.writeSmallInt((short)26);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveDBList() throws SQLException {
        try {
            String string;
            this.DBList = new Vector();
            while ((string = new String(this.is.readChar(this.dbEncoding))).length() != 0) {
                boolean bl = false;
                int n = 0;
                while (n < this.DBList.size()) {
                    String string2 = (String)this.DBList.elementAt(n);
                    if (string.toUpperCase().compareTo(string2) < 0) {
                        this.DBList.insertElementAt(string, n);
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                this.DBList.insertElementAt(string, this.DBList.size());
            }
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendRollback() throws SQLException {
        try {
            this.os.writeSmallInt((short)20);
            this.os.writeSmallInt((short)0);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCommand(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (statement instanceof IfxPreparedStatement && ((IfxPreparedStatement)statement).usePut()) {
                this.sendPut((IfxPreparedStatement)statement);
            } else {
                this.sendCommand((IfxStatement)statement);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.SendCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendCommand(IfxStatement ifxStatement) throws SQLException {
        if (ifxStatement instanceof IfxPreparedStatement) {
            this.sendExecute(ifxStatement);
            return;
        }
        String string = ifxStatement.commandString;
        try {
            this.os.writeSmallInt((short)1);
            this.os.writeSmallInt((short)0);
            this.os.writeChar(string, this.dbEncoding);
            this.os.writeSmallInt((short)22);
            this.os.writeSmallInt((short)7);
            this.os.writeSmallInt((short)11);
            this.isReleased = true;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendBind(IfxPreparedStatement ifxPreparedStatement) throws SQLException {
        this.sendBind(ifxPreparedStatement.getVector(), ifxPreparedStatement.inputvals);
    }

    private void sendBind(Vector vector, int n) throws SQLException {
        int n2 = 0;
        try {
            this.os.writeSmallInt((short)5);
            this.os.writeSmallInt((short)n);
            int n3 = 0;
            while (n3 < n) {
                Object object;
                IfxObject ifxObject = (IfxObject)vector.elementAt(n3);
                short s = (short)ifxObject.getIfxType();
                if (s == 11 || s == 12) {
                    if (((IfxBlob)ifxObject).isIfxTextType()) {
                        s = 12;
                    }
                    if (!ifxObject.isNull()) {
                        ++n2;
                    }
                }
                this.os.writeSmallInt(s);
                if (this.conn.isUSVER() && s >= 18) {
                    object = null;
                    String string = null;
                    object = ifxObject.getExtendedOwner();
                    string = ifxObject.getExtendedTypeName();
                    if (object == null) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeChar((String)object);
                    }
                    this.os.writeChar(string);
                }
                if (ifxObject.isNull()) {
                    this.os.writeSmallInt((short)-1);
                    this.os.writeSmallInt((short)0);
                } else {
                    this.os.writeSmallInt((short)0);
                    short s2 = ifxObject.getEncodedLength();
                    this.os.writeSmallInt(s2);
                    object = ifxObject.toIfx();
                    this.os.writePadded((byte[])object);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (n2 > 0) {
            this.sendBlob(vector, n2, n);
        }
    }

    public void executePrepare(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)statement);
            this.receiveMessage();
            ((IfxStatement)statement).setStatementType(this.statementType);
            if (this.desc != null) {
                this.desc.parseSetTableName(((IfxStatement)statement).commandString);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendPrepare(IfxStatement ifxStatement) throws SQLException {
        String string = ifxStatement.commandString;
        try {
            this.os.writeSmallInt((short)2);
            this.os.writeSmallInt((short)ifxStatement.numqmarks);
            this.os.writeChar(string, this.dbEncoding);
            this.os.writeSmallInt((short)22);
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendStatementExecute(IfxStatement ifxStatement) throws SQLException {
        this.sendExecute(ifxStatement);
        this.receiveMessage();
    }

    private void sendExecute(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (ifxStatement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                if (ifxPreparedStatement.inputvals != ifxPreparedStatement.getqmarks()) {
                    throw IfxErrMsg.getSQLException(-79749, this.conn);
                }
                if (ifxPreparedStatement.inputvals > 0) {
                    this.sendBind(ifxPreparedStatement.getVector(), ifxPreparedStatement.inputvals);
                }
            }
            this.os.writeSmallInt((short)7);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeStatementQuery(Statement statement) throws SQLException {
        this.executeStatementQuery(statement, false, null);
    }

    public void executeStatementQuery(Statement statement, boolean bl) throws SQLException {
        this.executeStatementQuery(statement, bl, null);
    }

    public void executeStatementQuery(Statement statement, boolean bl, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && n > 0) {
            try {
                this.sendStatementQuery((IfxStatement)statement, bl, (IfxResultSetMetaData)resultSetMetaData);
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendStatementQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.sendQuery(ifxStatement, bl, ifxResultSetMetaData);
        if (ifxStatement.getResultSetType() == 1003) {
            if (this.desc.hasVariableLengthColumns) {
                this.receiveMessage();
            }
            this.sendFetch(this.desc.hasVariableLengthColumns, this.desc);
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData ifxResultSetMetaData, short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            int n = 1;
            while (n <= this.desc.getColumnCount()) {
                IfxResultSetMetaData ifxResultSetMetaData2;
                if (ifxResultSetMetaData != null && ifxResultSetMetaData.getColumnCount() >= n && ifxResultSetMetaData.getIfxColumnType(n) != -99) {
                    ifxResultSetMetaData2 = ifxResultSetMetaData;
                    this.desc.setIfxColumnType(n, ifxResultSetMetaData.getIfxColumnType(n));
                    this.desc.setExtendedName(n, ifxResultSetMetaData.getExtendedName(n));
                    this.desc.setColumnExtendedId(n, ifxResultSetMetaData.getColumnExtendedId(n));
                } else {
                    ifxResultSetMetaData2 = this.desc;
                }
                int n2 = ifxResultSetMetaData2.getIfxColumnType(n);
                boolean bl = ifxResultSetMetaData2.isVariableLengthType(n);
                if (bl) {
                    short s2 = ifxResultSetMetaData2.isDistinct(n) ? (short)ifxResultSetMetaData2.getSourceType(n) : (short)ifxResultSetMetaData2.getColumnExtendedId(n);
                    n2 = s2 == 3 ? 46 : (s2 == 4 ? 47 : (s2 == 1 ? 43 : (s2 == 5 ? 45 : 44)));
                }
                this.os.writeSmallInt((short)n2);
                if (bl) {
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedOwnerName(n));
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedName(n));
                }
                this.os.writeInt(ifxResultSetMetaData2.getEncodedLength(n));
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.getTupleBufferSize();
        try {
            int n;
            IfxPreparedStatement ifxPreparedStatement;
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)3);
            String string = ifxStatement.getCursorName();
            this.os.writeChar(string, this.dbEncoding);
            if (ifxStatement instanceof IfxPreparedStatement && !(ifxPreparedStatement = (IfxPreparedStatement)ifxStatement).usePut() && ifxPreparedStatement.inputvals > 0) {
                this.sendBind(ifxPreparedStatement.getVector(), ifxPreparedStatement.inputvals);
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (this.conn.getAutoFree() || ifxStatement.getAutoFree()) {
                this.os.writeSmallInt((short)108);
            }
            if ((n = ifxStatement.getResultSetType()) == 1004) {
                this.os.writeSmallInt((short)24);
            }
            if (bl) {
                this.os.writeSmallInt((short)43);
            }
            this.os.writeSmallInt((short)6);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
    }

    public void executeOpenDatabase(String string, int n) throws SQLException {
        if (string == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.os.writeSmallInt((short)36);
            this.os.writeChar(string);
            this.os.writeSmallInt((short)n);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
    }

    public void executeClose(Statement statement) throws SQLException {
        if (this.conn.SendCommit && !this.doneCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (this.cursorOpen) {
            if (!this.conn.lockSession()) {
                throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
            }
            this.cursorOpen = false;
            if (!this.SQ_CLOSERecvd) {
                try {
                    this.sendClose((IfxStatement)statement);
                    this.receiveMessage();
                }
                catch (SQLException sQLException) {
                    this.conn.unlockSession();
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.conn.unlockSession();
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
            }
            this.conn.unlockSession();
        }
        if (this.conn.getAutoFree() || ((IfxStatement)statement).getAutoFree()) {
            this.clearAll();
            return;
        }
        this.clear();
    }

    public void executeRelease(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.getAutoFree() || !((IfxStatement)statement).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)statement).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased) {
                    this.sendRelease((IfxStatement)statement);
                    this.receiveMessage();
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        this.conn.unlockSession();
        this.cursorOpen = false;
        this.clearAll();
    }

    void executeFetch() throws SQLException {
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetch(false, this.desc);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendFetch(boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        int n = this.getTupleBufferSize();
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (bl) {
                this.sendType(ifxResultSetMetaData, (short)1);
            }
            this.os.writeSmallInt((short)9);
            this.os.writeSmallInt((short)n);
            if (this.conn.isFetchArr()) {
                this.os.writeSmallInt((short)0);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, ifxResultSetMetaData, n);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
    }

    private void sendClose(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)10);
            this.SQ_CLOSESent = true;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendRelease(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)11);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCloseDatabase() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        String string = this.conn.getConnectionDbName();
        if (string != null && string.length() != 0) {
            return;
        }
        try {
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    public void executeExecute(Statement statement) throws SQLException {
        this.executeExecute(statement, null);
    }

    public void executeExecute(Statement statement, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        try {
            if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                this.sendStatementQuery((IfxStatement)statement, false, (IfxResultSetMetaData)resultSetMetaData);
            } else {
                IfxStatement ifxStatement = (IfxStatement)statement;
                this.sendExecute(ifxStatement);
                this.receiveMessage();
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen();
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
            return;
        }
        if (this.TxStmt == 2) {
            this.conn.setTxEndState();
            return;
        }
        if (this.conn.SendCommit && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void receiveMessage() throws SQLException {
        short s = 0;
        try {
            this.flip();
            do {
                s = this.is.readSmallInt();
                switch (s) {
                    case 56: {
                        this.sendExit();
                        break;
                    }
                    case 8: {
                        this.receiveDescribe();
                        break;
                    }
                    case 14: {
                        this.receiveTuple();
                        break;
                    }
                    case 25: {
                        this.receiveTupleId();
                        break;
                    }
                    case 15: {
                        this.receiveDone();
                        break;
                    }
                    case 39: {
                        this.receiveBlob();
                        break;
                    }
                    case 97: {
                        this.receiveLODATA();
                        break;
                    }
                    case 13: {
                        this.sqlerrm = null;
                        this.receiveError();
                        break;
                    }
                    case 55: {
                        this.receiveCost();
                        break;
                    }
                    case 94: {
                        this.receiveInsertDone();
                        break;
                    }
                    case 99: {
                        this.receiveXactstat();
                        break;
                    }
                    case 10: {
                        this.SQ_CLOSERecvd = true;
                        break;
                    }
                    case 81: {
                        this.receiveInfo();
                        break;
                    }
                    case 53: {
                        this.receiveVersion();
                        break;
                    }
                    case 101: {
                        this.fpHandle = this.is.readInt();
                        break;
                    }
                    case 103: {
                        this.receiveFastPath();
                        break;
                    }
                    case 98: {
                        this.receiveSQFILE();
                        break;
                    }
                    case 26: {
                        this.receiveDBList();
                        break;
                    }
                    default: {
                        throw IfxErrMsg.getSQLException(-408, this.conn);
                    }
                    case 12: 
                    case 18: 
                    case 73: 
                    case 86: 
                    case 104: 
                }
                if (s == 12) return;
            } while (s != 56);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
    }

    private void flip() throws SQLException {
        try {
            this.os.writeSmallInt((short)12);
            this.os.flush();
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendExit() throws SQLException {
        if (this.conn != null && !this.conn.isASF()) {
            this.conn.setDatabaseOpen(false, this.serverWarningsShort);
        }
        this.conn.close();
    }

    private void callsetDatabaseOpen() throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(n, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        short s = 0;
        int n = 0;
        String string = null;
        short[] sArray = null;
        try {
            this.statementType = this.is.readSmallInt();
            this.statementID = this.is.readSmallInt();
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
            this.tupleSize = this.is.readSmallInt();
            s = this.is.readSmallInt();
            this.desc = new IfxResultSetMetaData(s, this.conn);
            short s2 = this.is.readSmallInt();
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            if (s > 0) {
                sArray = new short[s];
                short s3 = 1;
                while (s3 <= s) {
                    short s4;
                    sArray[s3 - 1] = this.is.readSmallInt();
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnStartPosition(s3, n);
                    } else {
                        s4 = this.is.readSmallInt();
                        this.desc.setColumnStartPosition(s3, s4);
                    }
                    s4 = this.is.readSmallInt();
                    this.desc.setIfxColumnType(s3, s4);
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnExtendedId(s3, n);
                        String string2 = new String(this.is.readChar(this.dbEncoding));
                        this.desc.setExtendedOwnerName(s3, string2);
                        string2 = new String(this.is.readChar());
                        this.desc.setExtendedName(s3, string2);
                        s4 = this.is.readSmallInt();
                        this.desc.setReference(s3, s4);
                        s4 = this.is.readSmallInt();
                        this.desc.setAlignment(s3, s4);
                        n = this.is.readInt();
                        this.desc.setSourceType(s3, n);
                        n = this.is.readInt();
                        this.desc.setEncodedLength(s3, n);
                    } else {
                        s4 = this.is.readSmallInt();
                        this.desc.setEncodedLength(s3, s4);
                    }
                    s3 = (short)(s3 + 1);
                }
                this.desc.setTextByteColumnCount();
            }
            if (s2 > 0) {
                byte[] byArray = new byte[s2];
                this.is.readPadded(byArray);
                string = IfxToJavaType.IfxToJavaChar(byArray, (short)0, this.dbEncoding);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (string != null) {
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            short s5 = 0;
            while (s5 < s) {
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    this.desc.setColumnName(s5 + 1, string3);
                }
                s5 = (short)(s5 + 1);
            }
        }
        if (this.conn != null) {
            this.desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
    }

    void setSQLerrd(short s, int n) throws SQLException {
        try {
            this.sqlerrd[s] = n;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveInsertDone() throws SQLException {
        try {
            this.serial8Inserted = this.is.readLongInt();
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    private void receiveDone() throws SQLException {
        this.OpenDBStmt = false;
        try {
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            short s = this.is.readSmallInt();
            this.setWarnings(s, this.OpenDBStmt);
            int n = this.is.readInt();
            this.setSQLerrd((short)2, n);
            n = this.is.readInt();
            this.setSQLerrd((short)5, n);
            n = this.is.readInt();
            this.setSQLerrd((short)1, n);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    public int getSerialInsert() {
        return this.sqlerrd[1];
    }

    int getISAMCode() {
        return this.isamcode;
    }

    public int getNumberOfRowsProcessed() {
        return this.sqlerrd[2];
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    int getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    int getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        try {
            int n = this.is.readInt();
            this.setSQLerrd((short)0, n);
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveXactstat() throws SQLException {
        try {
            this.xcEvent = this.is.readSmallInt();
            this.xcNewLevel = this.is.readSmallInt();
            this.xcOldLevel = this.is.readSmallInt();
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        try {
            short s = this.is.readSmallInt();
            int n = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (n > 0) {
                this.rowColumn.readTuple(this.is, this.totalTupleSize, n);
                this.totalTupleSize += n;
                if (++this.totalTuples >= this.offsetVector.size()) {
                    this.offsetVector.setSize(this.totalTuples + 100);
                }
                this.offsetVector.setElementAt(new Integer(this.totalTupleSize), this.totalTuples);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void addWarning(String string, String string2) {
        if (this.warn == null) {
            if (string2 != null) {
                this.warn = IfxWarnMsg.getSQLWarning(string2, string, this.conn);
                return;
            }
            this.warn = IfxWarnMsg.getSQLWarning(string, this.conn);
            return;
        }
        if (string2 != null) {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string2, string, this.conn);
            this.warn.setNextWarning(sQLWarning);
            return;
        }
        SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string, this.conn);
        this.warn.setNextWarning(sQLWarning);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void setWarnings(short var1_1, boolean var2_2) {
        var3_3 = 0;
        this.SQLState = null;
        this.serverWarningsShort = var1_1;
        var4_4 = 1;
        while (var4_4 <= 6) {
            var3_3 = var1_1 & 1;
            if (var3_3 != 1) ** GOTO lbl40
            this.serverWarningsString.setCharAt(var4_4, 'W');
            switch (var4_4) {
                case 1: {
                    if (var2_2) {
                        this.addWarning(null, "01I01");
                        break;
                    }
                    this.addWarning(null, "01006");
                    break;
                }
                case 2: {
                    if (var2_2) {
                        this.addWarning(null, "01I03");
                        break;
                    }
                    this.addWarning(null, "01003");
                    break;
                }
                case 3: {
                    if (var2_2) {
                        this.addWarning(null, "01I04");
                        break;
                    }
                    this.addWarning(null, "01003");
                    break;
                }
                case 4: {
                    this.addWarning(null, "01I05");
                    break;
                }
                case 5: {
                    this.addWarning(null, "01I06");
                    break;
                }
                case 6: {
                    if (var2_2) {
                        this.addWarning(null, "01I10");
                        break;
                    }
                    this.addWarning(null, "01I11");
                    break;
                }
lbl40:
                // 1 sources

                this.serverWarningsString.setCharAt(var4_4, ' ');
                break;
            }
            var1_1 = (short)(var1_1 >> 1);
            var4_4 = (short)(var4_4 + 1);
        }
    }

    public void chainWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(sQLWarning);
                return;
            }
            this.warn = sQLWarning;
        }
    }

    public void clearWarnings() {
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.warn = null;
    }

    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receiveError() throws SQLException {
        try {
            this.sqlcode = this.is.readSmallInt();
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                this.is.readChar();
                this.errorDone();
            }
            this.isamcode = this.is.readSmallInt();
            this.setSQLerrd((short)1, this.isamcode);
            if (this.sqlcode == 0) {
                this.isamcode = 0;
            }
            short s = this.is.readSmallInt();
            this.setSQLerrd((short)4, s);
            if (this.sqlcode != -368) {
                this.sqlerrm = this.is.readChar(this.dbEncoding);
            }
            if (this.sqlcode == 0 && !this.conn.isUSVER()) {
                this.sqlcode = -407;
                this.errorDone();
            }
            if (this.sqlcode == 0 || this.sqlcode == -937) {
                byte[] byArray = new byte[5];
                this.is.readPadded(byArray);
                this.SQLState = IfxToJavaType.IfxToJavaChar(byArray, (short)0);
                this.message = this.is.readChar(this.dbEncoding);
            }
            this.errorDone();
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    void errorDone() throws SQLException {
        String string = this.conn.getclLocale();
        if (this.sqlcode == 100) {
            this.SQLState = IfxErrMsg.getSQLSTATE(100);
            this.message = IfxErrMsg.getMessage(36007, string);
        } else {
            this.gobbleSmallInts(1);
        }
        if (this.sqlcode == 0 || this.sqlcode == 100) {
            if (this.SQLState != null) {
                this.addWarning(this.message, this.SQLState);
            } else if (this.message != null) {
                this.addWarning(this.message, null);
            }
        } else {
            if (this.sqlerrm != null && this.sqlerrm.length() > 0) {
                if (this.isamcode != 0) {
                    throw new SQLException(String.valueOf(IfxMessage.getMessage(this.sqlcode, this.sqlerrm, string)) + "\n(" + this.isamcode + ")" + IfxMessage.getMessage(this.isamcode, string), IfxMessage.getSQLSTATE(this.sqlcode), this.sqlcode);
                }
                throw new SQLException(IfxMessage.getMessage(this.sqlcode, this.sqlerrm, string), IfxMessage.getSQLSTATE(this.sqlcode), this.sqlcode);
            }
            throw IfxErrMsg.getSQLException(this.sqlcode, this.isamcode, (IfxConnection)this.conn);
        }
        this.sqlerrm = null;
    }

    private void receiveTupleId() throws SQLException {
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
                return;
            }
            int n = this.Tupid;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    void executeInfo(short s) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(s);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendInfo(short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)81);
            if (s != 0) {
                this.os.writeSmallInt((short)1);
                this.os.writeSmallInt((short)0);
            }
            this.os.writeSmallInt((short)0);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveInfo() throws SQLException {
        try {
            short s;
            while ((s = this.is.readSmallInt()) > 0) {
                int n = this.is.readSmallInt();
                switch (s) {
                    case 2: {
                        if (n < 4) {
                            throw IfxErrMsg.getSQLException(-408, this.conn);
                        }
                        n -= 4;
                        break;
                    }
                    case 3: {
                        int n2;
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < n / 4) {
                            n2 = this.is.readInt();
                            n3 |= n2;
                            ++n4;
                        }
                        this.conn.setTypeList(n3);
                        break;
                    }
                    case 4: {
                        int n2;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < n / 4) {
                            n2 = this.is.readInt();
                            n4 |= n2;
                            ++n5;
                        }
                        this.conn.setCapList(n4);
                        break;
                    }
                    default: {
                        this.gobbleChars(n);
                    }
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeEnv(Properties properties) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(properties);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendEnv(Properties properties) throws SQLException {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        short s5 = 0;
        String string = null;
        String string2 = null;
        int n = 0;
        IfxDataOutputStream ifxDataOutputStream = this.conn.Ifxproto_send();
        if (!this.conn.isASF()) {
            return;
        }
        s = 4;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties.getProperty(string);
            s2 = (short)string.length();
            s3 = (short)string2.length();
            n = s2 & 1;
            if (n == 1) {
                s2 = (short)(s2 + 1);
            }
            if ((n = s3 & 1) == 1) {
                s3 = (short)(s3 + 1);
            }
            s = (short)(s + (s2 + s3 + 4));
            if (s2 > s4) {
                s4 = s2;
            }
            if (s3 <= s5) continue;
            s5 = s3;
        }
        s = (short)(s + 2);
        try {
            ifxDataOutputStream.writeSmallInt((short)81);
            ifxDataOutputStream.writeSmallInt((short)6);
            ifxDataOutputStream.writeSmallInt(s);
            ifxDataOutputStream.writeSmallInt(s4);
            ifxDataOutputStream.writeSmallInt(s5);
            Enumeration<?> enumeration2 = properties.propertyNames();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                string2 = properties.getProperty(string);
                ifxDataOutputStream.writeChar(string, this.dbEncoding);
                ifxDataOutputStream.writeChar(string2, this.dbEncoding);
            }
            ifxDataOutputStream.writeSmallInt((short)0);
            ifxDataOutputStream.writeSmallInt((short)0);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void gobbleChars(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            this.is.readPadded(byArray);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void gobbleSmallInts(int n) throws SQLException {
        try {
            int n2 = 0;
            while (n2 < n) {
                this.is.readSmallInt();
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeVersion() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendVersion() throws SQLException {
        try {
            this.os.writeSmallInt((short)53);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveVersion() throws SQLException {
        try {
            this.serverVersion = new String(this.is.readChar());
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize() {
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.tupleSize <= 2048 ? 4096 : (this.tupleSize <= 4096 ? 8192 : (int)this.tupleSize);
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.fetchBufSize > Short.MAX_VALUE ? Short.MAX_VALUE : this.conn.fetchBufSize;
        }
        return this.tupleBufferSize;
    }

    public boolean isResultSet() throws SQLException {
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && n > 0;
    }

    public boolean isCursorOpen() {
        return this.cursorOpen;
    }

    public int getTupleCount() {
        return this.totalTuples - (this.curRow + 1);
    }

    public boolean getaRow(int n, int n2, int n3, int n4) throws SQLException {
        if (n != 1000 && n2 != 1) {
            throw IfxErrMsg.getSQLException(-79751, this.conn);
        }
        int n5 = this.getTupleCount();
        if (this.first) {
            if (!this.SQ_CLOSERecvd && (n5 == 0 && this.totalTuples > 0 || n4 == 1)) {
                if (n4 == 1) {
                    this.executeScrollFetch(n3, n2);
                } else {
                    this.executeFetch();
                }
                n5 = this.getTupleCount();
            }
        } else {
            if (this.SQ_CLOSERecvd) {
                return false;
            }
            if (n5 == 0 && this.totalTuples > 0 || n4 == 1) {
                if (n4 == 1) {
                    this.executeScrollFetch(n3, n2);
                } else {
                    this.executeFetch();
                }
                n5 = this.getTupleCount();
            }
        }
        if (n5 == 0) {
            if (this.conn.SendCommit && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        this.curOffset = (Integer)this.offsetVector.elementAt(this.curRow);
        this.rowColumn.setOffsetInTuple(this.curOffset);
        return true;
    }

    public int getTupleSize() throws SQLException {
        return this.tupleSize;
    }

    public IfxObject getColumnInRow(int n) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(n);
    }

    public void loadColumnData(int n, IfxObject ifxObject) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(n, ifxObject);
    }

    private void sendBlob(Vector vector, int n, int n2) throws SQLException {
        try {
            this.os.writeSmallInt((short)41);
            this.os.writeSmallInt((short)n);
            this.os.flush();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        int n3 = 0;
        while (n3 < n2) {
            IfxObject ifxObject = (IfxObject)vector.elementAt(n3);
            short s = (short)ifxObject.getIfxType();
            if (s == 11 || s == 12) {
                IfxBlob ifxBlob = (IfxBlob)ifxObject;
                if (ifxBlob.isBlobByteType()) {
                    this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                } else {
                    this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                }
            }
            ++n3;
        }
    }

    private void sendBytesBlob(IfxDataOutputStream ifxDataOutputStream, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                if (n > 1024) {
                    ifxDataOutputStream.writeSmallInt((short)1024);
                    ifxDataOutputStream.writePadded(byArray, n2, 1024);
                    n -= 1024;
                    n2 += 1024;
                    continue;
                }
                ifxDataOutputStream.writeSmallInt((short)n);
                ifxDataOutputStream.writePadded(byArray, n2, n);
                n = 0;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)39);
            ifxDataOutputStream.writeSmallInt((short)0);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendStreamBlob(IfxDataOutputStream ifxDataOutputStream, InputStream inputStream, int n) throws SQLException {
        int n2 = n;
        byte[] byArray = new byte[1024];
        int n3 = 0;
        while (n2 > 0) {
            try {
                if (n2 > 1024) {
                    n3 = inputStream.read(byArray, 0, 1024);
                    if (n3 <= 0) break;
                    ifxDataOutputStream.writeSmallInt((short)39);
                    ifxDataOutputStream.writeSmallInt((short)n3);
                    ifxDataOutputStream.writePadded(byArray, 0, n3);
                    n2 -= n3;
                    continue;
                }
                n3 = inputStream.read(byArray, 0, n2);
                if (n3 <= 0) break;
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)n3);
                ifxDataOutputStream.writePadded(byArray, 0, n3);
                n2 -= n3;
            }
            catch (Exception exception) {
                break;
            }
        }
        if (inputStream instanceof IfxInputStream) {
            try {
                ifxDataOutputStream.flush();
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (n2 == 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)0);
                return;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)40);
        }
        catch (Exception exception) {}
        try {
            this.receiveMessage();
            return;
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
    }

    public void executeFetchBlob(IfxObject ifxObject) throws SQLException {
        int n = this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        IfxBlob ifxBlob = (IfxBlob)ifxObject;
        int n2 = ifxBlob.getBlobLength();
        if (n < 0 || n > 0 && n2 <= n) {
            try {
                this.BlobBuffer = memoryUtil.allocateMemory(n2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79753, exception.toString(), (IfxConnection)this.conn);
            }
            ifxBlob.setBlobBuffer(this.BlobBuffer);
            ifxBlob.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            try {
                this.BlobFd = new FileOutputStream(((IfxBlob)ifxObject).getBlobFileName());
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception exception) {
                if (n == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = memoryUtil.allocateMemory(n2);
                this.BlobFd = null;
                ifxBlob.setBlobBuffer(this.BlobBuffer);
                ifxBlob.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetchBlob((IfxBlob)ifxObject);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {}
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {}
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
    }

    private void sendFetchBlob(IfxBlob ifxBlob) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)38);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        try {
            this.os.writePadded(ifxBlob.toIfx());
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveBlob() throws SQLException {
        int n;
        short s;
        byte[] byArray = null;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        try {
            byArray = new byte[s];
            n = this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, n);
                this.BlobWriteOffset += n;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (n < s) {
            int n2 = 0;
            while (n < s) {
                try {
                    byArray = new byte[s - n];
                    n2 = this.is.readPadded(byArray);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(byArray, this.BlobWriteOffset, n2);
                        this.BlobWriteOffset += n2;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                n += n2;
            }
        }
    }

    private int blobDataWrite(byte[] byArray, int n, int n2) {
        if (this.BufferOrStream == 1) {
            try {
                this.BlobFd.write(byArray, 0, n2);
            }
            catch (Exception exception) {
                return 1;
            }
        } else if (n2 > 0) {
            System.arraycopy(byArray, 0, this.BlobBuffer, n, n2);
        }
        return 0;
    }

    public void executeScrollFetch(int n, int n2) throws SQLException {
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendScrollFetch(n, n2);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendScrollFetch(int n, int n2) throws SQLException {
        int n3 = this.getTupleBufferSize();
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (this.desc.hasVariableLengthColumns) {
                this.sendType(this.desc, (short)1);
            }
            this.os.writeSmallInt((short)23);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            this.os.writeSmallInt((short)n3);
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, this.desc, n3);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.cursorOpen = true;
    }

    public int getTupid() throws SQLException {
        return this.Tupid;
    }

    public Vector executeFastPath(String string, Vector vector, boolean bl) throws SQLException {
        if (string == null || !this.conn.isUSVER()) {
            return null;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        short s = this.xcNewLevel;
        try {
            this.getHandle(string);
            this.sendFastPath(this.fpHandle, vector);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
        return this.fpRet;
    }

    private void getHandle(String string) throws SQLException {
        Object v = this.conn.fpCache.get(string);
        if (v != null) {
            this.fpHandle = (Integer)v;
            return;
        }
        try {
            this.os.writeSmallInt((short)101);
            this.os.writeChar(string);
            this.os.writeSmallInt((short)0);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.fpCache.put(string, new Integer(this.fpHandle));
    }

    private void sendFastPath(int n, Vector vector) throws SQLException {
        int n2 = vector != null ? vector.size() : 0;
        try {
            this.os.writeSmallInt((short)102);
            this.os.writeInt(n);
            this.os.writeSmallInt((short)n2);
            this.os.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (n2 != 0) {
            this.sendBind(vector, n2);
        }
    }

    private void receiveFastPath() throws SQLException {
        this.fpRet = new Vector();
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        try {
            short s = this.is.readSmallInt();
            short s2 = 0;
            while (s2 < s) {
                int n = this.is.readSmallInt();
                if ((n & 0x800) > 0) {
                    ifxColumnInfo.IsDistinct = true;
                }
                ifxColumnInfo.SQLtype = n &= 0xFF;
                if (n >= 18 || ifxColumnInfo.IsDistinct) {
                    ifxColumnInfo.ExtendedOwner = new String(this.is.readChar());
                    ifxColumnInfo.ExtendedName = new String(this.is.readChar());
                }
                ifxColumnInfo.Nullable = true;
                short s3 = this.is.readSmallInt();
                IfxObject ifxObject = IfxValue.makeInstance(this.conn, ifxColumnInfo);
                if (s3 == -1) {
                    ifxObject.nullify();
                } else {
                    short s4 = this.is.readSmallInt();
                    switch (n) {
                        case 0: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 43: {
                            ifxObject.fromString(this.is.readChar(this.dbEncoding));
                            break;
                        }
                        case 2: 
                        case 6: {
                            ifxObject.fromInt(this.is.readInt());
                            break;
                        }
                        case 7: {
                            ifxObject.fromDate(this.is.readDate());
                            break;
                        }
                        case 1: {
                            ifxObject.fromShort(this.is.readSmallInt());
                            break;
                        }
                        case 17: 
                        case 18: {
                            ifxObject.fromLong(this.is.readLongInt());
                            break;
                        }
                        case 4: {
                            ifxObject.fromFloat(this.is.readReal(s4));
                            break;
                        }
                        case 3: {
                            ifxObject.fromDouble(this.is.readDouble(s4));
                            break;
                        }
                        case 5: 
                        case 8: {
                            ifxObject.fromDecimal(this.is.readDecimal(s4));
                            break;
                        }
                        case 14: {
                            ifxObject.fromTimestamp(this.is.readDateTime(s4));
                            break;
                        }
                        case 10: {
                            ifxObject.fromTimestamp(this.is.readDateTime(s4));
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 44: {
                            int n2 = this.is.readInt();
                            if (n2 <= 0) break;
                            byte[] byArray = new byte[n2];
                            this.is.readPadded(byArray);
                            ifxObject.fromBytes(byArray);
                        }
                    }
                    this.fpRet.addElement(ifxObject);
                }
                s2 = (short)(s2 + 1);
            }
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveHandle() throws IOException {
        this.fpHandle = this.is.readInt();
    }

    public int executeReadSmBlob(int n, byte[] byArray, int n2) throws SQLException {
        this.BlobBuffer = byArray;
        this.BlobRequestSize = n2;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData(n, n2);
    }

    public int executeReadSmBlob(int n, FileOutputStream fileOutputStream, int n2) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = n2;
        this.BlobFd = fileOutputStream;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData(n, n2);
    }

    private int doLoData(int n, int n2) throws SQLException {
        this.sendLoData((short)0, n, n2);
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        return this.amountRW;
    }

    public int executeWriteSmBlob(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        this.amountRW = 0;
        this.sendLoData((short)2, n, n2);
        while (n2 > 0) {
            try {
                n4 = n2 < 32000 ? n2 : 32000;
                this.os.writeSmallInt((short)n4);
                this.os.writePadded(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        this.receiveMessage();
        return this.amountRW;
    }

    public int executeWriteSmBlob(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2 = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        int n3 = n2;
        int n4 = 0;
        this.amountRW = 0;
        int n5 = 0;
        byte[] byArray = new byte[32000];
        boolean bl = false;
        this.sendLoData((short)2, n, n3);
        while (n3 > 0) {
            try {
                n4 = n3 < 32000 ? n3 : 32000;
                n5 = inputStream2.read(byArray, 0, n4);
                if (n5 <= 0) {
                    bl = true;
                    n5 = n4;
                }
                this.os.writeSmallInt((short)n5);
                this.os.writePadded(byArray, 0, n5);
                n3 -= n5;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        this.receiveMessage();
        if (bl) {
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
        return this.amountRW;
    }

    private void sendLoData(short s, int n, int n2) throws SQLException {
        try {
            this.os.writeSmallInt((short)97);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            this.os.writeSmallInt((short)32000);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short s = 0;
        int n = 0;
        try {
            s = this.is.readSmallInt();
            n = this.is.readInt();
        }
        catch (Exception exception) {}
        if (s == 2) {
            this.amountRW = n;
            return;
        }
        if (n < 1) {
            try {
                this.is.readSmallInt();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] byArray = null;
        if (this.BlobRequestSize > n) {
            this.BlobRequestSize = n;
        }
        short s2 = 0;
        while (this.BlobRequestSize > 0) {
            try {
                s2 = this.is.readSmallInt();
                if (s2 < 0) {
                    this.amountRW = -1;
                    return;
                }
                byArray = new byte[s2];
                this.is.readPadded(byArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, s2);
                this.BlobWriteOffset += s2;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += s2;
            this.BlobRequestSize -= s2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveSQFILE() throws SQLException {
        int n = -1;
        byte[] byArray = null;
        int n2 = -1;
        long l = 0L;
        int n3 = -1;
        int n4 = 0;
        try {
            n = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        switch (n) {
            case 0: {
                try {
                    short s = this.is.readSmallInt();
                    byte[] byArray2 = new byte[s];
                    this.is.readPadded(byArray2);
                    this.copyToFileName = new String(byArray2);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {}
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException nullPointerException) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0 && !this.copyToFileFd.exists()) {
                        this.copyToFileFd = null;
                        this.sendSQFILEError(2);
                        break;
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException securityException) {
                    throw IfxErrMsg.getSQLException(-79716, securityException.toString(), (IfxConnection)this.conn);
                }
            }
            case 2: {
                long l2;
                n3 = 0;
                long l3 = 0L;
                try {
                    n2 = this.is.readSmallInt();
                    l = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    l2 = this.loFile.length();
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > l2) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    byArray = new byte[n2];
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-406);
                    break;
                }
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                l = l == -1L ? l2 - (long)this.copyToFileOffset : (l2 - (long)this.copyToFileOffset < l ? l2 - (long)this.copyToFileOffset : l);
                try {
                    this.os.writeInt((int)l);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(29);
                    break;
                }
                int n5 = 0;
                try {
                    while (l > 0L) {
                        l3 = (long)n2 < l ? (long)n2 : l;
                        try {
                            n5 = this.loFile.read(byArray, 0, (int)l3);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)n5);
                        this.os.writePadded(byArray, 0, n5);
                        l -= (long)n5;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (l <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                n4 = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                }
                catch (Exception exception) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 2) != 0) {
                        this.loFile.seek(this.copyToFileOffset);
                    }
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(5);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        n3 = s;
                        if (s == 107) {
                            n2 = this.is.readSmallInt();
                            byte[] byArray3 = new byte[n2];
                            this.is.readPadded(byArray3);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(byArray3));
                                continue;
                            }
                            this.loFile.write(byArray3, 0, n2);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    n4 = 2;
                    break;
                }
                try {
                    if (n3 == 13) {
                        n4 = this.is.readSmallInt();
                    }
                    if (n4 != 0) {
                        this.sendSQFILEError(n4);
                        break;
                    }
                    long l4 = this.loFile.length();
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)l4);
                    break;
                }
                catch (IOException iOException) {
                    throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
                }
            }
            case 1: {
                try {
                    n3 = this.is.readSmallInt();
                }
                catch (IOException iOException) {
                    n3 = 0;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                try {
                    if (this.copyToFileFd == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        this.flip();
    }

    private void sendSQFILEError(int n) throws SQLException {
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)n);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            return;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement ifxPreparedStatement) throws SQLException {
        IfxResultSetMetaData ifxResultSetMetaData = (IfxResultSetMetaData)ifxPreparedStatement.getPutMetaData();
        try {
            if (!this.cursorOpen) {
                this.sendQuery(ifxPreparedStatement, false, null);
            } else {
                this.os.writeSmallInt((short)4);
                this.os.writeSmallInt(this.statementID);
            }
            if (!ifxResultSetMetaData.hasVariableLengthColumns && ifxResultSetMetaData.textByteColumnCount <= 0) {
                this.os.writeSmallInt((short)17);
                if (!this.conn.isUSVER()) {
                    this.os.writeSmallInt(this.tupleSize);
                } else {
                    this.os.writeInt(this.tupleSize);
                }
                this.os.writeSmallInt(ifxPreparedStatement.getBatchCount());
                byte[] byArray = ifxPreparedStatement.getAllRows();
                this.os.write(byArray);
                return;
            }
            if (ifxResultSetMetaData.hasVariableLengthColumns && !this.typeSent) {
                this.sendType(ifxPreparedStatement.putRsmd, (short)0);
                this.typeSent = true;
            }
            int n = 0;
            while (n < ifxPreparedStatement.getBatchCount()) {
                this.os.writeSmallInt((short)17);
                byte[] byArray = ifxPreparedStatement.getNextRow();
                if (!this.conn.isUSVER()) {
                    this.os.writeSmallInt((short)byArray.length);
                } else {
                    this.os.writeInt(byArray.length);
                }
                this.os.writeSmallInt((short)1);
                this.os.writePadded(byArray);
                int n2 = n * ifxResultSetMetaData.textByteColumnCount;
                while (n2 < n * ifxResultSetMetaData.textByteColumnCount + ifxResultSetMetaData.textByteColumnCount) {
                    IfxBlob ifxBlob = ifxPreparedStatement.getIfxBlobAt(n2);
                    if (ifxBlob != null) {
                        if (ifxBlob.isBlobByteType()) {
                            this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                        } else {
                            this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }
}

