/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDistinctInput;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinct
extends IfxObject {
    IfxObject data;
    private static final short NO_SCALE = -1;
    private IfxDistinctInput inputStream;
    private IfxDistinctOutput outputStream;

    IfxDistinct() throws SQLException {
    }

    public void fromObject(Object object) throws SQLException {
        this.fromObject(object, -1);
    }

    public void fromObject(Object object, int n) throws SQLException {
        this.checkObject();
        if (object == null || this.data == null) {
            this.nullify();
            return;
        }
        if (this.typeMap != null) {
            this.data.setTypeMap(this.typeMap);
        }
        if (this.outputStream == null) {
            this.outputStream = new IfxDistinctOutput(this.data);
        } else {
            this.outputStream.reset();
        }
        if (!(object instanceof IfmxSQLData)) {
            if (n == -1) {
                this.data.fromObject(object);
            } else {
                this.data.fromObject(object, n);
            }
        } else {
            ((IfmxSQLData)object).writeSQL(this.outputStream);
            String string = ((IfmxSQLData)object).getSQLTypeName();
            if (string != null) {
                this.setExtendedTypeName(string);
            }
        }
        this.unnullify();
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.data instanceof IfxObject) {
            Class clazz;
            if (this.typeMap == null || (clazz = (Class)this.typeMap.get(this.extendedName)) == null) {
                return this.data.toObject();
            }
            IfmxSQLData ifmxSQLData = null;
            try {
                ifmxSQLData = (IfmxSQLData)clazz.newInstance();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
            this.data.setTypeMap(this.typeMap);
            this.inputStream = new IfxDistinctInput(this.data);
            ifmxSQLData.readSQL(this.inputStream, this.extendedName);
            return ifmxSQLData;
        }
        throw IfxErrMsg.getSQLException(-79716, this.conn);
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.checkObject();
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        this.data.fromIfx(byArray);
        this.checkNull();
    }

    public void fromIfx(byte[] byArray, short s) throws SQLException {
        this.checkObject();
        IfxConnection ifxConnection = this.conn;
        int n = this.ifxType;
        this.data = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        this.data.fromIfx(byArray, s);
        this.checkNull();
    }

    public byte[] toIfx() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        if (this.data == null) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        if (this.ifxType >= 19 && this.ifxType != 40 && this.ifxType != 41 && this.ifxType != 43 && this.ifxType != 44 && this.ifxType != 45) {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
        return this.data.toIfxTuple();
    }

    private void checkNull() {
        if (this.data == null || this.data.isNull()) {
            this.writeTrace(99, "IfxDistinct: data is null");
            this.nullify();
            return;
        }
        this.writeTrace(99, "IfxDistinct: data is not null");
        this.unnullify();
    }

    private void checkObject() throws SQLException {
        if (this.data == null) {
            IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
            ifxColumnInfo.SQLtype = this.ifxType;
            ifxColumnInfo.ExtendedOwner = this.extendedOwner;
            ifxColumnInfo.ExtendedId = this.sourceType;
            ifxColumnInfo.ExtendedName = this.ifxType == 40 || this.ifxType == 41 || this.ifxType == 44 || this.ifxType == 19 || this.ifxType == 20 || this.ifxType == 21 || this.ifxType == 22 ? this.conn.getXnameByXid(ifxColumnInfo.ExtendedId) : this.extendedName;
            this.data = IfxValue.makeInstance(this.conn, ifxColumnInfo);
            if (this.data == null) {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            this.setIfxType(this.data.getIfxType());
        }
    }

    public int toInt() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toInt();
    }

    public void fromInt(int n) throws SQLException {
        this.checkObject();
        this.data.fromInt(n);
        this.checkNull();
    }

    public short toShort() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toShort();
    }

    public void fromShort(short s) throws SQLException {
        this.checkObject();
        this.data.fromShort(s);
        this.checkNull();
    }

    public String toString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    public void fromString(String string) throws SQLException {
        this.checkObject();
        this.data.fromString(string);
        this.checkNull();
    }

    public long toLong() throws SQLException {
        if (this.data == null) {
            return 0L;
        }
        return this.data.toLong();
    }

    public void fromLong(long l) throws SQLException {
        this.checkObject();
        this.data.fromLong(l);
        this.checkNull();
    }

    public void fromLong(Long l) throws SQLException {
        this.checkObject();
        this.data.fromLong(l);
        this.checkNull();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDecimal();
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(bigDecimal);
        this.checkNull();
    }

    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.checkObject();
        this.data.fromDecimal(bigDecimal, n);
        this.checkNull();
    }

    public byte toByte() throws SQLException {
        if (this.data == null) {
            return 0;
        }
        return this.data.toByte();
    }

    public void fromByte(Byte by) throws SQLException {
        this.checkObject();
        this.data.fromByte(by);
        this.checkNull();
    }

    public void fromByte(byte by) throws SQLException {
        this.checkObject();
        this.data.fromByte(by);
        this.checkNull();
    }

    public float toFloat() throws SQLException {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.toFloat();
    }

    public void fromFloat(Float f) throws SQLException {
        this.checkObject();
        this.data.fromFloat(f);
        this.checkNull();
    }

    public void fromFloat(float f) throws SQLException {
        this.checkObject();
        this.data.fromFloat(f);
        this.checkNull();
    }

    public double toDouble() throws SQLException {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.toDouble();
    }

    public void fromDouble(Double d) throws SQLException {
        this.checkObject();
        this.data.fromDouble(d);
        this.checkNull();
    }

    public void fromDouble(double d) throws SQLException {
        this.checkObject();
        this.data.fromDouble(d);
        this.checkNull();
    }

    public boolean toBoolean() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.data.toBoolean();
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(bl);
        this.checkNull();
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.checkObject();
        this.data.fromBoolean(bl);
        this.checkNull();
    }

    public Time toTime() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTime();
    }

    public void fromTime(Time time) throws SQLException {
        this.checkObject();
        this.data.fromTime(time);
        this.checkNull();
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toTimestamp();
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        this.checkObject();
        this.data.fromTimestamp(timestamp);
        this.checkNull();
    }

    public Date toDate() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toDate();
    }

    public void fromDate(Date date) throws SQLException {
        this.checkObject();
        this.data.fromDate(date);
        this.checkNull();
    }

    public InputStream toInputStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toInputStream();
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromInputStream(inputStream, n);
        this.checkNull();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toAsciiStream();
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromAsciiStream(inputStream, n);
        this.checkNull();
    }

    public InputStream toBinaryStream() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toBinaryStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.checkObject();
        this.data.fromBinaryStream(inputStream, n);
        this.checkNull();
    }

    public IntervalYM toIntervalYM() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalYM();
    }

    public void fromIntervalYM(IntervalYM intervalYM) throws SQLException {
        this.checkObject();
        this.data.fromIntervalYM(intervalYM);
        this.checkNull();
    }

    public IntervalDF toIntervalDF() throws SQLException {
        if (this.data == null) {
            return null;
        }
        return this.data.toIntervalDF();
    }

    public void fromIntervalDF(IntervalDF intervalDF) throws SQLException {
        this.checkObject();
        this.data.fromIntervalDF(intervalDF);
        this.checkNull();
    }
}

