/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends FilterInputStream {
    private InputStream is;
    private final int one = 1;
    private final short DEF_PREC = 0;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];

    public IfxDataInputStream(InputStream inputStream) {
        super(inputStream);
        this.is = inputStream;
    }

    public final int read() throws IOException {
        return this.is.read();
    }

    public final int read(byte[] byArray) throws IOException {
        return this.is.read(byArray);
    }

    public final byte readByte() throws IOException {
        int n = this.is.read();
        return (byte)n;
    }

    public final int readFully(byte[] byArray) throws IOException {
        return this.readFully(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    public final int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = this.is.read(byArray, n + n4, n2 - n4);
            if (n3 < 0) {
                throw new IOException();
            }
            n4 += n3;
        }
        return n4;
    }

    public final int readPadded(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = this.readFully(byArray, n, n2);
        if ((n2 & 1) >= 1) {
            this.is.read();
        }
        return n3;
    }

    public final int readPadded(byte[] byArray) throws IOException {
        int n = this.readFully(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return n;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = 0;
        while ((n2 += (int)this.is.skip(n - n2)) < n) {
        }
        return n;
    }

    public final int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf, (short)0);
    }

    public final String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (s < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaChar(byArray, (short)0);
    }

    public final String readChar(String string) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (s < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaChar(byArray, (short)0, string);
    }

    public final Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf, (short)0);
    }

    public final Timestamp readDateTime(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (s2 < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(byArray, s);
    }

    public final Interval readInterval(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (s2 < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaInterval(byArray, s);
    }

    public final BigDecimal readDecimal(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
        if (s2 < 0) {
            throw new IfxASFException(-408, "Cannot interpret the data sent by the server");
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(byArray, s);
    }

    public final double readDouble(short s) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf, s);
    }

    public final float readReal(short s) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf, s);
    }

    public final short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
    }

    public final short readShort() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf, (short)0);
    }

    public final long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf, (short)0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf, (short)0);
    }
}

