/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.RetryTimer;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;

public class RMSource
extends RMProvider {
    private static final RmLogger LOGGER = RmLogger.getLogger(RMSource.class);
    private static final RMSource RM_SOURCE_INSTANCE = new RMSource();
    private static final byte[] CREATE_SEQUENCE_PAYLOAD = "<sun:createSequence xmlns:sun=\"http://com.sun/createSequence\"/>".getBytes();
    private RetryTimer retryTimer;
    private Hashtable<String, ClientOutboundSequence> outboundMap = new Hashtable();
    private Hashtable<String, ClientInboundSequence> inboundMap = new Hashtable();

    public static RMSource getRMSource() {
        return RM_SOURCE_INSTANCE;
    }

    private RMSource() {
        this.retryTimer = new RetryTimer(this);
    }

    public synchronized void terminateSequence(ClientOutboundSequence seq) throws RMException {
        if (seq != null && this.outboundMap.keySet().contains(seq.getId())) {
            seq.disconnect();
            this.removeOutboundSequence(seq.getId());
        }
    }

    public synchronized void addOutboundSequence(ClientOutboundSequence seq) {
        LOGGER.fine(LocalizationMessages.WSRM_2011_ADDING_SEQUENCE_MESSAGE(seq.getId()));
        boolean firstSequence = this.outboundMap.isEmpty();
        this.outboundMap.put(seq.getId(), seq);
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        String iseqid = null;
        if (iseq != null && null != (iseqid = iseq.getId())) {
            this.inboundMap.put(iseqid, iseq);
        }
        if (firstSequence) {
            this.retryTimer.start();
        }
    }

    public synchronized void removeOutboundSequence(ClientOutboundSequence seq) {
        LOGGER.fine(LocalizationMessages.WSRM_2012_REMOVING_SEQUENCE_MESSAGE(seq.getId()));
        String id = seq.getId();
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        String iseqid = null;
        if (iseq != null && null != (iseqid = iseq.getId())) {
            this.inboundMap.remove(iseqid);
        }
        this.outboundMap.remove(id);
        if (this.outboundMap.isEmpty()) {
            this.retryTimer.stop();
        }
    }

    private void removeOutboundSequence(String id) {
        ClientOutboundSequence seq = this.outboundMap.get(id);
        if (seq == null) {
            throw LOGGER.logException(new IllegalArgumentException(LocalizationMessages.WSRM_2013_NO_SUCH_OUTBOUND_SEQUENCE(id)), Level.FINE);
        }
        this.removeOutboundSequence(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMaintenanceTasks() throws RMException {
        for (String key : this.outboundMap.keySet()) {
            ClientOutboundSequence seq;
            ClientOutboundSequence clientOutboundSequence = seq = this.outboundMap.get(key);
            synchronized (clientOutboundSequence) {
                seq.doMaintenanceTasks();
            }
        }
    }

    public ClientOutboundSequence createSequence(Service service, QName portName) {
        Dispatch<Source> dispatch = service.createDispatch(portName, Source.class, Service.Mode.PAYLOAD, new RespectBindingFeature());
        ByteArrayInputStream stream = new ByteArrayInputStream(CREATE_SEQUENCE_PAYLOAD);
        StreamSource source = new StreamSource(stream);
        try {
            dispatch.invoke(source);
        }
        catch (Exception e) {
            LOGGER.warning("Sending CreateSequence failed", e);
        }
        ClientOutboundSequence seq = (ClientOutboundSequence)dispatch.getRequestContext().get("com.sun.xml.ws.sequence");
        seq.setService(service);
        return seq;
    }

    public ClientOutboundSequence createSequence(Service service, QName portName, String sequenceID, String companionSequenceID) {
        ClientOutboundSequence seq = this.createSequence(service, portName);
        if (seq == null) {
            return null;
        }
        try {
            seq.disconnect(false);
        }
        catch (Exception e) {
            LOGGER.warning("Attempt to disconnect sequence [" + seq.getId() + "] failed with exception.", e);
        }
        seq.setId(sequenceID);
        ClientInboundSequence iseq = (ClientInboundSequence)seq.getInboundSequence();
        if (companionSequenceID != null) {
            if (iseq == null || iseq.getId() == null) {
                throw LOGGER.logException(new IllegalArgumentException(LocalizationMessages.WSRM_2014_NO_TWOWAY_OPERATION()), Level.FINE);
            }
            iseq.setId(companionSequenceID);
        } else if (iseq != null && iseq.getId() != null) {
            throw LOGGER.logException(new IllegalArgumentException(LocalizationMessages.WSRM_2015_NO_INBOUND_SEQUENCE_ID_SPECIFIED()), Level.FINE);
        }
        if (this.outboundMap.get(sequenceID) != null) {
            throw LOGGER.logException(new IllegalArgumentException(LocalizationMessages.WSRM_2016_SEQUENCE_ALREADY_EXISTS(sequenceID)), Level.FINE);
        }
        if (companionSequenceID != null && this.inboundMap.get(companionSequenceID) != null) {
            throw LOGGER.logException(new IllegalArgumentException(LocalizationMessages.WSRM_2016_SEQUENCE_ALREADY_EXISTS(companionSequenceID)), Level.FINE);
        }
        this.addOutboundSequence(seq);
        return seq;
    }

    public ClientOutboundSequence getOutboundSequence(String id) {
        return this.outboundMap.get(id);
    }

    public ClientInboundSequence getInboundSequence(String id) {
        return this.inboundMap.get(id);
    }
}

