/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.TemplateUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.cache.EntryCacheImpl;
import com.fr.fs.fun.OutputFormatProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.web.platform.entry.FileEntry;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.io.exporter.ImageExporter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.workbook.AnalyRWorkBook;
import com.fr.main.workbook.AnalyWorkBook;
import com.fr.main.workbook.PageRWorkBook;
import com.fr.main.workbook.PageWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.ExportImageProcessor;
import com.fr.schedule.output.ClassOutputFileAction;
import com.fr.schedule.output.DefaultOutputFileFormat;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FTPTransmission;
import com.fr.schedule.output.FileActionList;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.PrintRWorkbookAction;
import com.fr.schedule.output.PushOutputFileAction;
import com.fr.schedule.plugin.ExtraPlatformScheduleClassManager;
import com.fr.schedule.plugin.OutputFileActionProvider;
import com.fr.schedule.util.ScheduleConstants;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledOutput
implements XMLable {
    public static final String XML_TAG = "ScheduleOutput";
    public static final String TABLE_NAME = "fr_schedule_output";
    private int DEFAULT_PREVIEW_IMAGE_DPI = 200;
    public static final long HIDE_FILEENTRY_PARENTID = -1L;
    private static FRLogger log = FRLogger.getLogger();
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(ScheduledOutput.class, new Table("fr_schedule_output"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, "id", new ColumnSize(20), false, true), new CommonFieldColumnMapper("baseFileName", 12, "base_name", new ColumnSize(255), true), new CommonFieldColumnMapper("description", 12, "description", new ColumnSize(255), true), new CommonFieldColumnMapper("folderEntryId", 4, "folderEntryId", new ColumnSize(20), true), new CommonFieldColumnMapper("isCreateCPRByUsername", 16, "isCreateCPRByUsername", new ColumnSize(20), true), new CommonFieldColumnMapper("isSendEmailByUsername", 16, "isSendEmailByUsername", new ColumnSize(20), true), new CommonFieldColumnMapper("usernames", 12, "usernames", new ColumnSize(1023), true), new CommonFieldColumnMapper("outputFileFormat", 4, "format", new ColumnSize(10), true, new FCValueMapper(){

        public Object value2Field(Object object) {
            OutputFormatProcessor outputFormatProcessor = (OutputFormatProcessor)ExtraPlatformClassManager.getInstance().getSingle("OutputFormatProcessor");
            if (outputFormatProcessor == null) {
                outputFormatProcessor = new DefaultOutputFileFormat();
            }
            if (object == null) {
                return outputFormatProcessor;
            }
            outputFormatProcessor.setFormat(((Number)object).intValue());
            return outputFormatProcessor;
        }

        public Object field2Value(Object object) {
            OutputFormatProcessor outputFormatProcessor = (OutputFormatProcessor)ExtraPlatformClassManager.getInstance().getSingle("OutputFormatProcessor");
            if (outputFormatProcessor == null) {
                outputFormatProcessor = new DefaultOutputFileFormat();
            }
            if (object == null) {
                return outputFormatProcessor.getFormat();
            }
            try {
                return StableUtils.getPrivateFieldValue((Object)object, (String)"format");
            }
            catch (Exception exception) {
                ScheduleLogUtils.error(exception);
                return null;
            }
        }
    }), new CompatiableIDFCMapper(FileActionList.class, "outputFileActionList", -5, "ListId", new ColumnSize(20), true)}, 0);
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String baseFileName;
    private String description;
    private long folderEntryId = -1L;
    private OutputFormatProcessor outputFileFormat;
    private FileActionList outputFileActionList = null;
    private boolean isCreateCPRByUsername;
    private boolean isSendEmailByUsername;
    private String usernames = "";
    private FileRepository fileRepository = new FileRepository();

    public ScheduledOutput() {
    }

    public ScheduledOutput(String string, String string2, FileRepository fileRepository, OutputFormatProcessor outputFormatProcessor, FileActionList fileActionList) {
        this.baseFileName = string;
        this.description = string2;
        this.fileRepository = fileRepository;
        this.outputFileFormat = outputFormatProcessor;
        this.outputFileActionList = fileActionList;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("id", this.getId());
        jSONObject2.put("baseFileName", (Object)this.getBaseFileName());
        jSONObject2.put("description", (Object)this.getDescription());
        jSONObject2.put("isCreateCPRByUsername", this.isCreateCPRByUsername);
        jSONObject2.put("isSendEmailByUsername", this.isSendEmailByUsername);
        jSONObject2.put("usernames", (Object)this.usernames);
        if (this.getFolderEntryId() > -1L) {
            jSONObject2.put("folderEntryId", (Object)("0" + this.getFolderEntryId()));
        }
        try {
            jSONObject = this.getOutputFileFormat().createJSON();
        }
        catch (Exception exception) {
            jSONObject = new JSONObject();
        }
        jSONObject2.put("outputFileFormat", (Object)jSONObject);
        if (this.getOutputFileActionList() != null) {
            this.synFileActionList();
            JSONObject jSONObject3 = new JSONObject();
            int n = this.getOutputFileActionList().size();
            for (int i = 0; i < n; ++i) {
                OutputFileAction outputFileAction = (OutputFileAction)this.getOutputFileActionList().get(i);
                String string = outputFileAction.getJsonTag();
                JSONObject jSONObject4 = outputFileAction.createJSONConfig();
                jSONObject3.put(string, (Object)jSONObject4);
            }
            jSONObject2.put("outputFileActionList", (Object)jSONObject3);
        }
        return jSONObject2;
    }

    public static ScheduledOutput analyzeJSON(JSONObject jSONObject) {
        try {
            ScheduledOutput scheduledOutput = null;
            if (jSONObject.length() == 0) {
                return null;
            }
            scheduledOutput = jSONObject.has("id") ? (ScheduledOutput)ScheduleContext.createDAOSession().load(ScheduledOutput.class, jSONObject.optLong("id")) : new ScheduledOutput();
            String string = jSONObject.getString("baseFileName");
            String string2 = jSONObject.getString("description");
            boolean bl = jSONObject.getBoolean("isCreateCPRByUsername");
            String string3 = jSONObject.getString("usernames");
            boolean bl2 = jSONObject.getBoolean("isSendEmailByUsername");
            long l = -1L;
            if (jSONObject.has("folderEntryId")) {
                l = jSONObject.optLong("folderEntryId");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("outputFileFormat");
            OutputFormatProcessor outputFormatProcessor = (OutputFormatProcessor)ExtraPlatformClassManager.getInstance().getSingle("OutputFormatProcessor");
            if (outputFormatProcessor == null) {
                outputFormatProcessor = new DefaultOutputFileFormat();
            }
            outputFormatProcessor.parseJSON(jSONObject2);
            FileActionList fileActionList = new FileActionList();
            if (jSONObject.has("outputFileActionList")) {
                ScheduledOutput.analysisOutputFileList(jSONObject, fileActionList);
            }
            scheduledOutput.setBaseFileName(string);
            scheduledOutput.setDescription(string2);
            scheduledOutput.setFolderEntryId(l);
            scheduledOutput.setOutputFileFormat(outputFormatProcessor);
            scheduledOutput.setOutputFileActionList(fileActionList);
            scheduledOutput.setCreateCPRByUsername(bl);
            scheduledOutput.setSendEmailByUsername(bl2);
            scheduledOutput.setUsernames(string3);
            return scheduledOutput;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
        }
        return null;
    }

    private static void analysisOutputFileList(JSONObject jSONObject, FileActionList fileActionList) throws JSONException {
        EmailNotification emailNotification = new EmailNotification();
        FTPTransmission fTPTransmission = new FTPTransmission();
        PrintRWorkbookAction printRWorkbookAction = new PrintRWorkbookAction();
        ClassOutputFileAction classOutputFileAction = new ClassOutputFileAction();
        PushOutputFileAction pushOutputFileAction = new PushOutputFileAction();
        JSONObject jSONObject2 = jSONObject.getJSONObject("outputFileActionList");
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, emailNotification, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, fTPTransmission, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, printRWorkbookAction, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, classOutputFileAction, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, pushOutputFileAction, fileActionList);
        ScheduledOutput.analysisExtraOutputFileList(jSONObject2, fileActionList);
    }

    private static void analysisExtraOutputFileList(JSONObject jSONObject, FileActionList fileActionList) {
        Set set = ExtraPlatformScheduleClassManager.getInstance().getArray("OutputFileActionProvider");
        for (OutputFileActionProvider outputFileActionProvider : set) {
            String string = outputFileActionProvider.classForOutputFileAction().getName();
            try {
                OutputFileAction outputFileAction = (OutputFileAction)GeneralUtils.classForName((String)string).newInstance();
                ScheduledOutput.dealWithOutputFileAction(jSONObject, outputFileAction, fileActionList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRLogger.getLogger().info("Schedule OutputFileAction:" + string + " is not exist");
            }
            catch (Exception exception) {
                FRLogger.getLogger().info("OutputFileAction:" + string + " init failed");
            }
        }
    }

    private static void dealWithOutputFileAction(JSONObject jSONObject, OutputFileAction outputFileAction, FileActionList fileActionList) throws JSONException {
        String string = outputFileAction.getJsonTag();
        if (jSONObject.has(string)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            fileActionList.addFileAction(outputFileAction.analyzeJSON(jSONObject2));
        }
    }

    public File[] exportReportFiles(PageWorkBook pageWorkBook, String string, File file) throws Exception {
        if (this.outputFileFormat == null) {
            return new File[0];
        }
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".cpr", string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ((PageRWorkBook)pageWorkBook).export((OutputStream)fileOutputStream);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        arrayList.add(file2);
        FileEntry fileEntry = new FileEntry(string2 + ".cpr", this.description, file2.getAbsolutePath());
        fileEntry.setParentId(this.folderEntryId);
        this.checkCPRExsists(fileEntry);
        if (this.folderEntryId != -1L && ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
            ScheduleLinkOutput scheduleLinkOutput = new ScheduleLinkOutput(this.id, fileEntry.getId());
            ScheduleContext.createDAOSession().saveOrUpdate((Object)scheduleLinkOutput);
            EntryCacheImpl.getInstance().cache(fileEntry);
        }
        this.dealWithOutputFiles(pageWorkBook, string, file, arrayList);
        this.dealWithEmailPreviewFile((ResultWorkBook)pageWorkBook, string, file, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void checkCPRExsists(FileEntry fileEntry) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("displayName", fileEntry.getDisplayName());
        hashMap.put("parentId", fileEntry.getParentId());
        List list = ScheduleContext.createDAOSession().listByFieldValues(FileEntry.class, hashMap);
        if (!list.isEmpty()) {
            FileEntry fileEntry2 = (FileEntry)list.get(list.size() - 1);
            fileEntry.setId(fileEntry2.getId());
        }
    }

    private void dealWithOutputFiles(PageWorkBook pageWorkBook, String string, File file, List<File> list) throws Exception {
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        this.outputFileFormat.output((ResultWorkBook)pageWorkBook, file, string, string3, string2, this.description, list);
    }

    private void dealWithEmailPreviewFile(ResultWorkBook resultWorkBook, String string, File file, List<File> list) throws Exception {
        String string2 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        EmailNotification emailNotification = null;
        if (this.outputFileActionList != null) {
            emailNotification = this.outputFileActionList.getEmailNotification();
        }
        if (emailNotification != null && emailNotification.getCanPreviewAttach().booleanValue()) {
            ExportImageProcessor exportImageProcessor = (ExportImageProcessor)ExtraClassManager.getInstance().getSingle("ExportImageProcessor");
            if (exportImageProcessor == null) {
                this.exportImage(resultWorkBook, file, list, string2, 96);
            } else {
                exportImageProcessor.exportImageWithEmail((Object)resultWorkBook, file, list, this.baseFileName, (ExportImageProcessor.Callback)new ExportImageProcessor.Callback<List<File>, File>(){

                    public void callback(List<File> list, File file) {
                        try {
                            ScheduledOutput.this.addExportFiles(list, file);
                        }
                        catch (Exception exception) {
                            FRLogger.getLogger().error(exception.getMessage());
                        }
                    }
                });
            }
        }
    }

    private void exportImage(ResultWorkBook resultWorkBook, File file, List<File> list, String string, int n) throws Exception {
        File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".png", string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        new ImageExporter("png", n).export((OutputStream)fileOutputStream, resultWorkBook);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        this.addExportFiles(list, file2);
    }

    public void addExportFiles(List<File> list, File file) throws Exception {
        list.add(file);
        String string = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        FileEntry fileEntry = new FileEntry(string + ".png", this.description, file.getAbsolutePath());
        fileEntry.setParentId(-1L);
        if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
            EntryCacheImpl.getInstance().cache(fileEntry);
        }
    }

    public File[] exportAnalyReportFiles(AnalyWorkBook analyWorkBook, String string, File file) throws Exception {
        if (this.outputFileFormat == null) {
            return new File[0];
        }
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".cpr", string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ((AnalyRWorkBook)analyWorkBook).export((OutputStream)fileOutputStream);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        arrayList.add(file2);
        FileEntry fileEntry = new FileEntry(string2 + ".cpr", this.description, file2.getAbsolutePath());
        fileEntry.setParentId(this.folderEntryId);
        this.checkCPRExsists(fileEntry);
        if (this.folderEntryId != -1L && ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
            ScheduleLinkOutput scheduleLinkOutput = new ScheduleLinkOutput(this.id, fileEntry.getId());
            ScheduleContext.createDAOSession().saveOrUpdate((Object)scheduleLinkOutput);
            EntryCacheImpl.getInstance().cache(fileEntry);
        }
        this.dealWithAnalyOutputFiles(analyWorkBook, string, file, arrayList);
        this.dealWithEmailPreviewFile((ResultWorkBook)analyWorkBook, string, file, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void dealWithAnalyOutputFiles(AnalyWorkBook analyWorkBook, String string, File file, List<File> list) throws Exception {
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        this.outputFileFormat.output((ResultWorkBook)analyWorkBook, file, string, string3, string2, this.description, list);
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setBaseFileName(String string) {
        this.baseFileName = string;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFolderEntryId(long l) {
        this.folderEntryId = l;
    }

    public long getFolderEntryId() {
        return this.folderEntryId;
    }

    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public FileRepository getFileRepository() {
        return this.fileRepository;
    }

    public void setOutputFileFormat(OutputFormatProcessor outputFormatProcessor) {
        this.outputFileFormat = outputFormatProcessor;
    }

    public OutputFormatProcessor getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileActionList(FileActionList fileActionList) {
        if (this.id != 0L && this.outputFileActionList != null) {
            int n = this.outputFileActionList.size();
            for (int i = 0; i < n; ++i) {
                OutputFileAction outputFileAction = (OutputFileAction)this.outputFileActionList.get(i);
                ScheduleContext.createDAOSession().deleteByPrimaryKey(outputFileAction.getClass(), outputFileAction.getId());
            }
        }
        this.outputFileActionList = fileActionList;
    }

    public FileActionList getOutputFileActionList() {
        return this.outputFileActionList;
    }

    public void synFileActionList() {
        if (this.outputFileActionList != null) {
            this.outputFileActionList.synFileActionList();
        }
    }

    public static File generateUnExsitFile(File file, String string, String string2, String string3) {
        File file2 = new File(file, string3 + string2);
        while (file2.exists()) {
            file2 = new File(file, string + "_" + DateUtils.getDate2AllIncludeSSS((Date)new Date()) + "_" + ScheduleConstants.RANDOM.nextInt(1000) + string2);
        }
        return file2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("baseFileName", null);
            if (string != null) {
                this.setBaseFileName(string);
            }
            if ((string = xMLableReader.getAttrAsString("description", null)) != null) {
                this.setDescription(string);
            }
        } else if (xMLableReader.isChildNode() && "FileRepository".equals(xMLableReader.getTagName())) {
            this.fileRepository = (FileRepository)xMLableReader.readXMLObject((XMLReadable)new FileRepository());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("baseFileName", this.baseFileName).attr("description", this.description);
        if (this.fileRepository != null) {
            this.fileRepository.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduledOutput)) {
            return false;
        }
        ScheduledOutput scheduledOutput = (ScheduledOutput)object;
        return ComparatorUtils.equals((String)this.baseFileName, (String)scheduledOutput.baseFileName) && ComparatorUtils.equals((String)this.description, (String)scheduledOutput.description) && ComparatorUtils.equals((Object)this.fileRepository, (Object)scheduledOutput.fileRepository) && ComparatorUtils.equals((Object)this.outputFileFormat, (Object)scheduledOutput.outputFileFormat) && ComparatorUtils.equals((Object)this.outputFileActionList, (Object)scheduledOutput.outputFileActionList);
    }

    public Object clone() throws CloneNotSupportedException {
        ScheduledOutput scheduledOutput = (ScheduledOutput)super.clone();
        if (this.fileRepository != null) {
            scheduledOutput.setFileRepository((FileRepository)this.fileRepository.clone());
        }
        if (this.outputFileFormat != null) {
            scheduledOutput.setOutputFileFormat((OutputFormatProcessor)this.outputFileFormat.clone());
        }
        if (this.outputFileActionList != null) {
            scheduledOutput.setOutputFileActionList((FileActionList)this.outputFileActionList.clone());
        }
        return scheduledOutput;
    }

    public String fileNameForWindows(String string) {
        string = string.replaceAll(":", "\uff1a");
        string = string.replaceAll("\\*", "");
        string = string.replaceAll("\"", "");
        string = string.replaceAll("/", "");
        string = string.replaceAll("\\\\", "");
        string = string.replaceAll(">", "");
        string = string.replaceAll("<", "");
        string = string.replaceAll("\\?", "");
        string = string.replaceAll("|", "");
        return string;
    }

    public String getUsernames() {
        return this.usernames;
    }

    public void setUsernames(String string) {
        this.usernames = string;
    }

    public boolean isSendEmailByUsername() {
        return this.isSendEmailByUsername;
    }

    public void setSendEmailByUsername(boolean bl) {
        this.isSendEmailByUsername = bl;
    }

    public boolean isCreateCPRByUsername() {
        return this.isCreateCPRByUsername;
    }

    public void setCreateCPRByUsername(boolean bl) {
        this.isCreateCPRByUsername = bl;
    }
}

