/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CompanyRoleCacheImpl;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetCompanyRoleAuthAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l;
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l2, 18L)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id");
        if (StringUtils.isEmpty((String)string)) {
            String string2;
            long l3;
            long l4 = Long.valueOf(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"departmentId"));
            l = this.getRoleId(l4, l3 = StringUtils.isEmpty((String)(string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"postId"))) ? CompanyRoleControl.getInstance().getPostAllID() : Long.valueOf(string2).longValue());
            if (l < 0L) {
                CompanyRole companyRole = new CompanyRole(l3, l4, "");
                CompanyRoleControl.getInstance().addCompanyRole(companyRole);
                l = companyRole.getId();
            }
        } else {
            l = Long.valueOf(string);
        }
        JSONObject jSONObject = this.getCompanyRolePrivileges(l, l2);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public JSONObject getCompanyRolePrivileges(long l, long l2) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("reports", (Object)(this.getAllEntryPrivilege(l, l2) + ""));
        jSONObject.put("modules", (Object)(this.getAllModulePrivilege(l, l2) + ""));
        jSONObject.put("depandcroles", (Collection)this.getAllDepAndCRolePrivilege(l, l2));
        jSONObject.put("templates", (Object)(this.getAllTemplatePrivileges(l, l2) + ""));
        jSONObject.put("dataconnections", this.getAllDataConnectionPrivileges(l, l2));
        jSONObject.put("homepages", (Object)(this.getAllHomePagePrivilege(l, l2) + ""));
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            jSONObject.put(string, (Collection)CompanyRoleCacheImpl.getInstance().getAllPrivilegesWithPlateName(l, string));
        }
        return jSONObject;
    }

    private List getAllEntryPrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<EntryTypeAndID> list = CompanyRoleControl.getInstance().getAllEntryPrivileges(l);
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        for (EntryTypeAndID entryTypeAndID : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasEntryPrivilege(set, entryTypeAndID)) continue;
            linkedList.add(entryTypeAndID.toJSONObject());
        }
        return linkedList;
    }

    private List getAllModulePrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleModulePrivilege> list = CompanyRoleControl.getInstance().getAllModulePrivileges(l);
        Set set = UserControl.getInstance().getAllModulePrivileges(l2);
        for (RoleModulePrivilege roleModulePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set, roleModulePrivilege)) continue;
            linkedList.add(roleModulePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasEntryPrivilege(Set<EntryTypeAndID> set, EntryTypeAndID entryTypeAndID) {
        for (EntryTypeAndID entryTypeAndID2 : set) {
            if (entryTypeAndID2.getView() == 0L || entryTypeAndID2.getType() != entryTypeAndID.getType() || entryTypeAndID2.getId() != entryTypeAndID.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean hasModulePrivilege(Set<RoleModulePrivilege> set, RoleModulePrivilege roleModulePrivilege) {
        for (RoleModulePrivilege roleModulePrivilege2 : set) {
            if (roleModulePrivilege2.getModuleid() != roleModulePrivilege.getModuleid()) continue;
            return true;
        }
        return false;
    }

    private List<JSONObject> getAllHomePagePrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleHomePagePrivilege> list = CompanyRoleControl.getInstance().getAllHomePagePrivileges(l);
        Set<RoleHomePagePrivilege> set = UserControl.getInstance().getAllHomePagePrivileges(l2);
        for (RoleHomePagePrivilege roleHomePagePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasHomePagePrivilege(set, roleHomePagePrivilege)) continue;
            linkedList.add(roleHomePagePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasHomePagePrivilege(Set<RoleHomePagePrivilege> set, RoleHomePagePrivilege roleHomePagePrivilege) {
        for (RoleHomePagePrivilege roleHomePagePrivilege2 : set) {
            if (roleHomePagePrivilege2.getHomePageId() != roleHomePagePrivilege.getHomePageId()) continue;
            return true;
        }
        return false;
    }

    private List getAllDepAndCRolePrivilege(long l, long l2) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List<String> list = CompanyRoleControl.getInstance().getAllDepAndCRolePrivileges(l);
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l2);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.has("departmentid")) {
                linkedList2.add("1" + jSONObject.getLong("departmentid"));
                continue;
            }
            linkedList2.add("2" + jSONObject.getLong("id"));
        }
        for (String string : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList2.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    private List<JSONObject> getAllTemplatePrivileges(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleTemplatePrivilege> list = CompanyRoleControl.getInstance().getAllTemplatePrivileges(l);
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l2);
        for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(roleTemplatePrivilege.getPath(), set)) continue;
            linkedList.add(roleTemplatePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private List<String> getAllDataConnectionPrivileges(long l, long l2) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        Set<RoleDataConnectionPrivilege> set = CompanyRoleControl.getInstance().getAllDataConnectionPrivileges(l);
        Set<RoleDataConnectionPrivilege> set2 = UserControl.getInstance().getAllDataConnectionPrivileges(l2);
        for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set2.contains((Object)roleDataConnectionPrivilege)) continue;
            linkedList.add(roleDataConnectionPrivilege.getName());
        }
        return linkedList;
    }

    public String getCMD() {
        return "auth_getjroleauth";
    }

    private long getRoleId(long l, long l2) throws Exception {
        Long[] longArray = new Long[]{l};
        List<CompanyRole> list = l2 == CompanyRoleControl.getInstance().getPostAllID() || l == CompanyRoleControl.getInstance().getDepartmentAllID() ? FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(l2, longArray) : CompanyRoleControl.getInstance().getJRole(l, l2);
        if (list == null || list.isEmpty()) {
            return -1L;
        }
        CompanyRole companyRole = list.get(0);
        for (CompanyRole companyRole2 : list) {
            if (companyRole2.getDepartmentId() != l || companyRole2.getPostId() != l2) continue;
            companyRole = companyRole2;
            break;
        }
        return companyRole.getId();
    }
}

