/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.control.UserControl;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.FSPSIChangeCustomAction;
import com.fr.fs.web.service.FSPSIConfigAction;
import com.fr.fs.web.service.FSPSISetConfigAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.fun.FunctionHelper;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.fun.impl.AbstractFunctionProcessor;
import com.fr.web.NoPrivilegeException;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.WebActionsDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSPSIService
extends AbstractFSAuthService {
    private static final String PSI = "fs_psi";
    private static final String FUNCTION_NAME = "preventSqlInject";
    private ActionNoSessionCMD[] actions = new ActionNoSessionCMD[]{new FSPSIConfigAction(), new FSPSISetConfigAction(), new FSPSIChangeCustomAction()};
    private static final FunctionProcessor FUNCTION_RECORD = new AbstractFunctionProcessor(){

        public int getId() {
            return FunctionHelper.generateFunctionID((String)FSPSIService.FUNCTION_NAME);
        }

        public String getLocaleKey() {
            return "FS-PSqlInj_Title";
        }
    };

    public String actionOP() {
        return PSI;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (this.checkDispatch(httpServletRequest, httpServletResponse, string)) {
            return;
        }
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(FUNCTION_RECORD);
        }
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        WebActionsDispatcher.dealForActionNoSessionIDCMD((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (ActionNoSessionCMD[])this.actions);
    }
}

