/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule;

import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.ScheduleContextProvider;

public class ScheduleContextImpl
implements ScheduleContextProvider {
    private static ScheduleContextProvider scheduleContextProvider;

    public static ScheduleContextProvider getInstance() {
        if (scheduleContextProvider == null) {
            ScheduleContextImpl.initCache();
        }
        return scheduleContextProvider;
    }

    private static synchronized void initCache() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                scheduleContextProvider = new ScheduleContextImpl();
                RPC.registerSkeleton((Object)scheduleContextProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                scheduleContextProvider = (ScheduleContextProvider)RPC.getProxy(ScheduleContextImpl.class, (String)string);
                break;
            }
            default: {
                scheduleContextProvider = new ScheduleContextImpl();
            }
        }
    }

    public DataAccessObjectSession createDAOSession() {
        return ScheduleContext.getJdbcDaoManager().startSession();
    }
}

