/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.control.CustomRoleControl;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityRoleDBDAOManager {
    public static synchronized void updateOrAddAuthorityRole(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        Object object;
        int n;
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        CustomRole customRole = AuthorityRoleDBDAOManager.getCustomRole(string);
        if (customRole == null) {
            return;
        }
        long l = customRole.getId();
        List<RoleTemplatePrivilege> list = CustomRoleControl.getInstance().getAllTemplatePrivileges(l);
        if (!list.isEmpty()) {
            AuthorityRoleDBDAOManager.removeAuthorityRole(string);
        }
        HashMap<String, RoleTemplatePrivilege> hashMap = new HashMap<String, RoleTemplatePrivilege>();
        for (n = 0; n < stringArray.length; ++n) {
            AuthorityRoleDBDAOManager.bubblePrivilege(hashMap, stringArray[n], AuthType.view);
            AuthorityRoleDBDAOManager.sinkPrivilege(hashMap, stringArray[n], AuthType.view);
            AuthorityRoleDBDAOManager.bubble(hashMap, stringArray[n], AuthType.view);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            AuthorityRoleDBDAOManager.bubblePrivilege(hashMap, stringArray2[n], AuthType.write);
            AuthorityRoleDBDAOManager.sinkPrivilege(hashMap, stringArray2[n], AuthType.write);
            AuthorityRoleDBDAOManager.bubble(hashMap, stringArray2[n], AuthType.write);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            AuthorityRoleDBDAOManager.bubblePrivilege(hashMap, stringArray3[n], AuthType.design);
            AuthorityRoleDBDAOManager.sinkPrivilege(hashMap, stringArray3[n], AuthType.design);
            AuthorityRoleDBDAOManager.bubble(hashMap, stringArray3[n], AuthType.design);
        }
        JSONObject jSONObject = JSONObject.create();
        JSONArray jSONArray = JSONArray.create();
        jSONObject.put("add", (Object)jSONArray);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (RoleTemplatePrivilege)((Object)hashMap.get(iterator.next()));
            jSONArray.put((Object)((RoleTemplatePrivilege)((Object)object)).toJSONObject());
        }
        object = AuthorityRoleDBDAOManager.string2TemplateSet(jSONObject.getString("add"));
        CustomRoleControl.getInstance().updateTemplatePrivileges(l, (Set<RoleTemplatePrivilege>)object, new HashSet<RoleTemplatePrivilege>());
        FRLogger.getLogger().info(jSONObject.getString("add"));
    }

    private static void sinkPrivilege(Map<String, RoleTemplatePrivilege> map, String string, AuthType authType) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", string});
        File file = new File(string2);
        if (file.isDirectory()) {
            List<String> list = AuthorityRoleDBDAOManager.getFileList(string2);
            for (String string3 : list) {
                string3.replace("\\", "/");
                String string4 = string3.replace(StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets/"}), "");
                AuthorityRoleDBDAOManager.initAndPutPrivilege(map, string4, authType);
            }
        }
        AuthorityRoleDBDAOManager.initAndPutPrivilege(map, string, authType);
    }

    private static void initAndPutPrivilege(Map<String, RoleTemplatePrivilege> map, String string, AuthType authType) {
        RoleTemplatePrivilege roleTemplatePrivilege = map.get(string) == null ? new RoleTemplatePrivilege() : map.get(string);
        roleTemplatePrivilege.setPath(string);
        switch (authType) {
            case view: {
                roleTemplatePrivilege.setPage(1L);
                break;
            }
            case write: {
                roleTemplatePrivilege.setWrite(1L);
                break;
            }
            case design: {
                roleTemplatePrivilege.setDesign(1L);
                roleTemplatePrivilege.setWrite(1L);
                roleTemplatePrivilege.setPage(1L);
            }
        }
        map.put(string, roleTemplatePrivilege);
    }

    private static void bubblePrivilege(Map<String, RoleTemplatePrivilege> map, String string, AuthType authType) {
        if (StringUtils.isEmpty((String)string) || !string.contains("/")) {
            return;
        }
        String string2 = string.substring(0, string.lastIndexOf("/"));
        if (StringUtils.isEmpty((String)string2)) {
            return;
        }
        RoleTemplatePrivilege roleTemplatePrivilege = map.get(string2) == null ? new RoleTemplatePrivilege() : map.get(string2);
        roleTemplatePrivilege.setPath(string2);
        switch (authType) {
            case view: {
                roleTemplatePrivilege.setPage(2L);
                break;
            }
            case write: {
                roleTemplatePrivilege.setWrite(2L);
                break;
            }
            case design: {
                roleTemplatePrivilege.setDesign(2L);
            }
        }
        map.put(string2, roleTemplatePrivilege);
        if (string2.contains("/")) {
            AuthorityRoleDBDAOManager.bubblePrivilege(map, string2, authType);
        }
    }

    private static void bubble(Map<String, RoleTemplatePrivilege> map, String string, AuthType authType) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", string});
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        String string3 = file.getParent();
        List<String> list = AuthorityRoleDBDAOManager.getFileList(string3);
        int n = 0;
        Set<String> set = map.keySet();
        if (!string.contains("/")) {
            return;
        }
        boolean bl = false;
        for (String string4 : set) {
            String string5;
            if (!string4.startsWith(string5 = string.substring(0, string.lastIndexOf("/"))) || ++n != list.size()) continue;
            bl = true;
            switch (authType) {
                case view: {
                    map.get(string4).setPage(1L);
                    break;
                }
                case write: {
                    map.get(string4).setWrite(1L);
                    break;
                }
                case design: {
                    map.get(string4).setDesign(1L);
                    map.get(string4).setWrite(1L);
                    map.get(string4).setPage(1L);
                }
            }
            break;
        }
        if (bl) {
            AuthorityRoleDBDAOManager.bubble(map, string.substring(0, string.lastIndexOf("/")), authType);
        }
    }

    private static List<String> getFileList(String string) {
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)string)) {
            return arrayList;
        }
        arrayList.add(new File(string).getAbsolutePath().replace("\\", "/"));
        File file = new File(string);
        if (file.isDirectory() && null != (fileArray = file.listFiles()) && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) {
                    arrayList.add(file2.getAbsolutePath().replace("\\", "/"));
                    continue;
                }
                arrayList.addAll(AuthorityRoleDBDAOManager.getFileList(file2.getAbsolutePath()));
            }
        }
        return arrayList;
    }

    private static Set string2TemplateSet(String string) throws JSONException {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)string);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            String string2 = jSONObject.getString("path");
            long l = jSONObject.has("page") ? jSONObject.getLong("page") : 0L;
            long l2 = jSONObject.has("write") ? jSONObject.getLong("write") : 0L;
            long l3 = jSONObject.has("design") ? jSONObject.getLong("design") : 0L;
            RoleTemplatePrivilege roleTemplatePrivilege = new RoleTemplatePrivilege(string2, l, l2, l3);
            hashSet.add(roleTemplatePrivilege);
        }
        return hashSet;
    }

    public static synchronized void removeAllAuthorityRole() throws Exception {
        CustomRoleControl.getInstance().removeAllTemplatePrivileges();
    }

    public static synchronized void removeAuthorityRole(String string) throws Exception {
        CustomRole customRole = AuthorityRoleDBDAOManager.getCustomRole(string);
        if (customRole == null) {
            return;
        }
        CustomRoleControl.getInstance().removeTemplatePrivileges(customRole.getId());
    }

    public static synchronized boolean changeAuthorityRoleName(String string, String string2) throws Exception {
        CustomRole customRole = AuthorityRoleDBDAOManager.getCustomRole(string);
        if (customRole == null) {
            return false;
        }
        CustomRoleControl.getInstance().updateCustomRoleName(customRole.getId(), string2);
        return false;
    }

    public static synchronized List<RoleTemplatePrivilege> getAuthorityAllocation(String string) throws Exception {
        CustomRole customRole = AuthorityRoleDBDAOManager.getCustomRole(string);
        if (customRole == null) {
            return null;
        }
        return CustomRoleControl.getInstance().getAllTemplatePrivileges(customRole.getId());
    }

    public static synchronized void clearAuthorityAllocation() throws Exception {
    }

    private static CustomRole getCustomRole(String string) throws Exception {
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!ComparatorUtils.equals((String)customRole.getRolename(), (String)string)) continue;
            return customRole;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AuthType {
        view,
        write,
        design;

    }
}

